/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueueName {
    QUANTUM_TASKS_QUEUE("QUANTUM_TASKS_QUEUE"),
    JOBS_QUEUE("JOBS_QUEUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueueName> VALUE_MAP;
    private final String value;

    private QueueName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueueName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueueName> knownValues() {
        EnumSet<QueueName> knownValues = EnumSet.allOf(QueueName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueueName.class, QueueName::toString);
    }
}

