/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.braket.BraketClient;
import software.amazon.awssdk.services.braket.BraketClientBuilder;
import software.amazon.awssdk.services.braket.BraketServiceClientConfiguration;
import software.amazon.awssdk.services.braket.DefaultBraketBaseClientBuilder;
import software.amazon.awssdk.services.braket.DefaultBraketClient;
import software.amazon.awssdk.services.braket.endpoints.BraketEndpointProvider;

@SdkInternalApi
final class DefaultBraketClientBuilder
extends DefaultBraketBaseClientBuilder<BraketClientBuilder, BraketClient>
implements BraketClientBuilder {
    DefaultBraketClientBuilder() {
    }

    @Override
    public DefaultBraketClientBuilder endpointProvider(BraketEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final BraketClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultBraketClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        BraketServiceClientConfiguration serviceClientConfiguration = BraketServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultBraketClient(serviceClientConfiguration, clientConfiguration);
    }
}

