/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.DataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputFileConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputFileConfig> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelName").getter(InputFileConfig.getter(InputFileConfig::channelName)).setter(InputFileConfig.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(InputFileConfig.getter(InputFileConfig::contentType)).setter(InputFileConfig.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSource").getter(InputFileConfig.getter(InputFileConfig::dataSource)).setter(InputFileConfig.setter(Builder::dataSource)).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD, CONTENT_TYPE_FIELD, DATA_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String channelName;
    private final String contentType;
    private final DataSource dataSource;

    private InputFileConfig(BuilderImpl builder) {
        this.channelName = builder.channelName;
        this.contentType = builder.contentType;
        this.dataSource = builder.dataSource;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final DataSource dataSource() {
        return this.dataSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputFileConfig)) {
            return false;
        }
        InputFileConfig other = (InputFileConfig)obj;
        return Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.dataSource(), other.dataSource());
    }

    public final String toString() {
        return ToString.builder((String)"InputFileConfig").add("ChannelName", (Object)this.channelName()).add("ContentType", (Object)this.contentType()).add("DataSource", (Object)this.dataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "dataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputFileConfig, T> g) {
        return obj -> g.apply((InputFileConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelName;
        private String contentType;
        private DataSource dataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(InputFileConfig model) {
            this.channelName(model.channelName);
            this.contentType(model.contentType);
            this.dataSource(model.dataSource);
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final DataSource.Builder getDataSource() {
            return this.dataSource != null ? this.dataSource.toBuilder() : null;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public InputFileConfig build() {
            return new InputFileConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputFileConfig> {
        public Builder channelName(String var1);

        public Builder contentType(String var1);

        public Builder dataSource(DataSource var1);

        default public Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return this.dataSource((DataSource)((DataSource.Builder)DataSource.builder().applyMutation(dataSource)).build());
        }
    }
}

