/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.braket.model.JobEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobEventDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobEventDetails> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(JobEventDetails.getter(JobEventDetails::eventTypeAsString)).setter(JobEventDetails.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(JobEventDetails.getter(JobEventDetails::message)).setter(JobEventDetails.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Instant> TIME_OF_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timeOfEvent").getter(JobEventDetails.getter(JobEventDetails::timeOfEvent)).setter(JobEventDetails.setter(Builder::timeOfEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeOfEvent").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD, MESSAGE_FIELD, TIME_OF_EVENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventType;
    private final String message;
    private final Instant timeOfEvent;

    private JobEventDetails(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.message = builder.message;
        this.timeOfEvent = builder.timeOfEvent;
    }

    public final JobEventType eventType() {
        return JobEventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final String message() {
        return this.message;
    }

    public final Instant timeOfEvent() {
        return this.timeOfEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOfEvent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobEventDetails)) {
            return false;
        }
        JobEventDetails other = (JobEventDetails)obj;
        return Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.timeOfEvent(), other.timeOfEvent());
    }

    public final String toString() {
        return ToString.builder((String)"JobEventDetails").add("EventType", (Object)this.eventTypeAsString()).add("Message", (Object)this.message()).add("TimeOfEvent", (Object)this.timeOfEvent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "timeOfEvent": {
                return Optional.ofNullable(clazz.cast(this.timeOfEvent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobEventDetails, T> g) {
        return obj -> g.apply((JobEventDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventType;
        private String message;
        private Instant timeOfEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(JobEventDetails model) {
            this.eventType(model.eventType);
            this.message(model.message);
            this.timeOfEvent(model.timeOfEvent);
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        @Transient
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        @Transient
        public final Builder eventType(JobEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getTimeOfEvent() {
            return this.timeOfEvent;
        }

        public final void setTimeOfEvent(Instant timeOfEvent) {
            this.timeOfEvent = timeOfEvent;
        }

        @Override
        @Transient
        public final Builder timeOfEvent(Instant timeOfEvent) {
            this.timeOfEvent = timeOfEvent;
            return this;
        }

        public JobEventDetails build() {
            return new JobEventDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobEventDetails> {
        public Builder eventType(String var1);

        public Builder eventType(JobEventType var1);

        public Builder message(String var1);

        public Builder timeOfEvent(Instant var1);
    }
}

