/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.braket.BraketAsyncClient;
import software.amazon.awssdk.services.braket.model.QuantumTaskSummary;
import software.amazon.awssdk.services.braket.model.SearchQuantumTasksRequest;
import software.amazon.awssdk.services.braket.model.SearchQuantumTasksResponse;

public class SearchQuantumTasksPublisher
implements SdkPublisher<SearchQuantumTasksResponse> {
    private final BraketAsyncClient client;
    private final SearchQuantumTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchQuantumTasksPublisher(BraketAsyncClient client, SearchQuantumTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchQuantumTasksPublisher(BraketAsyncClient client, SearchQuantumTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchQuantumTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchQuantumTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QuantumTaskSummary> quantumTasks() {
        Function<SearchQuantumTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.quantumTasks() != null) {
                return response.quantumTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchQuantumTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchQuantumTasksResponseFetcher
    implements AsyncPageFetcher<SearchQuantumTasksResponse> {
        private SearchQuantumTasksResponseFetcher() {
        }

        public boolean hasNextPage(SearchQuantumTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchQuantumTasksResponse> nextPage(SearchQuantumTasksResponse previousPage) {
            if (previousPage == null) {
                return SearchQuantumTasksPublisher.this.client.searchQuantumTasks(SearchQuantumTasksPublisher.this.firstRequest);
            }
            return SearchQuantumTasksPublisher.this.client.searchQuantumTasks((SearchQuantumTasksRequest)((Object)SearchQuantumTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

