/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.AttributeValueListCopier;
import software.amazon.awssdk.services.billingconductor.model.LineItemFilterAttributeName;
import software.amazon.awssdk.services.billingconductor.model.LineItemFilterValue;
import software.amazon.awssdk.services.billingconductor.model.LineItemFilterValuesListCopier;
import software.amazon.awssdk.services.billingconductor.model.MatchOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineItemFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineItemFilter> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Attribute").getter(LineItemFilter.getter(LineItemFilter::attributeAsString)).setter(LineItemFilter.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final SdkField<String> MATCH_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchOption").getter(LineItemFilter.getter(LineItemFilter::matchOptionAsString)).setter(LineItemFilter.setter(Builder::matchOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOption").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(LineItemFilter.getter(LineItemFilter::valuesAsStrings)).setter(LineItemFilter.setter(Builder::valuesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeValues").getter(LineItemFilter.getter(LineItemFilter::attributeValues)).setter(LineItemFilter.setter(Builder::attributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, MATCH_OPTION_FIELD, VALUES_FIELD, ATTRIBUTE_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LineItemFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final String matchOption;
    private final List<String> values;
    private final List<String> attributeValues;

    private LineItemFilter(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.matchOption = builder.matchOption;
        this.values = builder.values;
        this.attributeValues = builder.attributeValues;
    }

    public final LineItemFilterAttributeName attribute() {
        return LineItemFilterAttributeName.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    public final MatchOption matchOption() {
        return MatchOption.fromValue(this.matchOption);
    }

    public final String matchOptionAsString() {
        return this.matchOption;
    }

    public final List<LineItemFilterValue> values() {
        return LineItemFilterValuesListCopier.copyStringToEnum(this.values);
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> valuesAsStrings() {
        return this.values;
    }

    public final boolean hasAttributeValues() {
        return this.attributeValues != null && !(this.attributeValues instanceof SdkAutoConstructList);
    }

    public final List<String> attributeValues() {
        return this.attributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.valuesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeValues() ? this.attributeValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineItemFilter)) {
            return false;
        }
        LineItemFilter other = (LineItemFilter)obj;
        return Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.matchOptionAsString(), other.matchOptionAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.valuesAsStrings(), other.valuesAsStrings()) && this.hasAttributeValues() == other.hasAttributeValues() && Objects.equals(this.attributeValues(), other.attributeValues());
    }

    public final String toString() {
        return ToString.builder((String)"LineItemFilter").add("Attribute", (Object)this.attributeAsString()).add("MatchOption", (Object)this.matchOptionAsString()).add("Values", this.hasValues() ? this.valuesAsStrings() : null).add("AttributeValues", this.hasAttributeValues() ? this.attributeValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "MatchOption": {
                return Optional.ofNullable(clazz.cast(this.matchOptionAsString()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.valuesAsStrings()));
            }
            case "AttributeValues": {
                return Optional.ofNullable(clazz.cast(this.attributeValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("MatchOption", MATCH_OPTION_FIELD);
        map.put("Values", VALUES_FIELD);
        map.put("AttributeValues", ATTRIBUTE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineItemFilter, T> g) {
        return obj -> g.apply((LineItemFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String matchOption;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private List<String> attributeValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LineItemFilter model) {
            this.attribute(model.attribute);
            this.matchOption(model.matchOption);
            this.valuesWithStrings(model.values);
            this.attributeValues(model.attributeValues);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(LineItemFilterAttributeName attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final String getMatchOption() {
            return this.matchOption;
        }

        public final void setMatchOption(String matchOption) {
            this.matchOption = matchOption;
        }

        @Override
        public final Builder matchOption(String matchOption) {
            this.matchOption = matchOption;
            return this;
        }

        @Override
        public final Builder matchOption(MatchOption matchOption) {
            this.matchOption(matchOption == null ? null : matchOption.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = LineItemFilterValuesListCopier.copy(values);
        }

        @Override
        public final Builder valuesWithStrings(Collection<String> values) {
            this.values = LineItemFilterValuesListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valuesWithStrings(String ... values) {
            this.valuesWithStrings(Arrays.asList(values));
            return this;
        }

        @Override
        public final Builder values(Collection<LineItemFilterValue> values) {
            this.values = LineItemFilterValuesListCopier.copyEnumToString(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(LineItemFilterValue ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final Collection<String> getAttributeValues() {
            if (this.attributeValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeValues;
        }

        public final void setAttributeValues(Collection<String> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copy(attributeValues);
        }

        @Override
        public final Builder attributeValues(Collection<String> attributeValues) {
            this.attributeValues = AttributeValueListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(String ... attributeValues) {
            this.attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        public LineItemFilter build() {
            return new LineItemFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineItemFilter> {
        public Builder attribute(String var1);

        public Builder attribute(LineItemFilterAttributeName var1);

        public Builder matchOption(String var1);

        public Builder matchOption(MatchOption var1);

        public Builder valuesWithStrings(Collection<String> var1);

        public Builder valuesWithStrings(String ... var1);

        public Builder values(Collection<LineItemFilterValue> var1);

        public Builder values(LineItemFilterValue ... var1);

        public Builder attributeValues(Collection<String> var1);

        public Builder attributeValues(String ... var1);
    }
}

