/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.ComputationRuleEnum;
import software.amazon.awssdk.services.billingconductor.model.CurrencyCode;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemChargeDetails;
import software.amazon.awssdk.services.billingconductor.model.PresentationObject;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomLineItemListElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomLineItemListElement> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CustomLineItemListElement.getter(CustomLineItemListElement::arn)).setter(CustomLineItemListElement.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CustomLineItemListElement.getter(CustomLineItemListElement::name)).setter(CustomLineItemListElement.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<ListCustomLineItemChargeDetails> CHARGE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChargeDetails").getter(CustomLineItemListElement.getter(CustomLineItemListElement::chargeDetails)).setter(CustomLineItemListElement.setter(Builder::chargeDetails)).constructor(ListCustomLineItemChargeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeDetails").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(CustomLineItemListElement.getter(CustomLineItemListElement::currencyCodeAsString)).setter(CustomLineItemListElement.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CustomLineItemListElement.getter(CustomLineItemListElement::description)).setter(CustomLineItemListElement.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductCode").getter(CustomLineItemListElement.getter(CustomLineItemListElement::productCode)).setter(CustomLineItemListElement.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()}).build();
    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingGroupArn").getter(CustomLineItemListElement.getter(CustomLineItemListElement::billingGroupArn)).setter(CustomLineItemListElement.setter(Builder::billingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArn").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreationTime").getter(CustomLineItemListElement.getter(CustomLineItemListElement::creationTime)).setter(CustomLineItemListElement.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastModifiedTime").getter(CustomLineItemListElement.getter(CustomLineItemListElement::lastModifiedTime)).setter(CustomLineItemListElement.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Long> ASSOCIATION_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AssociationSize").getter(CustomLineItemListElement.getter(CustomLineItemListElement::associationSize)).setter(CustomLineItemListElement.setter(Builder::associationSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSize").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(CustomLineItemListElement.getter(CustomLineItemListElement::accountId)).setter(CustomLineItemListElement.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> COMPUTATION_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputationRule").getter(CustomLineItemListElement.getter(CustomLineItemListElement::computationRuleAsString)).setter(CustomLineItemListElement.setter(Builder::computationRule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationRule").build()}).build();
    private static final SdkField<PresentationObject> PRESENTATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PresentationDetails").getter(CustomLineItemListElement.getter(CustomLineItemListElement::presentationDetails)).setter(CustomLineItemListElement.setter(Builder::presentationDetails)).constructor(PresentationObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresentationDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, CHARGE_DETAILS_FIELD, CURRENCY_CODE_FIELD, DESCRIPTION_FIELD, PRODUCT_CODE_FIELD, BILLING_GROUP_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ASSOCIATION_SIZE_FIELD, ACCOUNT_ID_FIELD, COMPUTATION_RULE_FIELD, PRESENTATION_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomLineItemListElement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final ListCustomLineItemChargeDetails chargeDetails;
    private final String currencyCode;
    private final String description;
    private final String productCode;
    private final String billingGroupArn;
    private final Long creationTime;
    private final Long lastModifiedTime;
    private final Long associationSize;
    private final String accountId;
    private final String computationRule;
    private final PresentationObject presentationDetails;

    private CustomLineItemListElement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.chargeDetails = builder.chargeDetails;
        this.currencyCode = builder.currencyCode;
        this.description = builder.description;
        this.productCode = builder.productCode;
        this.billingGroupArn = builder.billingGroupArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.associationSize = builder.associationSize;
        this.accountId = builder.accountId;
        this.computationRule = builder.computationRule;
        this.presentationDetails = builder.presentationDetails;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final ListCustomLineItemChargeDetails chargeDetails() {
        return this.chargeDetails;
    }

    public final CurrencyCode currencyCode() {
        return CurrencyCode.fromValue(this.currencyCode);
    }

    public final String currencyCodeAsString() {
        return this.currencyCode;
    }

    public final String description() {
        return this.description;
    }

    public final String productCode() {
        return this.productCode;
    }

    public final String billingGroupArn() {
        return this.billingGroupArn;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Long associationSize() {
        return this.associationSize;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final ComputationRuleEnum computationRule() {
        return ComputationRuleEnum.fromValue(this.computationRule);
    }

    public final String computationRuleAsString() {
        return this.computationRule;
    }

    public final PresentationObject presentationDetails() {
        return this.presentationDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.chargeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationRuleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.presentationDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLineItemListElement)) {
            return false;
        }
        CustomLineItemListElement other = (CustomLineItemListElement)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.chargeDetails(), other.chargeDetails()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.productCode(), other.productCode()) && Objects.equals(this.billingGroupArn(), other.billingGroupArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.associationSize(), other.associationSize()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.computationRuleAsString(), other.computationRuleAsString()) && Objects.equals(this.presentationDetails(), other.presentationDetails());
    }

    public final String toString() {
        return ToString.builder((String)"CustomLineItemListElement").add("Arn", (Object)this.arn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ChargeDetails", (Object)this.chargeDetails()).add("CurrencyCode", (Object)this.currencyCodeAsString()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ProductCode", (Object)this.productCode()).add("BillingGroupArn", (Object)this.billingGroupArn()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("AssociationSize", (Object)this.associationSize()).add("AccountId", (Object)this.accountId()).add("ComputationRule", (Object)this.computationRuleAsString()).add("PresentationDetails", (Object)this.presentationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ChargeDetails": {
                return Optional.ofNullable(clazz.cast(this.chargeDetails()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "BillingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.billingGroupArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "AssociationSize": {
                return Optional.ofNullable(clazz.cast(this.associationSize()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ComputationRule": {
                return Optional.ofNullable(clazz.cast(this.computationRuleAsString()));
            }
            case "PresentationDetails": {
                return Optional.ofNullable(clazz.cast(this.presentationDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ChargeDetails", CHARGE_DETAILS_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        map.put("BillingGroupArn", BILLING_GROUP_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("AssociationSize", ASSOCIATION_SIZE_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ComputationRule", COMPUTATION_RULE_FIELD);
        map.put("PresentationDetails", PRESENTATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomLineItemListElement, T> g) {
        return obj -> g.apply((CustomLineItemListElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private ListCustomLineItemChargeDetails chargeDetails;
        private String currencyCode;
        private String description;
        private String productCode;
        private String billingGroupArn;
        private Long creationTime;
        private Long lastModifiedTime;
        private Long associationSize;
        private String accountId;
        private String computationRule;
        private PresentationObject presentationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLineItemListElement model) {
            this.arn(model.arn);
            this.name(model.name);
            this.chargeDetails(model.chargeDetails);
            this.currencyCode(model.currencyCode);
            this.description(model.description);
            this.productCode(model.productCode);
            this.billingGroupArn(model.billingGroupArn);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.associationSize(model.associationSize);
            this.accountId(model.accountId);
            this.computationRule(model.computationRule);
            this.presentationDetails(model.presentationDetails);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ListCustomLineItemChargeDetails.Builder getChargeDetails() {
            return this.chargeDetails != null ? this.chargeDetails.toBuilder() : null;
        }

        public final void setChargeDetails(ListCustomLineItemChargeDetails.BuilderImpl chargeDetails) {
            this.chargeDetails = chargeDetails != null ? chargeDetails.build() : null;
        }

        @Override
        public final Builder chargeDetails(ListCustomLineItemChargeDetails chargeDetails) {
            this.chargeDetails = chargeDetails;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getProductCode() {
            return this.productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final String getBillingGroupArn() {
            return this.billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Long getAssociationSize() {
            return this.associationSize;
        }

        public final void setAssociationSize(Long associationSize) {
            this.associationSize = associationSize;
        }

        @Override
        public final Builder associationSize(Long associationSize) {
            this.associationSize = associationSize;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getComputationRule() {
            return this.computationRule;
        }

        public final void setComputationRule(String computationRule) {
            this.computationRule = computationRule;
        }

        @Override
        public final Builder computationRule(String computationRule) {
            this.computationRule = computationRule;
            return this;
        }

        @Override
        public final Builder computationRule(ComputationRuleEnum computationRule) {
            this.computationRule(computationRule == null ? null : computationRule.toString());
            return this;
        }

        public final PresentationObject.Builder getPresentationDetails() {
            return this.presentationDetails != null ? this.presentationDetails.toBuilder() : null;
        }

        public final void setPresentationDetails(PresentationObject.BuilderImpl presentationDetails) {
            this.presentationDetails = presentationDetails != null ? presentationDetails.build() : null;
        }

        @Override
        public final Builder presentationDetails(PresentationObject presentationDetails) {
            this.presentationDetails = presentationDetails;
            return this;
        }

        public CustomLineItemListElement build() {
            return new CustomLineItemListElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomLineItemListElement> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder chargeDetails(ListCustomLineItemChargeDetails var1);

        default public Builder chargeDetails(Consumer<ListCustomLineItemChargeDetails.Builder> chargeDetails) {
            return this.chargeDetails((ListCustomLineItemChargeDetails)((ListCustomLineItemChargeDetails.Builder)ListCustomLineItemChargeDetails.builder().applyMutation(chargeDetails)).build());
        }

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCode var1);

        public Builder description(String var1);

        public Builder productCode(String var1);

        public Builder billingGroupArn(String var1);

        public Builder creationTime(Long var1);

        public Builder lastModifiedTime(Long var1);

        public Builder associationSize(Long var1);

        public Builder accountId(String var1);

        public Builder computationRule(String var1);

        public Builder computationRule(ComputationRuleEnum var1);

        public Builder presentationDetails(PresentationObject var1);

        default public Builder presentationDetails(Consumer<PresentationObject.Builder> presentationDetails) {
            return this.presentationDetails((PresentationObject)((PresentationObject.Builder)PresentationObject.builder().applyMutation(presentationDetails)).build());
        }
    }
}

