/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupStatus;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.services.billingconductor.model.UpdateBillingGroupAccountGrouping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBillingGroupResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, UpdateBillingGroupResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateBillingGroupResponse.getter(UpdateBillingGroupResponse::arn)).setter(UpdateBillingGroupResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateBillingGroupResponse.getter(UpdateBillingGroupResponse::name)).setter(UpdateBillingGroupResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateBillingGroupResponse.getter(UpdateBillingGroupResponse::description)).setter(UpdateBillingGroupResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PRIMARY_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryAccountId").getter(UpdateBillingGroupResponse.getter(UpdateBillingGroupResponse::primaryAccountId)).setter(UpdateBillingGroupResponse.setter(Builder::primaryAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryAccountId").build()}).build();
    private static final SdkField<String> PRICING_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlanArn").getter(UpdateBillingGroupResponse.getter(UpdateBillingGroupResponse::pricingPlanArn)).setter(UpdateBillingGroupResponse.setter(Builder::pricingPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlanArn").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Size").getter(UpdateBillingGroupResponse.getter(UpdateBillingGroupResponse::size)).setter(UpdateBillingGroupResponse.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastModifiedTime").getter(UpdateBillingGroupResponse.getter(UpdateBillingGroupResponse::lastModifiedTime)).setter(UpdateBillingGroupResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateBillingGroupResponse.getter(UpdateBillingGroupResponse::statusAsString)).setter(UpdateBillingGroupResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(UpdateBillingGroupResponse.getter(UpdateBillingGroupResponse::statusReason)).setter(UpdateBillingGroupResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<UpdateBillingGroupAccountGrouping> ACCOUNT_GROUPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountGrouping").getter(UpdateBillingGroupResponse.getter(UpdateBillingGroupResponse::accountGrouping)).setter(UpdateBillingGroupResponse.setter(Builder::accountGrouping)).constructor(UpdateBillingGroupAccountGrouping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountGrouping").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, PRIMARY_ACCOUNT_ID_FIELD, PRICING_PLAN_ARN_FIELD, SIZE_FIELD, LAST_MODIFIED_TIME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ACCOUNT_GROUPING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateBillingGroupResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String name;
    private final String description;
    private final String primaryAccountId;
    private final String pricingPlanArn;
    private final Long size;
    private final Long lastModifiedTime;
    private final String status;
    private final String statusReason;
    private final UpdateBillingGroupAccountGrouping accountGrouping;

    private UpdateBillingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.primaryAccountId = builder.primaryAccountId;
        this.pricingPlanArn = builder.pricingPlanArn;
        this.size = builder.size;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.accountGrouping = builder.accountGrouping;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String primaryAccountId() {
        return this.primaryAccountId;
    }

    public final String pricingPlanArn() {
        return this.pricingPlanArn;
    }

    public final Long size() {
        return this.size;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final BillingGroupStatus status() {
        return BillingGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final UpdateBillingGroupAccountGrouping accountGrouping() {
        return this.accountGrouping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountGrouping());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBillingGroupResponse)) {
            return false;
        }
        UpdateBillingGroupResponse other = (UpdateBillingGroupResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.primaryAccountId(), other.primaryAccountId()) && Objects.equals(this.pricingPlanArn(), other.pricingPlanArn()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.accountGrouping(), other.accountGrouping());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBillingGroupResponse").add("Arn", (Object)this.arn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("PrimaryAccountId", (Object)this.primaryAccountId()).add("PricingPlanArn", (Object)this.pricingPlanArn()).add("Size", (Object)this.size()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("AccountGrouping", (Object)this.accountGrouping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "PrimaryAccountId": {
                return Optional.ofNullable(clazz.cast(this.primaryAccountId()));
            }
            case "PricingPlanArn": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanArn()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "AccountGrouping": {
                return Optional.ofNullable(clazz.cast(this.accountGrouping()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("PrimaryAccountId", PRIMARY_ACCOUNT_ID_FIELD);
        map.put("PricingPlanArn", PRICING_PLAN_ARN_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("AccountGrouping", ACCOUNT_GROUPING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBillingGroupResponse, T> g) {
        return obj -> g.apply((UpdateBillingGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String primaryAccountId;
        private String pricingPlanArn;
        private Long size;
        private Long lastModifiedTime;
        private String status;
        private String statusReason;
        private UpdateBillingGroupAccountGrouping accountGrouping;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBillingGroupResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.primaryAccountId(model.primaryAccountId);
            this.pricingPlanArn(model.pricingPlanArn);
            this.size(model.size);
            this.lastModifiedTime(model.lastModifiedTime);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.accountGrouping(model.accountGrouping);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPrimaryAccountId() {
            return this.primaryAccountId;
        }

        public final void setPrimaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
        }

        @Override
        public final Builder primaryAccountId(String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
            return this;
        }

        public final String getPricingPlanArn() {
            return this.pricingPlanArn;
        }

        public final void setPricingPlanArn(String pricingPlanArn) {
            this.pricingPlanArn = pricingPlanArn;
        }

        @Override
        public final Builder pricingPlanArn(String pricingPlanArn) {
            this.pricingPlanArn = pricingPlanArn;
            return this;
        }

        public final Long getSize() {
            return this.size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BillingGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final UpdateBillingGroupAccountGrouping.Builder getAccountGrouping() {
            return this.accountGrouping != null ? this.accountGrouping.toBuilder() : null;
        }

        public final void setAccountGrouping(UpdateBillingGroupAccountGrouping.BuilderImpl accountGrouping) {
            this.accountGrouping = accountGrouping != null ? accountGrouping.build() : null;
        }

        @Override
        public final Builder accountGrouping(UpdateBillingGroupAccountGrouping accountGrouping) {
            this.accountGrouping = accountGrouping;
            return this;
        }

        @Override
        public UpdateBillingGroupResponse build() {
            return new UpdateBillingGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBillingGroupResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder primaryAccountId(String var1);

        public Builder pricingPlanArn(String var1);

        public Builder size(Long var1);

        public Builder lastModifiedTime(Long var1);

        public Builder status(String var1);

        public Builder status(BillingGroupStatus var1);

        public Builder statusReason(String var1);

        public Builder accountGrouping(UpdateBillingGroupAccountGrouping var1);

        default public Builder accountGrouping(Consumer<UpdateBillingGroupAccountGrouping.Builder> accountGrouping) {
            return this.accountGrouping((UpdateBillingGroupAccountGrouping)((UpdateBillingGroupAccountGrouping.Builder)UpdateBillingGroupAccountGrouping.builder().applyMutation(accountGrouping)).build());
        }
    }
}

