/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.billingconductor.model.ComputationRuleEnum;
import software.amazon.awssdk.services.billingconductor.model.CurrencyCode;
import software.amazon.awssdk.services.billingconductor.model.ListCustomLineItemChargeDetails;
import software.amazon.awssdk.services.billingconductor.model.PresentationObject;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomLineItemVersionListElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomLineItemVersionListElement> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::name)).setter(CustomLineItemVersionListElement.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<ListCustomLineItemChargeDetails> CHARGE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChargeDetails").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::chargeDetails)).setter(CustomLineItemVersionListElement.setter(Builder::chargeDetails)).constructor(ListCustomLineItemChargeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChargeDetails").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::currencyCodeAsString)).setter(CustomLineItemVersionListElement.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::description)).setter(CustomLineItemVersionListElement.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> PRODUCT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductCode").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::productCode)).setter(CustomLineItemVersionListElement.setter(Builder::productCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductCode").build()}).build();
    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingGroupArn").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::billingGroupArn)).setter(CustomLineItemVersionListElement.setter(Builder::billingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingGroupArn").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreationTime").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::creationTime)).setter(CustomLineItemVersionListElement.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastModifiedTime").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::lastModifiedTime)).setter(CustomLineItemVersionListElement.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Long> ASSOCIATION_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AssociationSize").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::associationSize)).setter(CustomLineItemVersionListElement.setter(Builder::associationSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSize").build()}).build();
    private static final SdkField<String> START_BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartBillingPeriod").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::startBillingPeriod)).setter(CustomLineItemVersionListElement.setter(Builder::startBillingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartBillingPeriod").build()}).build();
    private static final SdkField<String> END_BILLING_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndBillingPeriod").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::endBillingPeriod)).setter(CustomLineItemVersionListElement.setter(Builder::endBillingPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndBillingPeriod").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::arn)).setter(CustomLineItemVersionListElement.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Long> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("StartTime").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::startTime)).setter(CustomLineItemVersionListElement.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::accountId)).setter(CustomLineItemVersionListElement.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> COMPUTATION_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputationRule").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::computationRuleAsString)).setter(CustomLineItemVersionListElement.setter(Builder::computationRule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationRule").build()}).build();
    private static final SdkField<PresentationObject> PRESENTATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PresentationDetails").getter(CustomLineItemVersionListElement.getter(CustomLineItemVersionListElement::presentationDetails)).setter(CustomLineItemVersionListElement.setter(Builder::presentationDetails)).constructor(PresentationObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresentationDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CHARGE_DETAILS_FIELD, CURRENCY_CODE_FIELD, DESCRIPTION_FIELD, PRODUCT_CODE_FIELD, BILLING_GROUP_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ASSOCIATION_SIZE_FIELD, START_BILLING_PERIOD_FIELD, END_BILLING_PERIOD_FIELD, ARN_FIELD, START_TIME_FIELD, ACCOUNT_ID_FIELD, COMPUTATION_RULE_FIELD, PRESENTATION_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomLineItemVersionListElement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final ListCustomLineItemChargeDetails chargeDetails;
    private final String currencyCode;
    private final String description;
    private final String productCode;
    private final String billingGroupArn;
    private final Long creationTime;
    private final Long lastModifiedTime;
    private final Long associationSize;
    private final String startBillingPeriod;
    private final String endBillingPeriod;
    private final String arn;
    private final Long startTime;
    private final String accountId;
    private final String computationRule;
    private final PresentationObject presentationDetails;

    private CustomLineItemVersionListElement(BuilderImpl builder) {
        this.name = builder.name;
        this.chargeDetails = builder.chargeDetails;
        this.currencyCode = builder.currencyCode;
        this.description = builder.description;
        this.productCode = builder.productCode;
        this.billingGroupArn = builder.billingGroupArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.associationSize = builder.associationSize;
        this.startBillingPeriod = builder.startBillingPeriod;
        this.endBillingPeriod = builder.endBillingPeriod;
        this.arn = builder.arn;
        this.startTime = builder.startTime;
        this.accountId = builder.accountId;
        this.computationRule = builder.computationRule;
        this.presentationDetails = builder.presentationDetails;
    }

    public final String name() {
        return this.name;
    }

    public final ListCustomLineItemChargeDetails chargeDetails() {
        return this.chargeDetails;
    }

    public final CurrencyCode currencyCode() {
        return CurrencyCode.fromValue(this.currencyCode);
    }

    public final String currencyCodeAsString() {
        return this.currencyCode;
    }

    public final String description() {
        return this.description;
    }

    public final String productCode() {
        return this.productCode;
    }

    public final String billingGroupArn() {
        return this.billingGroupArn;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Long associationSize() {
        return this.associationSize;
    }

    public final String startBillingPeriod() {
        return this.startBillingPeriod;
    }

    public final String endBillingPeriod() {
        return this.endBillingPeriod;
    }

    public final String arn() {
        return this.arn;
    }

    public final Long startTime() {
        return this.startTime;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final ComputationRuleEnum computationRule() {
        return ComputationRuleEnum.fromValue(this.computationRule);
    }

    public final String computationRuleAsString() {
        return this.computationRule;
    }

    public final PresentationObject presentationDetails() {
        return this.presentationDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.chargeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.startBillingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.endBillingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationRuleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.presentationDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomLineItemVersionListElement)) {
            return false;
        }
        CustomLineItemVersionListElement other = (CustomLineItemVersionListElement)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.chargeDetails(), other.chargeDetails()) && Objects.equals(this.currencyCodeAsString(), other.currencyCodeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.productCode(), other.productCode()) && Objects.equals(this.billingGroupArn(), other.billingGroupArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.associationSize(), other.associationSize()) && Objects.equals(this.startBillingPeriod(), other.startBillingPeriod()) && Objects.equals(this.endBillingPeriod(), other.endBillingPeriod()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.computationRuleAsString(), other.computationRuleAsString()) && Objects.equals(this.presentationDetails(), other.presentationDetails());
    }

    public final String toString() {
        return ToString.builder((String)"CustomLineItemVersionListElement").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ChargeDetails", (Object)this.chargeDetails()).add("CurrencyCode", (Object)this.currencyCodeAsString()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ProductCode", (Object)this.productCode()).add("BillingGroupArn", (Object)this.billingGroupArn()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("AssociationSize", (Object)this.associationSize()).add("StartBillingPeriod", (Object)this.startBillingPeriod()).add("EndBillingPeriod", (Object)this.endBillingPeriod()).add("Arn", (Object)this.arn()).add("StartTime", (Object)this.startTime()).add("AccountId", (Object)this.accountId()).add("ComputationRule", (Object)this.computationRuleAsString()).add("PresentationDetails", (Object)this.presentationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ChargeDetails": {
                return Optional.ofNullable(clazz.cast(this.chargeDetails()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCodeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ProductCode": {
                return Optional.ofNullable(clazz.cast(this.productCode()));
            }
            case "BillingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.billingGroupArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "AssociationSize": {
                return Optional.ofNullable(clazz.cast(this.associationSize()));
            }
            case "StartBillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.startBillingPeriod()));
            }
            case "EndBillingPeriod": {
                return Optional.ofNullable(clazz.cast(this.endBillingPeriod()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ComputationRule": {
                return Optional.ofNullable(clazz.cast(this.computationRuleAsString()));
            }
            case "PresentationDetails": {
                return Optional.ofNullable(clazz.cast(this.presentationDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("ChargeDetails", CHARGE_DETAILS_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ProductCode", PRODUCT_CODE_FIELD);
        map.put("BillingGroupArn", BILLING_GROUP_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("AssociationSize", ASSOCIATION_SIZE_FIELD);
        map.put("StartBillingPeriod", START_BILLING_PERIOD_FIELD);
        map.put("EndBillingPeriod", END_BILLING_PERIOD_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ComputationRule", COMPUTATION_RULE_FIELD);
        map.put("PresentationDetails", PRESENTATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomLineItemVersionListElement, T> g) {
        return obj -> g.apply((CustomLineItemVersionListElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private ListCustomLineItemChargeDetails chargeDetails;
        private String currencyCode;
        private String description;
        private String productCode;
        private String billingGroupArn;
        private Long creationTime;
        private Long lastModifiedTime;
        private Long associationSize;
        private String startBillingPeriod;
        private String endBillingPeriod;
        private String arn;
        private Long startTime;
        private String accountId;
        private String computationRule;
        private PresentationObject presentationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomLineItemVersionListElement model) {
            this.name(model.name);
            this.chargeDetails(model.chargeDetails);
            this.currencyCode(model.currencyCode);
            this.description(model.description);
            this.productCode(model.productCode);
            this.billingGroupArn(model.billingGroupArn);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.associationSize(model.associationSize);
            this.startBillingPeriod(model.startBillingPeriod);
            this.endBillingPeriod(model.endBillingPeriod);
            this.arn(model.arn);
            this.startTime(model.startTime);
            this.accountId(model.accountId);
            this.computationRule(model.computationRule);
            this.presentationDetails(model.presentationDetails);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ListCustomLineItemChargeDetails.Builder getChargeDetails() {
            return this.chargeDetails != null ? this.chargeDetails.toBuilder() : null;
        }

        public final void setChargeDetails(ListCustomLineItemChargeDetails.BuilderImpl chargeDetails) {
            this.chargeDetails = chargeDetails != null ? chargeDetails.build() : null;
        }

        @Override
        public final Builder chargeDetails(ListCustomLineItemChargeDetails chargeDetails) {
            this.chargeDetails = chargeDetails;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getProductCode() {
            return this.productCode;
        }

        public final void setProductCode(String productCode) {
            this.productCode = productCode;
        }

        @Override
        public final Builder productCode(String productCode) {
            this.productCode = productCode;
            return this;
        }

        public final String getBillingGroupArn() {
            return this.billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Long getAssociationSize() {
            return this.associationSize;
        }

        public final void setAssociationSize(Long associationSize) {
            this.associationSize = associationSize;
        }

        @Override
        public final Builder associationSize(Long associationSize) {
            this.associationSize = associationSize;
            return this;
        }

        public final String getStartBillingPeriod() {
            return this.startBillingPeriod;
        }

        public final void setStartBillingPeriod(String startBillingPeriod) {
            this.startBillingPeriod = startBillingPeriod;
        }

        @Override
        public final Builder startBillingPeriod(String startBillingPeriod) {
            this.startBillingPeriod = startBillingPeriod;
            return this;
        }

        public final String getEndBillingPeriod() {
            return this.endBillingPeriod;
        }

        public final void setEndBillingPeriod(String endBillingPeriod) {
            this.endBillingPeriod = endBillingPeriod;
        }

        @Override
        public final Builder endBillingPeriod(String endBillingPeriod) {
            this.endBillingPeriod = endBillingPeriod;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getComputationRule() {
            return this.computationRule;
        }

        public final void setComputationRule(String computationRule) {
            this.computationRule = computationRule;
        }

        @Override
        public final Builder computationRule(String computationRule) {
            this.computationRule = computationRule;
            return this;
        }

        @Override
        public final Builder computationRule(ComputationRuleEnum computationRule) {
            this.computationRule(computationRule == null ? null : computationRule.toString());
            return this;
        }

        public final PresentationObject.Builder getPresentationDetails() {
            return this.presentationDetails != null ? this.presentationDetails.toBuilder() : null;
        }

        public final void setPresentationDetails(PresentationObject.BuilderImpl presentationDetails) {
            this.presentationDetails = presentationDetails != null ? presentationDetails.build() : null;
        }

        @Override
        public final Builder presentationDetails(PresentationObject presentationDetails) {
            this.presentationDetails = presentationDetails;
            return this;
        }

        public CustomLineItemVersionListElement build() {
            return new CustomLineItemVersionListElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomLineItemVersionListElement> {
        public Builder name(String var1);

        public Builder chargeDetails(ListCustomLineItemChargeDetails var1);

        default public Builder chargeDetails(Consumer<ListCustomLineItemChargeDetails.Builder> chargeDetails) {
            return this.chargeDetails((ListCustomLineItemChargeDetails)((ListCustomLineItemChargeDetails.Builder)ListCustomLineItemChargeDetails.builder().applyMutation(chargeDetails)).build());
        }

        public Builder currencyCode(String var1);

        public Builder currencyCode(CurrencyCode var1);

        public Builder description(String var1);

        public Builder productCode(String var1);

        public Builder billingGroupArn(String var1);

        public Builder creationTime(Long var1);

        public Builder lastModifiedTime(Long var1);

        public Builder associationSize(Long var1);

        public Builder startBillingPeriod(String var1);

        public Builder endBillingPeriod(String var1);

        public Builder arn(String var1);

        public Builder startTime(Long var1);

        public Builder accountId(String var1);

        public Builder computationRule(String var1);

        public Builder computationRule(ComputationRuleEnum var1);

        public Builder presentationDetails(PresentationObject var1);

        default public Builder presentationDetails(Consumer<PresentationObject.Builder> presentationDetails) {
            return this.presentationDetails((PresentationObject)((PresentationObject.Builder)PresentationObject.builder().applyMutation(presentationDetails)).build());
        }
    }
}

