/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponseElement;
import software.amazon.awssdk.services.billingconductor.model.ListResourcesAssociatedToCustomLineItemResponseListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourcesAssociatedToCustomLineItemResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, ListResourcesAssociatedToCustomLineItemResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListResourcesAssociatedToCustomLineItemResponse.getter(ListResourcesAssociatedToCustomLineItemResponse::arn)).setter(ListResourcesAssociatedToCustomLineItemResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<ListResourcesAssociatedToCustomLineItemResponseElement>> ASSOCIATED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedResources").getter(ListResourcesAssociatedToCustomLineItemResponse.getter(ListResourcesAssociatedToCustomLineItemResponse::associatedResources)).setter(ListResourcesAssociatedToCustomLineItemResponse.setter(Builder::associatedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListResourcesAssociatedToCustomLineItemResponseElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListResourcesAssociatedToCustomLineItemResponse.getter(ListResourcesAssociatedToCustomLineItemResponse::nextToken)).setter(ListResourcesAssociatedToCustomLineItemResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ASSOCIATED_RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListResourcesAssociatedToCustomLineItemResponse.memberNameToFieldInitializer();
    private final String arn;
    private final List<ListResourcesAssociatedToCustomLineItemResponseElement> associatedResources;
    private final String nextToken;

    private ListResourcesAssociatedToCustomLineItemResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.associatedResources = builder.associatedResources;
        this.nextToken = builder.nextToken;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAssociatedResources() {
        return this.associatedResources != null && !(this.associatedResources instanceof SdkAutoConstructList);
    }

    public final List<ListResourcesAssociatedToCustomLineItemResponseElement> associatedResources() {
        return this.associatedResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedResources() ? this.associatedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesAssociatedToCustomLineItemResponse)) {
            return false;
        }
        ListResourcesAssociatedToCustomLineItemResponse other = (ListResourcesAssociatedToCustomLineItemResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasAssociatedResources() == other.hasAssociatedResources() && Objects.equals(this.associatedResources(), other.associatedResources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourcesAssociatedToCustomLineItemResponse").add("Arn", (Object)this.arn()).add("AssociatedResources", this.hasAssociatedResources() ? this.associatedResources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AssociatedResources": {
                return Optional.ofNullable(clazz.cast(this.associatedResources()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("AssociatedResources", ASSOCIATED_RESOURCES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourcesAssociatedToCustomLineItemResponse, T> g) {
        return obj -> g.apply((ListResourcesAssociatedToCustomLineItemResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private String arn;
        private List<ListResourcesAssociatedToCustomLineItemResponseElement> associatedResources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesAssociatedToCustomLineItemResponse model) {
            super(model);
            this.arn(model.arn);
            this.associatedResources(model.associatedResources);
            this.nextToken(model.nextToken);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<ListResourcesAssociatedToCustomLineItemResponseElement.Builder> getAssociatedResources() {
            List<ListResourcesAssociatedToCustomLineItemResponseElement.Builder> result = ListResourcesAssociatedToCustomLineItemResponseListCopier.copyToBuilder(this.associatedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedResources(Collection<ListResourcesAssociatedToCustomLineItemResponseElement.BuilderImpl> associatedResources) {
            this.associatedResources = ListResourcesAssociatedToCustomLineItemResponseListCopier.copyFromBuilder(associatedResources);
        }

        @Override
        public final Builder associatedResources(Collection<ListResourcesAssociatedToCustomLineItemResponseElement> associatedResources) {
            this.associatedResources = ListResourcesAssociatedToCustomLineItemResponseListCopier.copy(associatedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResources(ListResourcesAssociatedToCustomLineItemResponseElement ... associatedResources) {
            this.associatedResources(Arrays.asList(associatedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResources(Consumer<ListResourcesAssociatedToCustomLineItemResponseElement.Builder> ... associatedResources) {
            this.associatedResources(Stream.of(associatedResources).map(c -> (ListResourcesAssociatedToCustomLineItemResponseElement)((ListResourcesAssociatedToCustomLineItemResponseElement.Builder)ListResourcesAssociatedToCustomLineItemResponseElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourcesAssociatedToCustomLineItemResponse build() {
            return new ListResourcesAssociatedToCustomLineItemResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourcesAssociatedToCustomLineItemResponse> {
        public Builder arn(String var1);

        public Builder associatedResources(Collection<ListResourcesAssociatedToCustomLineItemResponseElement> var1);

        public Builder associatedResources(ListResourcesAssociatedToCustomLineItemResponseElement ... var1);

        public Builder associatedResources(Consumer<ListResourcesAssociatedToCustomLineItemResponseElement.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

