/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.Attribute;
import software.amazon.awssdk.services.billingconductor.model.AttributesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillingGroupCostReportResultElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillingGroupCostReportResultElement> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(BillingGroupCostReportResultElement.getter(BillingGroupCostReportResultElement::arn)).setter(BillingGroupCostReportResultElement.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> AWS_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AWSCost").getter(BillingGroupCostReportResultElement.getter(BillingGroupCostReportResultElement::awsCost)).setter(BillingGroupCostReportResultElement.setter(Builder::awsCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSCost").build()}).build();
    private static final SdkField<String> PROFORMA_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProformaCost").getter(BillingGroupCostReportResultElement.getter(BillingGroupCostReportResultElement::proformaCost)).setter(BillingGroupCostReportResultElement.setter(Builder::proformaCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProformaCost").build()}).build();
    private static final SdkField<String> MARGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Margin").getter(BillingGroupCostReportResultElement.getter(BillingGroupCostReportResultElement::margin)).setter(BillingGroupCostReportResultElement.setter(Builder::margin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Margin").build()}).build();
    private static final SdkField<String> MARGIN_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MarginPercentage").getter(BillingGroupCostReportResultElement.getter(BillingGroupCostReportResultElement::marginPercentage)).setter(BillingGroupCostReportResultElement.setter(Builder::marginPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MarginPercentage").build()}).build();
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Currency").getter(BillingGroupCostReportResultElement.getter(BillingGroupCostReportResultElement::currency)).setter(BillingGroupCostReportResultElement.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()}).build();
    private static final SdkField<List<Attribute>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Attributes").getter(BillingGroupCostReportResultElement.getter(BillingGroupCostReportResultElement::attributes)).setter(BillingGroupCostReportResultElement.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AWS_COST_FIELD, PROFORMA_COST_FIELD, MARGIN_FIELD, MARGIN_PERCENTAGE_FIELD, CURRENCY_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BillingGroupCostReportResultElement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String awsCost;
    private final String proformaCost;
    private final String margin;
    private final String marginPercentage;
    private final String currency;
    private final List<Attribute> attributes;

    private BillingGroupCostReportResultElement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.awsCost = builder.awsCost;
        this.proformaCost = builder.proformaCost;
        this.margin = builder.margin;
        this.marginPercentage = builder.marginPercentage;
        this.currency = builder.currency;
        this.attributes = builder.attributes;
    }

    public final String arn() {
        return this.arn;
    }

    public final String awsCost() {
        return this.awsCost;
    }

    public final String proformaCost() {
        return this.proformaCost;
    }

    public final String margin() {
        return this.margin;
    }

    public final String marginPercentage() {
        return this.marginPercentage;
    }

    public final String currency() {
        return this.currency;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<Attribute> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.proformaCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.margin());
        hashCode = 31 * hashCode + Objects.hashCode(this.marginPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.currency());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingGroupCostReportResultElement)) {
            return false;
        }
        BillingGroupCostReportResultElement other = (BillingGroupCostReportResultElement)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.awsCost(), other.awsCost()) && Objects.equals(this.proformaCost(), other.proformaCost()) && Objects.equals(this.margin(), other.margin()) && Objects.equals(this.marginPercentage(), other.marginPercentage()) && Objects.equals(this.currency(), other.currency()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"BillingGroupCostReportResultElement").add("Arn", (Object)this.arn()).add("AWSCost", (Object)this.awsCost()).add("ProformaCost", (Object)this.proformaCost()).add("Margin", (Object)this.margin()).add("MarginPercentage", (Object)this.marginPercentage()).add("Currency", (Object)this.currency()).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AWSCost": {
                return Optional.ofNullable(clazz.cast(this.awsCost()));
            }
            case "ProformaCost": {
                return Optional.ofNullable(clazz.cast(this.proformaCost()));
            }
            case "Margin": {
                return Optional.ofNullable(clazz.cast(this.margin()));
            }
            case "MarginPercentage": {
                return Optional.ofNullable(clazz.cast(this.marginPercentage()));
            }
            case "Currency": {
                return Optional.ofNullable(clazz.cast(this.currency()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("AWSCost", AWS_COST_FIELD);
        map.put("ProformaCost", PROFORMA_COST_FIELD);
        map.put("Margin", MARGIN_FIELD);
        map.put("MarginPercentage", MARGIN_PERCENTAGE_FIELD);
        map.put("Currency", CURRENCY_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillingGroupCostReportResultElement, T> g) {
        return obj -> g.apply((BillingGroupCostReportResultElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String awsCost;
        private String proformaCost;
        private String margin;
        private String marginPercentage;
        private String currency;
        private List<Attribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BillingGroupCostReportResultElement model) {
            this.arn(model.arn);
            this.awsCost(model.awsCost);
            this.proformaCost(model.proformaCost);
            this.margin(model.margin);
            this.marginPercentage(model.marginPercentage);
            this.currency(model.currency);
            this.attributes(model.attributes);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAwsCost() {
            return this.awsCost;
        }

        public final void setAwsCost(String awsCost) {
            this.awsCost = awsCost;
        }

        @Override
        public final Builder awsCost(String awsCost) {
            this.awsCost = awsCost;
            return this;
        }

        public final String getProformaCost() {
            return this.proformaCost;
        }

        public final void setProformaCost(String proformaCost) {
            this.proformaCost = proformaCost;
        }

        @Override
        public final Builder proformaCost(String proformaCost) {
            this.proformaCost = proformaCost;
            return this;
        }

        public final String getMargin() {
            return this.margin;
        }

        public final void setMargin(String margin) {
            this.margin = margin;
        }

        @Override
        public final Builder margin(String margin) {
            this.margin = margin;
            return this;
        }

        public final String getMarginPercentage() {
            return this.marginPercentage;
        }

        public final void setMarginPercentage(String marginPercentage) {
            this.marginPercentage = marginPercentage;
        }

        @Override
        public final Builder marginPercentage(String marginPercentage) {
            this.marginPercentage = marginPercentage;
            return this;
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public final List<Attribute.Builder> getAttributes() {
            List<Attribute.Builder> result = AttributesListCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<Attribute.BuilderImpl> attributes) {
            this.attributes = AttributesListCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<Attribute> attributes) {
            this.attributes = AttributesListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Attribute ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Attribute.Builder> ... attributes) {
            this.attributes(Stream.of(attributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BillingGroupCostReportResultElement build() {
            return new BillingGroupCostReportResultElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillingGroupCostReportResultElement> {
        public Builder arn(String var1);

        public Builder awsCost(String var1);

        public Builder proformaCost(String var1);

        public Builder margin(String var1);

        public Builder marginPercentage(String var1);

        public Builder currency(String var1);

        public Builder attributes(Collection<Attribute> var1);

        public Builder attributes(Attribute ... var1);

        public Builder attributes(Consumer<Attribute.Builder> ... var1);
    }
}

