/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorAsyncClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse;

public class ListPricingRulesAssociatedToPricingPlanPublisher
implements SdkPublisher<ListPricingRulesAssociatedToPricingPlanResponse> {
    private final BillingconductorAsyncClient client;
    private final ListPricingRulesAssociatedToPricingPlanRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPricingRulesAssociatedToPricingPlanPublisher(BillingconductorAsyncClient client, ListPricingRulesAssociatedToPricingPlanRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPricingRulesAssociatedToPricingPlanPublisher(BillingconductorAsyncClient client, ListPricingRulesAssociatedToPricingPlanRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPricingRulesAssociatedToPricingPlanResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPricingRulesAssociatedToPricingPlanResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> pricingRuleArns() {
        Function<ListPricingRulesAssociatedToPricingPlanResponse, Iterator> getIterator = response -> {
            if (response != null && response.pricingRuleArns() != null) {
                return response.pricingRuleArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPricingRulesAssociatedToPricingPlanResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPricingRulesAssociatedToPricingPlanResponseFetcher
    implements AsyncPageFetcher<ListPricingRulesAssociatedToPricingPlanResponse> {
        private ListPricingRulesAssociatedToPricingPlanResponseFetcher() {
        }

        public boolean hasNextPage(ListPricingRulesAssociatedToPricingPlanResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPricingRulesAssociatedToPricingPlanResponse> nextPage(ListPricingRulesAssociatedToPricingPlanResponse previousPage) {
            if (previousPage == null) {
                return ListPricingRulesAssociatedToPricingPlanPublisher.this.client.listPricingRulesAssociatedToPricingPlan(ListPricingRulesAssociatedToPricingPlanPublisher.this.firstRequest);
            }
            return ListPricingRulesAssociatedToPricingPlanPublisher.this.client.listPricingRulesAssociatedToPricingPlan((ListPricingRulesAssociatedToPricingPlanRequest)((Object)ListPricingRulesAssociatedToPricingPlanPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

