/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingconductorResponse;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemListCopier;
import software.amazon.awssdk.services.billingconductor.model.CustomLineItemListElement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomLineItemsResponse
extends BillingconductorResponse
implements ToCopyableBuilder<Builder, ListCustomLineItemsResponse> {
    private static final SdkField<List<CustomLineItemListElement>> CUSTOM_LINE_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomLineItems").getter(ListCustomLineItemsResponse.getter(ListCustomLineItemsResponse::customLineItems)).setter(ListCustomLineItemsResponse.setter(Builder::customLineItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLineItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomLineItemListElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCustomLineItemsResponse.getter(ListCustomLineItemsResponse::nextToken)).setter(ListCustomLineItemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_LINE_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CustomLineItems", CUSTOM_LINE_ITEMS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<CustomLineItemListElement> customLineItems;
    private final String nextToken;

    private ListCustomLineItemsResponse(BuilderImpl builder) {
        super(builder);
        this.customLineItems = builder.customLineItems;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCustomLineItems() {
        return this.customLineItems != null && !(this.customLineItems instanceof SdkAutoConstructList);
    }

    public final List<CustomLineItemListElement> customLineItems() {
        return this.customLineItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomLineItems() ? this.customLineItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomLineItemsResponse)) {
            return false;
        }
        ListCustomLineItemsResponse other = (ListCustomLineItemsResponse)((Object)obj);
        return this.hasCustomLineItems() == other.hasCustomLineItems() && Objects.equals(this.customLineItems(), other.customLineItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomLineItemsResponse").add("CustomLineItems", this.hasCustomLineItems() ? this.customLineItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomLineItems": {
                return Optional.ofNullable(clazz.cast(this.customLineItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomLineItemsResponse, T> g) {
        return obj -> g.apply((ListCustomLineItemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingconductorResponse.BuilderImpl
    implements Builder {
        private List<CustomLineItemListElement> customLineItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomLineItemsResponse model) {
            super(model);
            this.customLineItems(model.customLineItems);
            this.nextToken(model.nextToken);
        }

        public final List<CustomLineItemListElement.Builder> getCustomLineItems() {
            List<CustomLineItemListElement.Builder> result = CustomLineItemListCopier.copyToBuilder(this.customLineItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomLineItems(Collection<CustomLineItemListElement.BuilderImpl> customLineItems) {
            this.customLineItems = CustomLineItemListCopier.copyFromBuilder(customLineItems);
        }

        @Override
        public final Builder customLineItems(Collection<CustomLineItemListElement> customLineItems) {
            this.customLineItems = CustomLineItemListCopier.copy(customLineItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customLineItems(CustomLineItemListElement ... customLineItems) {
            this.customLineItems(Arrays.asList(customLineItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customLineItems(Consumer<CustomLineItemListElement.Builder> ... customLineItems) {
            this.customLineItems(Stream.of(customLineItems).map(c -> (CustomLineItemListElement)((CustomLineItemListElement.Builder)CustomLineItemListElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomLineItemsResponse build() {
            return new ListCustomLineItemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingconductorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomLineItemsResponse> {
        public Builder customLineItems(Collection<CustomLineItemListElement> var1);

        public Builder customLineItems(CustomLineItemListElement ... var1);

        public Builder customLineItems(Consumer<CustomLineItemListElement.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

