/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.AccountAssociationsListElement;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsRequest;
import software.amazon.awssdk.services.billingconductor.model.ListAccountAssociationsResponse;

public class ListAccountAssociationsIterable
implements SdkIterable<ListAccountAssociationsResponse> {
    private final BillingconductorClient client;
    private final ListAccountAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccountAssociationsIterable(BillingconductorClient client, ListAccountAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccountAssociationsResponseFetcher();
    }

    public Iterator<ListAccountAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountAssociationsListElement> linkedAccounts() {
        Function<ListAccountAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.linkedAccounts() != null) {
                return response.linkedAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccountAssociationsResponseFetcher
    implements SyncPageFetcher<ListAccountAssociationsResponse> {
        private ListAccountAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccountAssociationsResponse nextPage(ListAccountAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountAssociationsIterable.this.client.listAccountAssociations(ListAccountAssociationsIterable.this.firstRequest);
            }
            return ListAccountAssociationsIterable.this.client.listAccountAssociations((ListAccountAssociationsRequest)((Object)ListAccountAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

