/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingRulesAssociatedToPricingPlanResponse;

public class ListPricingRulesAssociatedToPricingPlanIterable
implements SdkIterable<ListPricingRulesAssociatedToPricingPlanResponse> {
    private final BillingconductorClient client;
    private final ListPricingRulesAssociatedToPricingPlanRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPricingRulesAssociatedToPricingPlanIterable(BillingconductorClient client, ListPricingRulesAssociatedToPricingPlanRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPricingRulesAssociatedToPricingPlanResponseFetcher();
    }

    public Iterator<ListPricingRulesAssociatedToPricingPlanResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> pricingRuleArns() {
        Function<ListPricingRulesAssociatedToPricingPlanResponse, Iterator> getIterator = response -> {
            if (response != null && response.pricingRuleArns() != null) {
                return response.pricingRuleArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPricingRulesAssociatedToPricingPlanResponseFetcher
    implements SyncPageFetcher<ListPricingRulesAssociatedToPricingPlanResponse> {
        private ListPricingRulesAssociatedToPricingPlanResponseFetcher() {
        }

        public boolean hasNextPage(ListPricingRulesAssociatedToPricingPlanResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPricingRulesAssociatedToPricingPlanResponse nextPage(ListPricingRulesAssociatedToPricingPlanResponse previousPage) {
            if (previousPage == null) {
                return ListPricingRulesAssociatedToPricingPlanIterable.this.client.listPricingRulesAssociatedToPricingPlan(ListPricingRulesAssociatedToPricingPlanIterable.this.firstRequest);
            }
            return ListPricingRulesAssociatedToPricingPlanIterable.this.client.listPricingRulesAssociatedToPricingPlan((ListPricingRulesAssociatedToPricingPlanRequest)((Object)ListPricingRulesAssociatedToPricingPlanIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

