/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billingconductor.BillingconductorAsyncClient;
import software.amazon.awssdk.services.billingconductor.internal.UserAgentUtils;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansRequest;
import software.amazon.awssdk.services.billingconductor.model.ListPricingPlansResponse;
import software.amazon.awssdk.services.billingconductor.model.PricingPlanListElement;

public class ListPricingPlansPublisher
implements SdkPublisher<ListPricingPlansResponse> {
    private final BillingconductorAsyncClient client;
    private final ListPricingPlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPricingPlansPublisher(BillingconductorAsyncClient client, ListPricingPlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPricingPlansPublisher(BillingconductorAsyncClient client, ListPricingPlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPricingPlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPricingPlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PricingPlanListElement> pricingPlans() {
        Function<ListPricingPlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.pricingPlans() != null) {
                return response.pricingPlans().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPricingPlansResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPricingPlansResponseFetcher
    implements AsyncPageFetcher<ListPricingPlansResponse> {
        private ListPricingPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListPricingPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPricingPlansResponse> nextPage(ListPricingPlansResponse previousPage) {
            if (previousPage == null) {
                return ListPricingPlansPublisher.this.client.listPricingPlans(ListPricingPlansPublisher.this.firstRequest);
            }
            return ListPricingPlansPublisher.this.client.listPricingPlans((ListPricingPlansRequest)((Object)ListPricingPlansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

