/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationExceptionReason {
    UNKNOWN_OPERATION("UNKNOWN_OPERATION"),
    CANNOT_PARSE("CANNOT_PARSE"),
    FIELD_VALIDATION_FAILED("FIELD_VALIDATION_FAILED"),
    OTHER("OTHER"),
    PRIMARY_NOT_ASSOCIATED("PRIMARY_NOT_ASSOCIATED"),
    PRIMARY_CANNOT_DISASSOCIATE("PRIMARY_CANNOT_DISASSOCIATE"),
    ACCOUNTS_NOT_ASSOCIATED("ACCOUNTS_NOT_ASSOCIATED"),
    ACCOUNTS_ALREADY_ASSOCIATED("ACCOUNTS_ALREADY_ASSOCIATED"),
    ILLEGAL_PRIMARY_ACCOUNT("ILLEGAL_PRIMARY_ACCOUNT"),
    ILLEGAL_ACCOUNTS("ILLEGAL_ACCOUNTS"),
    MISMATCHED_BILLINGGROUP_ARN("MISMATCHED_BILLINGGROUP_ARN"),
    MISSING_BILLINGGROUP("MISSING_BILLINGGROUP"),
    MISMATCHED_CUSTOMLINEITEM_ARN("MISMATCHED_CUSTOMLINEITEM_ARN"),
    ILLEGAL_BILLING_PERIOD("ILLEGAL_BILLING_PERIOD"),
    ILLEGAL_BILLING_PERIOD_RANGE("ILLEGAL_BILLING_PERIOD_RANGE"),
    TOO_MANY_ACCOUNTS_IN_REQUEST("TOO_MANY_ACCOUNTS_IN_REQUEST"),
    DUPLICATE_ACCOUNT("DUPLICATE_ACCOUNT"),
    INVALID_BILLING_GROUP_STATUS("INVALID_BILLING_GROUP_STATUS"),
    MISMATCHED_PRICINGPLAN_ARN("MISMATCHED_PRICINGPLAN_ARN"),
    MISSING_PRICINGPLAN("MISSING_PRICINGPLAN"),
    MISMATCHED_PRICINGRULE_ARN("MISMATCHED_PRICINGRULE_ARN"),
    DUPLICATE_PRICINGRULE_ARNS("DUPLICATE_PRICINGRULE_ARNS"),
    ILLEGAL_EXPRESSION("ILLEGAL_EXPRESSION"),
    ILLEGAL_SCOPE("ILLEGAL_SCOPE"),
    ILLEGAL_SERVICE("ILLEGAL_SERVICE"),
    PRICINGRULES_NOT_EXIST("PRICINGRULES_NOT_EXIST"),
    PRICINGRULES_ALREADY_ASSOCIATED("PRICINGRULES_ALREADY_ASSOCIATED"),
    PRICINGRULES_NOT_ASSOCIATED("PRICINGRULES_NOT_ASSOCIATED"),
    INVALID_TIME_RANGE("INVALID_TIME_RANGE"),
    INVALID_BILLINGVIEW_ARN("INVALID_BILLINGVIEW_ARN"),
    MISMATCHED_BILLINGVIEW_ARN("MISMATCHED_BILLINGVIEW_ARN"),
    ILLEGAL_CUSTOMLINEITEM("ILLEGAL_CUSTOMLINEITEM"),
    MISSING_CUSTOMLINEITEM("MISSING_CUSTOMLINEITEM"),
    ILLEGAL_CUSTOMLINEITEM_UPDATE("ILLEGAL_CUSTOMLINEITEM_UPDATE"),
    TOO_MANY_CUSTOMLINEITEMS_IN_REQUEST("TOO_MANY_CUSTOMLINEITEMS_IN_REQUEST"),
    ILLEGAL_CHARGE_DETAILS("ILLEGAL_CHARGE_DETAILS"),
    ILLEGAL_UPDATE_CHARGE_DETAILS("ILLEGAL_UPDATE_CHARGE_DETAILS"),
    INVALID_ARN("INVALID_ARN"),
    ILLEGAL_RESOURCE_ARNS("ILLEGAL_RESOURCE_ARNS"),
    ILLEGAL_CUSTOMLINEITEM_MODIFICATION("ILLEGAL_CUSTOMLINEITEM_MODIFICATION"),
    MISSING_LINKED_ACCOUNT_IDS("MISSING_LINKED_ACCOUNT_IDS"),
    MULTIPLE_LINKED_ACCOUNT_IDS("MULTIPLE_LINKED_ACCOUNT_IDS"),
    MISSING_PRICING_PLAN_ARN("MISSING_PRICING_PLAN_ARN"),
    MULTIPLE_PRICING_PLAN_ARN("MULTIPLE_PRICING_PLAN_ARN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationExceptionReason> VALUE_MAP;
    private final String value;

    private ValidationExceptionReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationExceptionReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationExceptionReason> knownValues() {
        EnumSet<ValidationExceptionReason> knownValues = EnumSet.allOf(ValidationExceptionReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationExceptionReason.class, ValidationExceptionReason::toString);
    }
}

