/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billingconductor.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billingconductor.model.BillingGroupArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBillingGroupsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListBillingGroupsFilter> {
    private static final SdkField<List<String>> ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Arns").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::arns)).setter(ListBillingGroupsFilter.setter(Builder::arns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(ListBillingGroupsFilter.getter(ListBillingGroupsFilter::pricingPlan)).setter(ListBillingGroupsFilter.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PricingPlan").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARNS_FIELD, PRICING_PLAN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> arns;
    private final String pricingPlan;

    private ListBillingGroupsFilter(BuilderImpl builder) {
        this.arns = builder.arns;
        this.pricingPlan = builder.pricingPlan;
    }

    public final boolean hasArns() {
        return this.arns != null && !(this.arns instanceof SdkAutoConstructList);
    }

    public final List<String> arns() {
        return this.arns;
    }

    public final String pricingPlan() {
        return this.pricingPlan;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArns() ? this.arns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlan());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBillingGroupsFilter)) {
            return false;
        }
        ListBillingGroupsFilter other = (ListBillingGroupsFilter)obj;
        return this.hasArns() == other.hasArns() && Objects.equals(this.arns(), other.arns()) && Objects.equals(this.pricingPlan(), other.pricingPlan());
    }

    public final String toString() {
        return ToString.builder((String)"ListBillingGroupsFilter").add("Arns", this.hasArns() ? this.arns() : null).add("PricingPlan", (Object)this.pricingPlan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arns": {
                return Optional.ofNullable(clazz.cast(this.arns()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlan()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBillingGroupsFilter, T> g) {
        return obj -> g.apply((ListBillingGroupsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> arns = DefaultSdkAutoConstructList.getInstance();
        private String pricingPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBillingGroupsFilter model) {
            this.arns(model.arns);
            this.pricingPlan(model.pricingPlan);
        }

        public final Collection<String> getArns() {
            if (this.arns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.arns;
        }

        public final void setArns(Collection<String> arns) {
            this.arns = BillingGroupArnListCopier.copy(arns);
        }

        @Override
        @Transient
        public final Builder arns(Collection<String> arns) {
            this.arns = BillingGroupArnListCopier.copy(arns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder arns(String ... arns) {
            this.arns(Arrays.asList(arns));
            return this;
        }

        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        @Transient
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        public ListBillingGroupsFilter build() {
            return new ListBillingGroupsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListBillingGroupsFilter> {
        public Builder arns(Collection<String> var1);

        public Builder arns(String ... var1);

        public Builder pricingPlan(String var1);
    }
}

