/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.billing.BillingAsyncClient;
import software.amazon.awssdk.services.billing.internal.UserAgentUtils;
import software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewRequest;
import software.amazon.awssdk.services.billing.model.ListSourceViewsForBillingViewResponse;

public class ListSourceViewsForBillingViewPublisher
implements SdkPublisher<ListSourceViewsForBillingViewResponse> {
    private final BillingAsyncClient client;
    private final ListSourceViewsForBillingViewRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSourceViewsForBillingViewPublisher(BillingAsyncClient client, ListSourceViewsForBillingViewRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSourceViewsForBillingViewPublisher(BillingAsyncClient client, ListSourceViewsForBillingViewRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSourceViewsForBillingViewResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSourceViewsForBillingViewResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> sourceViews() {
        Function<ListSourceViewsForBillingViewResponse, Iterator> getIterator = response -> {
            if (response != null && response.sourceViews() != null) {
                return response.sourceViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSourceViewsForBillingViewResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSourceViewsForBillingViewResponseFetcher
    implements AsyncPageFetcher<ListSourceViewsForBillingViewResponse> {
        private ListSourceViewsForBillingViewResponseFetcher() {
        }

        public boolean hasNextPage(ListSourceViewsForBillingViewResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSourceViewsForBillingViewResponse> nextPage(ListSourceViewsForBillingViewResponse previousPage) {
            if (previousPage == null) {
                return ListSourceViewsForBillingViewPublisher.this.client.listSourceViewsForBillingView(ListSourceViewsForBillingViewPublisher.this.firstRequest);
            }
            return ListSourceViewsForBillingViewPublisher.this.client.listSourceViewsForBillingView((ListSourceViewsForBillingViewRequest)((Object)ListSourceViewsForBillingViewPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

