/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StopReason {
    END_TURN("end_turn"),
    TOOL_USE("tool_use"),
    MAX_TOKENS("max_tokens"),
    STOP_SEQUENCE("stop_sequence"),
    GUARDRAIL_INTERVENED("guardrail_intervened"),
    CONTENT_FILTERED("content_filtered"),
    MALFORMED_MODEL_OUTPUT("malformed_model_output"),
    MALFORMED_TOOL_USE("malformed_tool_use"),
    MODEL_CONTEXT_WINDOW_EXCEEDED("model_context_window_exceeded"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StopReason> VALUE_MAP;
    private final String value;

    private StopReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StopReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StopReason> knownValues() {
        EnumSet<StopReason> knownValues = EnumSet.allOf(StopReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StopReason.class, StopReason::toString);
    }
}

