/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAsyncInvokesRequest extends BedrockRuntimeRequest implements
        ToCopyableBuilder<ListAsyncInvokesRequest.Builder, ListAsyncInvokesRequest> {
    private static final SdkField<Instant> SUBMIT_TIME_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("submitTimeAfter")
            .getter(getter(ListAsyncInvokesRequest::submitTimeAfter))
            .setter(setter(Builder::submitTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("submitTimeAfter").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> SUBMIT_TIME_BEFORE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("submitTimeBefore")
            .getter(getter(ListAsyncInvokesRequest::submitTimeBefore))
            .setter(setter(Builder::submitTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("submitTimeBefore").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusEquals").getter(getter(ListAsyncInvokesRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("statusEquals").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAsyncInvokesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAsyncInvokesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListAsyncInvokesRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sortOrder").getter(getter(ListAsyncInvokesRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMIT_TIME_AFTER_FIELD,
            SUBMIT_TIME_BEFORE_FIELD, STATUS_EQUALS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant submitTimeAfter;

    private final Instant submitTimeBefore;

    private final String statusEquals;

    private final Integer maxResults;

    private final String nextToken;

    private final String sortBy;

    private final String sortOrder;

    private ListAsyncInvokesRequest(BuilderImpl builder) {
        super(builder);
        this.submitTimeAfter = builder.submitTimeAfter;
        this.submitTimeBefore = builder.submitTimeBefore;
        this.statusEquals = builder.statusEquals;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * Include invocations submitted after this time.
     * </p>
     * 
     * @return Include invocations submitted after this time.
     */
    public final Instant submitTimeAfter() {
        return submitTimeAfter;
    }

    /**
     * <p>
     * Include invocations submitted before this time.
     * </p>
     * 
     * @return Include invocations submitted before this time.
     */
    public final Instant submitTimeBefore() {
        return submitTimeBefore;
    }

    /**
     * <p>
     * Filter invocations by status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link AsyncInvokeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Filter invocations by status.
     * @see AsyncInvokeStatus
     */
    public final AsyncInvokeStatus statusEquals() {
        return AsyncInvokeStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * Filter invocations by status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link AsyncInvokeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Filter invocations by status.
     * @see AsyncInvokeStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * The maximum number of invocations to return in one page of results.
     * </p>
     * 
     * @return The maximum number of invocations to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * How to sort the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortAsyncInvocationBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return How to sort the response.
     * @see SortAsyncInvocationBy
     */
    public final SortAsyncInvocationBy sortBy() {
        return SortAsyncInvocationBy.fromValue(sortBy);
    }

    /**
     * <p>
     * How to sort the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortAsyncInvocationBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sortByAsString}.
     * </p>
     * 
     * @return How to sort the response.
     * @see SortAsyncInvocationBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sorting order for the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sorting order for the response.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sorting order for the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sorting order for the response.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(submitTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAsyncInvokesRequest)) {
            return false;
        }
        ListAsyncInvokesRequest other = (ListAsyncInvokesRequest) obj;
        return Objects.equals(submitTimeAfter(), other.submitTimeAfter())
                && Objects.equals(submitTimeBefore(), other.submitTimeBefore())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAsyncInvokesRequest").add("SubmitTimeAfter", submitTimeAfter())
                .add("SubmitTimeBefore", submitTimeBefore()).add("StatusEquals", statusEqualsAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "submitTimeAfter":
            return Optional.ofNullable(clazz.cast(submitTimeAfter()));
        case "submitTimeBefore":
            return Optional.ofNullable(clazz.cast(submitTimeBefore()));
        case "statusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "sortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("submitTimeAfter", SUBMIT_TIME_AFTER_FIELD);
        map.put("submitTimeBefore", SUBMIT_TIME_BEFORE_FIELD);
        map.put("statusEquals", STATUS_EQUALS_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("sortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAsyncInvokesRequest, T> g) {
        return obj -> g.apply((ListAsyncInvokesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAsyncInvokesRequest> {
        /**
         * <p>
         * Include invocations submitted after this time.
         * </p>
         * 
         * @param submitTimeAfter
         *        Include invocations submitted after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeAfter(Instant submitTimeAfter);

        /**
         * <p>
         * Include invocations submitted before this time.
         * </p>
         * 
         * @param submitTimeBefore
         *        Include invocations submitted before this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submitTimeBefore(Instant submitTimeBefore);

        /**
         * <p>
         * Filter invocations by status.
         * </p>
         * 
         * @param statusEquals
         *        Filter invocations by status.
         * @see AsyncInvokeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsyncInvokeStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * Filter invocations by status.
         * </p>
         * 
         * @param statusEquals
         *        Filter invocations by status.
         * @see AsyncInvokeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AsyncInvokeStatus
         */
        Builder statusEquals(AsyncInvokeStatus statusEquals);

        /**
         * <p>
         * The maximum number of invocations to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of invocations to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * How to sort the response.
         * </p>
         * 
         * @param sortBy
         *        How to sort the response.
         * @see SortAsyncInvocationBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortAsyncInvocationBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * How to sort the response.
         * </p>
         * 
         * @param sortBy
         *        How to sort the response.
         * @see SortAsyncInvocationBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortAsyncInvocationBy
         */
        Builder sortBy(SortAsyncInvocationBy sortBy);

        /**
         * <p>
         * The sorting order for the response.
         * </p>
         * 
         * @param sortOrder
         *        The sorting order for the response.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sorting order for the response.
         * </p>
         * 
         * @param sortOrder
         *        The sorting order for the response.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRuntimeRequest.BuilderImpl implements Builder {
        private Instant submitTimeAfter;

        private Instant submitTimeBefore;

        private String statusEquals;

        private Integer maxResults;

        private String nextToken;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAsyncInvokesRequest model) {
            super(model);
            submitTimeAfter(model.submitTimeAfter);
            submitTimeBefore(model.submitTimeBefore);
            statusEquals(model.statusEquals);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final Instant getSubmitTimeAfter() {
            return submitTimeAfter;
        }

        public final void setSubmitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
        }

        @Override
        public final Builder submitTimeAfter(Instant submitTimeAfter) {
            this.submitTimeAfter = submitTimeAfter;
            return this;
        }

        public final Instant getSubmitTimeBefore() {
            return submitTimeBefore;
        }

        public final void setSubmitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
        }

        @Override
        public final Builder submitTimeBefore(Instant submitTimeBefore) {
            this.submitTimeBefore = submitTimeBefore;
            return this;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(AsyncInvokeStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortAsyncInvocationBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAsyncInvokesRequest build() {
            return new ListAsyncInvokesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
