/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A streaming delta event that contains incremental image data during streaming responses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageBlockDelta implements SdkPojo, Serializable, ToCopyableBuilder<ImageBlockDelta.Builder, ImageBlockDelta> {
    private static final SdkField<ImageSource> SOURCE_FIELD = SdkField.<ImageSource> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(ImageBlockDelta::source)).setter(setter(Builder::source))
            .constructor(ImageSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<ErrorBlock> ERROR_FIELD = SdkField.<ErrorBlock> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(ImageBlockDelta::error)).setter(setter(Builder::error))
            .constructor(ErrorBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ImageSource source;

    private final ErrorBlock error;

    private ImageBlockDelta(BuilderImpl builder) {
        this.source = builder.source;
        this.error = builder.error;
    }

    /**
     * <p>
     * The incremental image source data for this delta event.
     * </p>
     * 
     * @return The incremental image source data for this delta event.
     */
    public final ImageSource source() {
        return source;
    }

    /**
     * <p>
     * Error information if this image delta could not be processed.
     * </p>
     * 
     * @return Error information if this image delta could not be processed.
     */
    public final ErrorBlock error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageBlockDelta)) {
            return false;
        }
        ImageBlockDelta other = (ImageBlockDelta) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageBlockDelta").add("Source", source() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Error", error() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageBlockDelta, T> g) {
        return obj -> g.apply((ImageBlockDelta) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageBlockDelta> {
        /**
         * <p>
         * The incremental image source data for this delta event.
         * </p>
         * 
         * @param source
         *        The incremental image source data for this delta event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ImageSource source);

        /**
         * <p>
         * The incremental image source data for this delta event.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageSource.Builder} avoiding the need to
         * create one manually via {@link ImageSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageSource.Builder#build()} is called immediately and its result
         * is passed to {@link #source(ImageSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ImageSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ImageSource)
         */
        default Builder source(Consumer<ImageSource.Builder> source) {
            return source(ImageSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * Error information if this image delta could not be processed.
         * </p>
         * 
         * @param error
         *        Error information if this image delta could not be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorBlock error);

        /**
         * <p>
         * Error information if this image delta could not be processed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorBlock.Builder} avoiding the need to
         * create one manually via {@link ErrorBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorBlock.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorBlock)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorBlock)
         */
        default Builder error(Consumer<ErrorBlock.Builder> error) {
            return error(ErrorBlock.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageSource source;

        private ErrorBlock error;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageBlockDelta model) {
            source(model.source);
            error(model.error);
        }

        public final ImageSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ImageSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ImageSource source) {
            this.source = source;
            return this;
        }

        public final ErrorBlock.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorBlock.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorBlock error) {
            this.error = error;
            return this;
        }

        @Override
        public ImageBlockDelta build() {
            return new ImageBlockDelta(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
