/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of automated reasoning policy evaluation, including logical findings about the validity of
 * claims made in the input content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailAutomatedReasoningPolicyAssessment implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailAutomatedReasoningPolicyAssessment.Builder, GuardrailAutomatedReasoningPolicyAssessment> {
    private static final SdkField<List<GuardrailAutomatedReasoningFinding>> FINDINGS_FIELD = SdkField
            .<List<GuardrailAutomatedReasoningFinding>> builder(MarshallingType.LIST)
            .memberName("findings")
            .getter(getter(GuardrailAutomatedReasoningPolicyAssessment::findings))
            .setter(setter(Builder::findings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailAutomatedReasoningFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailAutomatedReasoningFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GuardrailAutomatedReasoningFinding> findings;

    private GuardrailAutomatedReasoningPolicyAssessment(BuilderImpl builder) {
        this.findings = builder.findings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Findings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFindings() {
        return findings != null && !(findings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of logical validation results produced by evaluating the input content against automated reasoning policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFindings} method.
     * </p>
     * 
     * @return List of logical validation results produced by evaluating the input content against automated reasoning
     *         policies.
     */
    public final List<GuardrailAutomatedReasoningFinding> findings() {
        return findings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFindings() ? findings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningPolicyAssessment)) {
            return false;
        }
        GuardrailAutomatedReasoningPolicyAssessment other = (GuardrailAutomatedReasoningPolicyAssessment) obj;
        return hasFindings() == other.hasFindings() && Objects.equals(findings(), other.findings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailAutomatedReasoningPolicyAssessment").add("Findings", hasFindings() ? findings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findings":
            return Optional.ofNullable(clazz.cast(findings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("findings", FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningPolicyAssessment, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningPolicyAssessment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailAutomatedReasoningPolicyAssessment> {
        /**
         * <p>
         * List of logical validation results produced by evaluating the input content against automated reasoning
         * policies.
         * </p>
         * 
         * @param findings
         *        List of logical validation results produced by evaluating the input content against automated
         *        reasoning policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(Collection<GuardrailAutomatedReasoningFinding> findings);

        /**
         * <p>
         * List of logical validation results produced by evaluating the input content against automated reasoning
         * policies.
         * </p>
         * 
         * @param findings
         *        List of logical validation results produced by evaluating the input content against automated
         *        reasoning policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(GuardrailAutomatedReasoningFinding... findings);

        /**
         * <p>
         * List of logical validation results produced by evaluating the input content against automated reasoning
         * policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningFinding.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningFinding.Builder#build()}
         * is called immediately and its result is passed to {@link #findings(List<GuardrailAutomatedReasoningFinding>)}.
         * 
         * @param findings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findings(java.util.Collection<GuardrailAutomatedReasoningFinding>)
         */
        Builder findings(Consumer<GuardrailAutomatedReasoningFinding.Builder>... findings);
    }

    static final class BuilderImpl implements Builder {
        private List<GuardrailAutomatedReasoningFinding> findings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningPolicyAssessment model) {
            findings(model.findings);
        }

        public final List<GuardrailAutomatedReasoningFinding.Builder> getFindings() {
            List<GuardrailAutomatedReasoningFinding.Builder> result = GuardrailAutomatedReasoningFindingListCopier
                    .copyToBuilder(this.findings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindings(Collection<GuardrailAutomatedReasoningFinding.BuilderImpl> findings) {
            this.findings = GuardrailAutomatedReasoningFindingListCopier.copyFromBuilder(findings);
        }

        @Override
        public final Builder findings(Collection<GuardrailAutomatedReasoningFinding> findings) {
            this.findings = GuardrailAutomatedReasoningFindingListCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(GuardrailAutomatedReasoningFinding... findings) {
            findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<GuardrailAutomatedReasoningFinding.Builder>... findings) {
            findings(Stream.of(findings).map(c -> GuardrailAutomatedReasoningFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GuardrailAutomatedReasoningPolicyAssessment build() {
            return new GuardrailAutomatedReasoningPolicyAssessment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
