/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies logical issues in the translated statements that exist independent of any policy rules, such as statements
 * that are always true or always false.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailAutomatedReasoningLogicWarning implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailAutomatedReasoningLogicWarning.Builder, GuardrailAutomatedReasoningLogicWarning> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GuardrailAutomatedReasoningLogicWarning::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<GuardrailAutomatedReasoningStatement>> PREMISES_FIELD = SdkField
            .<List<GuardrailAutomatedReasoningStatement>> builder(MarshallingType.LIST)
            .memberName("premises")
            .getter(getter(GuardrailAutomatedReasoningLogicWarning::premises))
            .setter(setter(Builder::premises))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("premises").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailAutomatedReasoningStatement> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailAutomatedReasoningStatement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GuardrailAutomatedReasoningStatement>> CLAIMS_FIELD = SdkField
            .<List<GuardrailAutomatedReasoningStatement>> builder(MarshallingType.LIST)
            .memberName("claims")
            .getter(getter(GuardrailAutomatedReasoningLogicWarning::claims))
            .setter(setter(Builder::claims))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claims").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailAutomatedReasoningStatement> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailAutomatedReasoningStatement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PREMISES_FIELD,
            CLAIMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final List<GuardrailAutomatedReasoningStatement> premises;

    private final List<GuardrailAutomatedReasoningStatement> claims;

    private GuardrailAutomatedReasoningLogicWarning(BuilderImpl builder) {
        this.type = builder.type;
        this.premises = builder.premises;
        this.claims = builder.claims;
    }

    /**
     * <p>
     * The category of the detected logical issue, such as statements that are always true or always false.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailAutomatedReasoningLogicWarningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #typeAsString}.
     * </p>
     * 
     * @return The category of the detected logical issue, such as statements that are always true or always false.
     * @see GuardrailAutomatedReasoningLogicWarningType
     */
    public final GuardrailAutomatedReasoningLogicWarningType type() {
        return GuardrailAutomatedReasoningLogicWarningType.fromValue(type);
    }

    /**
     * <p>
     * The category of the detected logical issue, such as statements that are always true or always false.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailAutomatedReasoningLogicWarningType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #typeAsString}.
     * </p>
     * 
     * @return The category of the detected logical issue, such as statements that are always true or always false.
     * @see GuardrailAutomatedReasoningLogicWarningType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Premises property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPremises() {
        return premises != null && !(premises instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The logical statements that serve as premises under which the claims are validated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPremises} method.
     * </p>
     * 
     * @return The logical statements that serve as premises under which the claims are validated.
     */
    public final List<GuardrailAutomatedReasoningStatement> premises() {
        return premises;
    }

    /**
     * For responses, this returns true if the service returned a value for the Claims property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClaims() {
        return claims != null && !(claims instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The logical statements that are validated while assuming the policy and premises.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClaims} method.
     * </p>
     * 
     * @return The logical statements that are validated while assuming the policy and premises.
     */
    public final List<GuardrailAutomatedReasoningStatement> claims() {
        return claims;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPremises() ? premises() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasClaims() ? claims() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningLogicWarning)) {
            return false;
        }
        GuardrailAutomatedReasoningLogicWarning other = (GuardrailAutomatedReasoningLogicWarning) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && hasPremises() == other.hasPremises()
                && Objects.equals(premises(), other.premises()) && hasClaims() == other.hasClaims()
                && Objects.equals(claims(), other.claims());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailAutomatedReasoningLogicWarning").add("Type", typeAsString())
                .add("Premises", hasPremises() ? premises() : null).add("Claims", hasClaims() ? claims() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "premises":
            return Optional.ofNullable(clazz.cast(premises()));
        case "claims":
            return Optional.ofNullable(clazz.cast(claims()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("premises", PREMISES_FIELD);
        map.put("claims", CLAIMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningLogicWarning, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningLogicWarning) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailAutomatedReasoningLogicWarning> {
        /**
         * <p>
         * The category of the detected logical issue, such as statements that are always true or always false.
         * </p>
         * 
         * @param type
         *        The category of the detected logical issue, such as statements that are always true or always false.
         * @see GuardrailAutomatedReasoningLogicWarningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailAutomatedReasoningLogicWarningType
         */
        Builder type(String type);

        /**
         * <p>
         * The category of the detected logical issue, such as statements that are always true or always false.
         * </p>
         * 
         * @param type
         *        The category of the detected logical issue, such as statements that are always true or always false.
         * @see GuardrailAutomatedReasoningLogicWarningType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailAutomatedReasoningLogicWarningType
         */
        Builder type(GuardrailAutomatedReasoningLogicWarningType type);

        /**
         * <p>
         * The logical statements that serve as premises under which the claims are validated.
         * </p>
         * 
         * @param premises
         *        The logical statements that serve as premises under which the claims are validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder premises(Collection<GuardrailAutomatedReasoningStatement> premises);

        /**
         * <p>
         * The logical statements that serve as premises under which the claims are validated.
         * </p>
         * 
         * @param premises
         *        The logical statements that serve as premises under which the claims are validated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder premises(GuardrailAutomatedReasoningStatement... premises);

        /**
         * <p>
         * The logical statements that serve as premises under which the claims are validated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatement.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatement.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #premises(List<GuardrailAutomatedReasoningStatement>)}.
         * 
         * @param premises
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #premises(java.util.Collection<GuardrailAutomatedReasoningStatement>)
         */
        Builder premises(Consumer<GuardrailAutomatedReasoningStatement.Builder>... premises);

        /**
         * <p>
         * The logical statements that are validated while assuming the policy and premises.
         * </p>
         * 
         * @param claims
         *        The logical statements that are validated while assuming the policy and premises.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claims(Collection<GuardrailAutomatedReasoningStatement> claims);

        /**
         * <p>
         * The logical statements that are validated while assuming the policy and premises.
         * </p>
         * 
         * @param claims
         *        The logical statements that are validated while assuming the policy and premises.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claims(GuardrailAutomatedReasoningStatement... claims);

        /**
         * <p>
         * The logical statements that are validated while assuming the policy and premises.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatement.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatement.Builder#build()}
         * is called immediately and its result is passed to {@link #claims(List<GuardrailAutomatedReasoningStatement>)}.
         * 
         * @param claims
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAutomatedReasoningStatement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #claims(java.util.Collection<GuardrailAutomatedReasoningStatement>)
         */
        Builder claims(Consumer<GuardrailAutomatedReasoningStatement.Builder>... claims);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private List<GuardrailAutomatedReasoningStatement> premises = DefaultSdkAutoConstructList.getInstance();

        private List<GuardrailAutomatedReasoningStatement> claims = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningLogicWarning model) {
            type(model.type);
            premises(model.premises);
            claims(model.claims);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailAutomatedReasoningLogicWarningType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<GuardrailAutomatedReasoningStatement.Builder> getPremises() {
            List<GuardrailAutomatedReasoningStatement.Builder> result = GuardrailAutomatedReasoningStatementListCopier
                    .copyToBuilder(this.premises);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPremises(Collection<GuardrailAutomatedReasoningStatement.BuilderImpl> premises) {
            this.premises = GuardrailAutomatedReasoningStatementListCopier.copyFromBuilder(premises);
        }

        @Override
        public final Builder premises(Collection<GuardrailAutomatedReasoningStatement> premises) {
            this.premises = GuardrailAutomatedReasoningStatementListCopier.copy(premises);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premises(GuardrailAutomatedReasoningStatement... premises) {
            premises(Arrays.asList(premises));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premises(Consumer<GuardrailAutomatedReasoningStatement.Builder>... premises) {
            premises(Stream.of(premises).map(c -> GuardrailAutomatedReasoningStatement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailAutomatedReasoningStatement.Builder> getClaims() {
            List<GuardrailAutomatedReasoningStatement.Builder> result = GuardrailAutomatedReasoningStatementListCopier
                    .copyToBuilder(this.claims);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClaims(Collection<GuardrailAutomatedReasoningStatement.BuilderImpl> claims) {
            this.claims = GuardrailAutomatedReasoningStatementListCopier.copyFromBuilder(claims);
        }

        @Override
        public final Builder claims(Collection<GuardrailAutomatedReasoningStatement> claims) {
            this.claims = GuardrailAutomatedReasoningStatementListCopier.copy(claims);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder claims(GuardrailAutomatedReasoningStatement... claims) {
            claims(Arrays.asList(claims));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder claims(Consumer<GuardrailAutomatedReasoningStatement.Builder>... claims) {
            claims(Stream.of(claims).map(c -> GuardrailAutomatedReasoningStatement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GuardrailAutomatedReasoningLogicWarning build() {
            return new GuardrailAutomatedReasoningLogicWarning(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
