/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a logical validation result from automated reasoning policy evaluation. The finding indicates whether
 * claims in the input are logically valid, invalid, satisfiable, impossible, or have other logical issues.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailAutomatedReasoningFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailAutomatedReasoningFinding.Builder, GuardrailAutomatedReasoningFinding> {
    private static final SdkField<GuardrailAutomatedReasoningValidFinding> VALID_FIELD = SdkField
            .<GuardrailAutomatedReasoningValidFinding> builder(MarshallingType.SDK_POJO).memberName("valid")
            .getter(getter(GuardrailAutomatedReasoningFinding::valid)).setter(setter(Builder::valid))
            .constructor(GuardrailAutomatedReasoningValidFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valid").build()).build();

    private static final SdkField<GuardrailAutomatedReasoningInvalidFinding> INVALID_FIELD = SdkField
            .<GuardrailAutomatedReasoningInvalidFinding> builder(MarshallingType.SDK_POJO).memberName("invalid")
            .getter(getter(GuardrailAutomatedReasoningFinding::invalid)).setter(setter(Builder::invalid))
            .constructor(GuardrailAutomatedReasoningInvalidFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalid").build()).build();

    private static final SdkField<GuardrailAutomatedReasoningSatisfiableFinding> SATISFIABLE_FIELD = SdkField
            .<GuardrailAutomatedReasoningSatisfiableFinding> builder(MarshallingType.SDK_POJO).memberName("satisfiable")
            .getter(getter(GuardrailAutomatedReasoningFinding::satisfiable)).setter(setter(Builder::satisfiable))
            .constructor(GuardrailAutomatedReasoningSatisfiableFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satisfiable").build()).build();

    private static final SdkField<GuardrailAutomatedReasoningImpossibleFinding> IMPOSSIBLE_FIELD = SdkField
            .<GuardrailAutomatedReasoningImpossibleFinding> builder(MarshallingType.SDK_POJO).memberName("impossible")
            .getter(getter(GuardrailAutomatedReasoningFinding::impossible)).setter(setter(Builder::impossible))
            .constructor(GuardrailAutomatedReasoningImpossibleFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impossible").build()).build();

    private static final SdkField<GuardrailAutomatedReasoningTranslationAmbiguousFinding> TRANSLATION_AMBIGUOUS_FIELD = SdkField
            .<GuardrailAutomatedReasoningTranslationAmbiguousFinding> builder(MarshallingType.SDK_POJO)
            .memberName("translationAmbiguous").getter(getter(GuardrailAutomatedReasoningFinding::translationAmbiguous))
            .setter(setter(Builder::translationAmbiguous))
            .constructor(GuardrailAutomatedReasoningTranslationAmbiguousFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translationAmbiguous").build())
            .build();

    private static final SdkField<GuardrailAutomatedReasoningTooComplexFinding> TOO_COMPLEX_FIELD = SdkField
            .<GuardrailAutomatedReasoningTooComplexFinding> builder(MarshallingType.SDK_POJO).memberName("tooComplex")
            .getter(getter(GuardrailAutomatedReasoningFinding::tooComplex)).setter(setter(Builder::tooComplex))
            .constructor(GuardrailAutomatedReasoningTooComplexFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tooComplex").build()).build();

    private static final SdkField<GuardrailAutomatedReasoningNoTranslationsFinding> NO_TRANSLATIONS_FIELD = SdkField
            .<GuardrailAutomatedReasoningNoTranslationsFinding> builder(MarshallingType.SDK_POJO).memberName("noTranslations")
            .getter(getter(GuardrailAutomatedReasoningFinding::noTranslations)).setter(setter(Builder::noTranslations))
            .constructor(GuardrailAutomatedReasoningNoTranslationsFinding::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noTranslations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALID_FIELD, INVALID_FIELD,
            SATISFIABLE_FIELD, IMPOSSIBLE_FIELD, TRANSLATION_AMBIGUOUS_FIELD, TOO_COMPLEX_FIELD, NO_TRANSLATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GuardrailAutomatedReasoningValidFinding valid;

    private final GuardrailAutomatedReasoningInvalidFinding invalid;

    private final GuardrailAutomatedReasoningSatisfiableFinding satisfiable;

    private final GuardrailAutomatedReasoningImpossibleFinding impossible;

    private final GuardrailAutomatedReasoningTranslationAmbiguousFinding translationAmbiguous;

    private final GuardrailAutomatedReasoningTooComplexFinding tooComplex;

    private final GuardrailAutomatedReasoningNoTranslationsFinding noTranslations;

    private final Type type;

    private GuardrailAutomatedReasoningFinding(BuilderImpl builder) {
        this.valid = builder.valid;
        this.invalid = builder.invalid;
        this.satisfiable = builder.satisfiable;
        this.impossible = builder.impossible;
        this.translationAmbiguous = builder.translationAmbiguous;
        this.tooComplex = builder.tooComplex;
        this.noTranslations = builder.noTranslations;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains the result when the automated reasoning evaluation determines that the claims in the input are logically
     * valid and definitively true based on the provided premises and policy rules.
     * </p>
     * 
     * @return Contains the result when the automated reasoning evaluation determines that the claims in the input are
     *         logically valid and definitively true based on the provided premises and policy rules.
     */
    public final GuardrailAutomatedReasoningValidFinding valid() {
        return valid;
    }

    /**
     * <p>
     * Contains the result when the automated reasoning evaluation determines that the claims in the input are logically
     * invalid and contradict the established premises or policy rules.
     * </p>
     * 
     * @return Contains the result when the automated reasoning evaluation determines that the claims in the input are
     *         logically invalid and contradict the established premises or policy rules.
     */
    public final GuardrailAutomatedReasoningInvalidFinding invalid() {
        return invalid;
    }

    /**
     * <p>
     * Contains the result when the automated reasoning evaluation determines that the claims in the input could be
     * either true or false depending on additional assumptions not provided in the input context.
     * </p>
     * 
     * @return Contains the result when the automated reasoning evaluation determines that the claims in the input could
     *         be either true or false depending on additional assumptions not provided in the input context.
     */
    public final GuardrailAutomatedReasoningSatisfiableFinding satisfiable() {
        return satisfiable;
    }

    /**
     * <p>
     * Contains the result when the automated reasoning evaluation determines that no valid logical conclusions can be
     * drawn due to contradictions in the premises or policy rules themselves.
     * </p>
     * 
     * @return Contains the result when the automated reasoning evaluation determines that no valid logical conclusions
     *         can be drawn due to contradictions in the premises or policy rules themselves.
     */
    public final GuardrailAutomatedReasoningImpossibleFinding impossible() {
        return impossible;
    }

    /**
     * <p>
     * Contains the result when the automated reasoning evaluation detects that the input has multiple valid logical
     * interpretations, requiring additional context or clarification to proceed with validation.
     * </p>
     * 
     * @return Contains the result when the automated reasoning evaluation detects that the input has multiple valid
     *         logical interpretations, requiring additional context or clarification to proceed with validation.
     */
    public final GuardrailAutomatedReasoningTranslationAmbiguousFinding translationAmbiguous() {
        return translationAmbiguous;
    }

    /**
     * <p>
     * Contains the result when the automated reasoning evaluation cannot process the input due to its complexity or
     * volume exceeding the system's processing capacity for logical analysis.
     * </p>
     * 
     * @return Contains the result when the automated reasoning evaluation cannot process the input due to its
     *         complexity or volume exceeding the system's processing capacity for logical analysis.
     */
    public final GuardrailAutomatedReasoningTooComplexFinding tooComplex() {
        return tooComplex;
    }

    /**
     * <p>
     * Contains the result when the automated reasoning evaluation cannot extract any relevant logical information from
     * the input that can be validated against the policy rules.
     * </p>
     * 
     * @return Contains the result when the automated reasoning evaluation cannot extract any relevant logical
     *         information from the input that can be validated against the policy rules.
     */
    public final GuardrailAutomatedReasoningNoTranslationsFinding noTranslations() {
        return noTranslations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valid());
        hashCode = 31 * hashCode + Objects.hashCode(invalid());
        hashCode = 31 * hashCode + Objects.hashCode(satisfiable());
        hashCode = 31 * hashCode + Objects.hashCode(impossible());
        hashCode = 31 * hashCode + Objects.hashCode(translationAmbiguous());
        hashCode = 31 * hashCode + Objects.hashCode(tooComplex());
        hashCode = 31 * hashCode + Objects.hashCode(noTranslations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningFinding)) {
            return false;
        }
        GuardrailAutomatedReasoningFinding other = (GuardrailAutomatedReasoningFinding) obj;
        return Objects.equals(valid(), other.valid()) && Objects.equals(invalid(), other.invalid())
                && Objects.equals(satisfiable(), other.satisfiable()) && Objects.equals(impossible(), other.impossible())
                && Objects.equals(translationAmbiguous(), other.translationAmbiguous())
                && Objects.equals(tooComplex(), other.tooComplex()) && Objects.equals(noTranslations(), other.noTranslations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailAutomatedReasoningFinding").add("Valid", valid()).add("Invalid", invalid())
                .add("Satisfiable", satisfiable()).add("Impossible", impossible())
                .add("TranslationAmbiguous", translationAmbiguous()).add("TooComplex", tooComplex())
                .add("NoTranslations", noTranslations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "valid":
            return Optional.ofNullable(clazz.cast(valid()));
        case "invalid":
            return Optional.ofNullable(clazz.cast(invalid()));
        case "satisfiable":
            return Optional.ofNullable(clazz.cast(satisfiable()));
        case "impossible":
            return Optional.ofNullable(clazz.cast(impossible()));
        case "translationAmbiguous":
            return Optional.ofNullable(clazz.cast(translationAmbiguous()));
        case "tooComplex":
            return Optional.ofNullable(clazz.cast(tooComplex()));
        case "noTranslations":
            return Optional.ofNullable(clazz.cast(noTranslations()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #valid()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation determines that the claims in the input are logically
     * valid and definitively true based on the provided premises and policy rules.
     * </p>
     * 
     * @param valid
     *        Contains the result when the automated reasoning evaluation determines that the claims in the input are
     *        logically valid and definitively true based on the provided premises and policy rules.
     */
    public static GuardrailAutomatedReasoningFinding fromValid(GuardrailAutomatedReasoningValidFinding valid) {
        return builder().valid(valid).build();
    }

    /**
     * Create an instance of this class with {@link #valid()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation determines that the claims in the input are logically
     * valid and definitively true based on the provided premises and policy rules.
     * </p>
     * 
     * @param valid
     *        Contains the result when the automated reasoning evaluation determines that the claims in the input are
     *        logically valid and definitively true based on the provided premises and policy rules.
     */
    public static GuardrailAutomatedReasoningFinding fromValid(Consumer<GuardrailAutomatedReasoningValidFinding.Builder> valid) {
        GuardrailAutomatedReasoningValidFinding.Builder builder = GuardrailAutomatedReasoningValidFinding.builder();
        valid.accept(builder);
        return fromValid(builder.build());
    }

    /**
     * Create an instance of this class with {@link #invalid()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation determines that the claims in the input are logically
     * invalid and contradict the established premises or policy rules.
     * </p>
     * 
     * @param invalid
     *        Contains the result when the automated reasoning evaluation determines that the claims in the input are
     *        logically invalid and contradict the established premises or policy rules.
     */
    public static GuardrailAutomatedReasoningFinding fromInvalid(GuardrailAutomatedReasoningInvalidFinding invalid) {
        return builder().invalid(invalid).build();
    }

    /**
     * Create an instance of this class with {@link #invalid()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation determines that the claims in the input are logically
     * invalid and contradict the established premises or policy rules.
     * </p>
     * 
     * @param invalid
     *        Contains the result when the automated reasoning evaluation determines that the claims in the input are
     *        logically invalid and contradict the established premises or policy rules.
     */
    public static GuardrailAutomatedReasoningFinding fromInvalid(
            Consumer<GuardrailAutomatedReasoningInvalidFinding.Builder> invalid) {
        GuardrailAutomatedReasoningInvalidFinding.Builder builder = GuardrailAutomatedReasoningInvalidFinding.builder();
        invalid.accept(builder);
        return fromInvalid(builder.build());
    }

    /**
     * Create an instance of this class with {@link #satisfiable()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation determines that the claims in the input could be
     * either true or false depending on additional assumptions not provided in the input context.
     * </p>
     * 
     * @param satisfiable
     *        Contains the result when the automated reasoning evaluation determines that the claims in the input could
     *        be either true or false depending on additional assumptions not provided in the input context.
     */
    public static GuardrailAutomatedReasoningFinding fromSatisfiable(GuardrailAutomatedReasoningSatisfiableFinding satisfiable) {
        return builder().satisfiable(satisfiable).build();
    }

    /**
     * Create an instance of this class with {@link #satisfiable()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation determines that the claims in the input could be
     * either true or false depending on additional assumptions not provided in the input context.
     * </p>
     * 
     * @param satisfiable
     *        Contains the result when the automated reasoning evaluation determines that the claims in the input could
     *        be either true or false depending on additional assumptions not provided in the input context.
     */
    public static GuardrailAutomatedReasoningFinding fromSatisfiable(
            Consumer<GuardrailAutomatedReasoningSatisfiableFinding.Builder> satisfiable) {
        GuardrailAutomatedReasoningSatisfiableFinding.Builder builder = GuardrailAutomatedReasoningSatisfiableFinding.builder();
        satisfiable.accept(builder);
        return fromSatisfiable(builder.build());
    }

    /**
     * Create an instance of this class with {@link #impossible()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation determines that no valid logical conclusions can be
     * drawn due to contradictions in the premises or policy rules themselves.
     * </p>
     * 
     * @param impossible
     *        Contains the result when the automated reasoning evaluation determines that no valid logical conclusions
     *        can be drawn due to contradictions in the premises or policy rules themselves.
     */
    public static GuardrailAutomatedReasoningFinding fromImpossible(GuardrailAutomatedReasoningImpossibleFinding impossible) {
        return builder().impossible(impossible).build();
    }

    /**
     * Create an instance of this class with {@link #impossible()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation determines that no valid logical conclusions can be
     * drawn due to contradictions in the premises or policy rules themselves.
     * </p>
     * 
     * @param impossible
     *        Contains the result when the automated reasoning evaluation determines that no valid logical conclusions
     *        can be drawn due to contradictions in the premises or policy rules themselves.
     */
    public static GuardrailAutomatedReasoningFinding fromImpossible(
            Consumer<GuardrailAutomatedReasoningImpossibleFinding.Builder> impossible) {
        GuardrailAutomatedReasoningImpossibleFinding.Builder builder = GuardrailAutomatedReasoningImpossibleFinding.builder();
        impossible.accept(builder);
        return fromImpossible(builder.build());
    }

    /**
     * Create an instance of this class with {@link #translationAmbiguous()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation detects that the input has multiple valid logical
     * interpretations, requiring additional context or clarification to proceed with validation.
     * </p>
     * 
     * @param translationAmbiguous
     *        Contains the result when the automated reasoning evaluation detects that the input has multiple valid
     *        logical interpretations, requiring additional context or clarification to proceed with validation.
     */
    public static GuardrailAutomatedReasoningFinding fromTranslationAmbiguous(
            GuardrailAutomatedReasoningTranslationAmbiguousFinding translationAmbiguous) {
        return builder().translationAmbiguous(translationAmbiguous).build();
    }

    /**
     * Create an instance of this class with {@link #translationAmbiguous()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation detects that the input has multiple valid logical
     * interpretations, requiring additional context or clarification to proceed with validation.
     * </p>
     * 
     * @param translationAmbiguous
     *        Contains the result when the automated reasoning evaluation detects that the input has multiple valid
     *        logical interpretations, requiring additional context or clarification to proceed with validation.
     */
    public static GuardrailAutomatedReasoningFinding fromTranslationAmbiguous(
            Consumer<GuardrailAutomatedReasoningTranslationAmbiguousFinding.Builder> translationAmbiguous) {
        GuardrailAutomatedReasoningTranslationAmbiguousFinding.Builder builder = GuardrailAutomatedReasoningTranslationAmbiguousFinding
                .builder();
        translationAmbiguous.accept(builder);
        return fromTranslationAmbiguous(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tooComplex()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation cannot process the input due to its complexity or
     * volume exceeding the system's processing capacity for logical analysis.
     * </p>
     * 
     * @param tooComplex
     *        Contains the result when the automated reasoning evaluation cannot process the input due to its complexity
     *        or volume exceeding the system's processing capacity for logical analysis.
     */
    public static GuardrailAutomatedReasoningFinding fromTooComplex(GuardrailAutomatedReasoningTooComplexFinding tooComplex) {
        return builder().tooComplex(tooComplex).build();
    }

    /**
     * Create an instance of this class with {@link #tooComplex()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation cannot process the input due to its complexity or
     * volume exceeding the system's processing capacity for logical analysis.
     * </p>
     * 
     * @param tooComplex
     *        Contains the result when the automated reasoning evaluation cannot process the input due to its complexity
     *        or volume exceeding the system's processing capacity for logical analysis.
     */
    public static GuardrailAutomatedReasoningFinding fromTooComplex(
            Consumer<GuardrailAutomatedReasoningTooComplexFinding.Builder> tooComplex) {
        GuardrailAutomatedReasoningTooComplexFinding.Builder builder = GuardrailAutomatedReasoningTooComplexFinding.builder();
        tooComplex.accept(builder);
        return fromTooComplex(builder.build());
    }

    /**
     * Create an instance of this class with {@link #noTranslations()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation cannot extract any relevant logical information from
     * the input that can be validated against the policy rules.
     * </p>
     * 
     * @param noTranslations
     *        Contains the result when the automated reasoning evaluation cannot extract any relevant logical
     *        information from the input that can be validated against the policy rules.
     */
    public static GuardrailAutomatedReasoningFinding fromNoTranslations(
            GuardrailAutomatedReasoningNoTranslationsFinding noTranslations) {
        return builder().noTranslations(noTranslations).build();
    }

    /**
     * Create an instance of this class with {@link #noTranslations()} initialized to the given value.
     *
     * <p>
     * Contains the result when the automated reasoning evaluation cannot extract any relevant logical information from
     * the input that can be validated against the policy rules.
     * </p>
     * 
     * @param noTranslations
     *        Contains the result when the automated reasoning evaluation cannot extract any relevant logical
     *        information from the input that can be validated against the policy rules.
     */
    public static GuardrailAutomatedReasoningFinding fromNoTranslations(
            Consumer<GuardrailAutomatedReasoningNoTranslationsFinding.Builder> noTranslations) {
        GuardrailAutomatedReasoningNoTranslationsFinding.Builder builder = GuardrailAutomatedReasoningNoTranslationsFinding
                .builder();
        noTranslations.accept(builder);
        return fromNoTranslations(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("valid", VALID_FIELD);
        map.put("invalid", INVALID_FIELD);
        map.put("satisfiable", SATISFIABLE_FIELD);
        map.put("impossible", IMPOSSIBLE_FIELD);
        map.put("translationAmbiguous", TRANSLATION_AMBIGUOUS_FIELD);
        map.put("tooComplex", TOO_COMPLEX_FIELD);
        map.put("noTranslations", NO_TRANSLATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningFinding, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailAutomatedReasoningFinding> {
        /**
         * <p>
         * Contains the result when the automated reasoning evaluation determines that the claims in the input are
         * logically valid and definitively true based on the provided premises and policy rules.
         * </p>
         * 
         * @param valid
         *        Contains the result when the automated reasoning evaluation determines that the claims in the input
         *        are logically valid and definitively true based on the provided premises and policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valid(GuardrailAutomatedReasoningValidFinding valid);

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation determines that the claims in the input are
         * logically valid and definitively true based on the provided premises and policy rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningValidFinding.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningValidFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningValidFinding.Builder#build()} is
         * called immediately and its result is passed to {@link #valid(GuardrailAutomatedReasoningValidFinding)}.
         * 
         * @param valid
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningValidFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valid(GuardrailAutomatedReasoningValidFinding)
         */
        default Builder valid(Consumer<GuardrailAutomatedReasoningValidFinding.Builder> valid) {
            return valid(GuardrailAutomatedReasoningValidFinding.builder().applyMutation(valid).build());
        }

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation determines that the claims in the input are
         * logically invalid and contradict the established premises or policy rules.
         * </p>
         * 
         * @param invalid
         *        Contains the result when the automated reasoning evaluation determines that the claims in the input
         *        are logically invalid and contradict the established premises or policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalid(GuardrailAutomatedReasoningInvalidFinding invalid);

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation determines that the claims in the input are
         * logically invalid and contradict the established premises or policy rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningInvalidFinding.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningInvalidFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningInvalidFinding.Builder#build()} is
         * called immediately and its result is passed to {@link #invalid(GuardrailAutomatedReasoningInvalidFinding)}.
         * 
         * @param invalid
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningInvalidFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalid(GuardrailAutomatedReasoningInvalidFinding)
         */
        default Builder invalid(Consumer<GuardrailAutomatedReasoningInvalidFinding.Builder> invalid) {
            return invalid(GuardrailAutomatedReasoningInvalidFinding.builder().applyMutation(invalid).build());
        }

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation determines that the claims in the input could be
         * either true or false depending on additional assumptions not provided in the input context.
         * </p>
         * 
         * @param satisfiable
         *        Contains the result when the automated reasoning evaluation determines that the claims in the input
         *        could be either true or false depending on additional assumptions not provided in the input context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder satisfiable(GuardrailAutomatedReasoningSatisfiableFinding satisfiable);

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation determines that the claims in the input could be
         * either true or false depending on additional assumptions not provided in the input context.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningSatisfiableFinding.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningSatisfiableFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningSatisfiableFinding.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #satisfiable(GuardrailAutomatedReasoningSatisfiableFinding)}.
         * 
         * @param satisfiable
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningSatisfiableFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #satisfiable(GuardrailAutomatedReasoningSatisfiableFinding)
         */
        default Builder satisfiable(Consumer<GuardrailAutomatedReasoningSatisfiableFinding.Builder> satisfiable) {
            return satisfiable(GuardrailAutomatedReasoningSatisfiableFinding.builder().applyMutation(satisfiable).build());
        }

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation determines that no valid logical conclusions can
         * be drawn due to contradictions in the premises or policy rules themselves.
         * </p>
         * 
         * @param impossible
         *        Contains the result when the automated reasoning evaluation determines that no valid logical
         *        conclusions can be drawn due to contradictions in the premises or policy rules themselves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impossible(GuardrailAutomatedReasoningImpossibleFinding impossible);

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation determines that no valid logical conclusions can
         * be drawn due to contradictions in the premises or policy rules themselves.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningImpossibleFinding.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningImpossibleFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningImpossibleFinding.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #impossible(GuardrailAutomatedReasoningImpossibleFinding)}.
         * 
         * @param impossible
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningImpossibleFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #impossible(GuardrailAutomatedReasoningImpossibleFinding)
         */
        default Builder impossible(Consumer<GuardrailAutomatedReasoningImpossibleFinding.Builder> impossible) {
            return impossible(GuardrailAutomatedReasoningImpossibleFinding.builder().applyMutation(impossible).build());
        }

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation detects that the input has multiple valid logical
         * interpretations, requiring additional context or clarification to proceed with validation.
         * </p>
         * 
         * @param translationAmbiguous
         *        Contains the result when the automated reasoning evaluation detects that the input has multiple valid
         *        logical interpretations, requiring additional context or clarification to proceed with validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder translationAmbiguous(GuardrailAutomatedReasoningTranslationAmbiguousFinding translationAmbiguous);

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation detects that the input has multiple valid logical
         * interpretations, requiring additional context or clarification to proceed with validation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningTranslationAmbiguousFinding.Builder} avoiding the need to create one
         * manually via {@link GuardrailAutomatedReasoningTranslationAmbiguousFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link GuardrailAutomatedReasoningTranslationAmbiguousFinding.Builder#build()} is called immediately and its
         * result is passed to {@link #translationAmbiguous(GuardrailAutomatedReasoningTranslationAmbiguousFinding)}.
         * 
         * @param translationAmbiguous
         *        a consumer that will call methods on
         *        {@link GuardrailAutomatedReasoningTranslationAmbiguousFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #translationAmbiguous(GuardrailAutomatedReasoningTranslationAmbiguousFinding)
         */
        default Builder translationAmbiguous(
                Consumer<GuardrailAutomatedReasoningTranslationAmbiguousFinding.Builder> translationAmbiguous) {
            return translationAmbiguous(GuardrailAutomatedReasoningTranslationAmbiguousFinding.builder()
                    .applyMutation(translationAmbiguous).build());
        }

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation cannot process the input due to its complexity or
         * volume exceeding the system's processing capacity for logical analysis.
         * </p>
         * 
         * @param tooComplex
         *        Contains the result when the automated reasoning evaluation cannot process the input due to its
         *        complexity or volume exceeding the system's processing capacity for logical analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooComplex(GuardrailAutomatedReasoningTooComplexFinding tooComplex);

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation cannot process the input due to its complexity or
         * volume exceeding the system's processing capacity for logical analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningTooComplexFinding.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningTooComplexFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningTooComplexFinding.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #tooComplex(GuardrailAutomatedReasoningTooComplexFinding)}.
         * 
         * @param tooComplex
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningTooComplexFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooComplex(GuardrailAutomatedReasoningTooComplexFinding)
         */
        default Builder tooComplex(Consumer<GuardrailAutomatedReasoningTooComplexFinding.Builder> tooComplex) {
            return tooComplex(GuardrailAutomatedReasoningTooComplexFinding.builder().applyMutation(tooComplex).build());
        }

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation cannot extract any relevant logical information
         * from the input that can be validated against the policy rules.
         * </p>
         * 
         * @param noTranslations
         *        Contains the result when the automated reasoning evaluation cannot extract any relevant logical
         *        information from the input that can be validated against the policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noTranslations(GuardrailAutomatedReasoningNoTranslationsFinding noTranslations);

        /**
         * <p>
         * Contains the result when the automated reasoning evaluation cannot extract any relevant logical information
         * from the input that can be validated against the policy rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningNoTranslationsFinding.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningNoTranslationsFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningNoTranslationsFinding.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #noTranslations(GuardrailAutomatedReasoningNoTranslationsFinding)}.
         * 
         * @param noTranslations
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningNoTranslationsFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #noTranslations(GuardrailAutomatedReasoningNoTranslationsFinding)
         */
        default Builder noTranslations(Consumer<GuardrailAutomatedReasoningNoTranslationsFinding.Builder> noTranslations) {
            return noTranslations(GuardrailAutomatedReasoningNoTranslationsFinding.builder().applyMutation(noTranslations)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GuardrailAutomatedReasoningValidFinding valid;

        private GuardrailAutomatedReasoningInvalidFinding invalid;

        private GuardrailAutomatedReasoningSatisfiableFinding satisfiable;

        private GuardrailAutomatedReasoningImpossibleFinding impossible;

        private GuardrailAutomatedReasoningTranslationAmbiguousFinding translationAmbiguous;

        private GuardrailAutomatedReasoningTooComplexFinding tooComplex;

        private GuardrailAutomatedReasoningNoTranslationsFinding noTranslations;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningFinding model) {
            valid(model.valid);
            invalid(model.invalid);
            satisfiable(model.satisfiable);
            impossible(model.impossible);
            translationAmbiguous(model.translationAmbiguous);
            tooComplex(model.tooComplex);
            noTranslations(model.noTranslations);
        }

        public final GuardrailAutomatedReasoningValidFinding.Builder getValid() {
            return valid != null ? valid.toBuilder() : null;
        }

        public final void setValid(GuardrailAutomatedReasoningValidFinding.BuilderImpl valid) {
            Object oldValue = this.valid;
            this.valid = valid != null ? valid.build() : null;
            handleUnionValueChange(Type.VALID, oldValue, this.valid);
        }

        @Override
        public final Builder valid(GuardrailAutomatedReasoningValidFinding valid) {
            Object oldValue = this.valid;
            this.valid = valid;
            handleUnionValueChange(Type.VALID, oldValue, this.valid);
            return this;
        }

        public final GuardrailAutomatedReasoningInvalidFinding.Builder getInvalid() {
            return invalid != null ? invalid.toBuilder() : null;
        }

        public final void setInvalid(GuardrailAutomatedReasoningInvalidFinding.BuilderImpl invalid) {
            Object oldValue = this.invalid;
            this.invalid = invalid != null ? invalid.build() : null;
            handleUnionValueChange(Type.INVALID, oldValue, this.invalid);
        }

        @Override
        public final Builder invalid(GuardrailAutomatedReasoningInvalidFinding invalid) {
            Object oldValue = this.invalid;
            this.invalid = invalid;
            handleUnionValueChange(Type.INVALID, oldValue, this.invalid);
            return this;
        }

        public final GuardrailAutomatedReasoningSatisfiableFinding.Builder getSatisfiable() {
            return satisfiable != null ? satisfiable.toBuilder() : null;
        }

        public final void setSatisfiable(GuardrailAutomatedReasoningSatisfiableFinding.BuilderImpl satisfiable) {
            Object oldValue = this.satisfiable;
            this.satisfiable = satisfiable != null ? satisfiable.build() : null;
            handleUnionValueChange(Type.SATISFIABLE, oldValue, this.satisfiable);
        }

        @Override
        public final Builder satisfiable(GuardrailAutomatedReasoningSatisfiableFinding satisfiable) {
            Object oldValue = this.satisfiable;
            this.satisfiable = satisfiable;
            handleUnionValueChange(Type.SATISFIABLE, oldValue, this.satisfiable);
            return this;
        }

        public final GuardrailAutomatedReasoningImpossibleFinding.Builder getImpossible() {
            return impossible != null ? impossible.toBuilder() : null;
        }

        public final void setImpossible(GuardrailAutomatedReasoningImpossibleFinding.BuilderImpl impossible) {
            Object oldValue = this.impossible;
            this.impossible = impossible != null ? impossible.build() : null;
            handleUnionValueChange(Type.IMPOSSIBLE, oldValue, this.impossible);
        }

        @Override
        public final Builder impossible(GuardrailAutomatedReasoningImpossibleFinding impossible) {
            Object oldValue = this.impossible;
            this.impossible = impossible;
            handleUnionValueChange(Type.IMPOSSIBLE, oldValue, this.impossible);
            return this;
        }

        public final GuardrailAutomatedReasoningTranslationAmbiguousFinding.Builder getTranslationAmbiguous() {
            return translationAmbiguous != null ? translationAmbiguous.toBuilder() : null;
        }

        public final void setTranslationAmbiguous(
                GuardrailAutomatedReasoningTranslationAmbiguousFinding.BuilderImpl translationAmbiguous) {
            Object oldValue = this.translationAmbiguous;
            this.translationAmbiguous = translationAmbiguous != null ? translationAmbiguous.build() : null;
            handleUnionValueChange(Type.TRANSLATION_AMBIGUOUS, oldValue, this.translationAmbiguous);
        }

        @Override
        public final Builder translationAmbiguous(GuardrailAutomatedReasoningTranslationAmbiguousFinding translationAmbiguous) {
            Object oldValue = this.translationAmbiguous;
            this.translationAmbiguous = translationAmbiguous;
            handleUnionValueChange(Type.TRANSLATION_AMBIGUOUS, oldValue, this.translationAmbiguous);
            return this;
        }

        public final GuardrailAutomatedReasoningTooComplexFinding.Builder getTooComplex() {
            return tooComplex != null ? tooComplex.toBuilder() : null;
        }

        public final void setTooComplex(GuardrailAutomatedReasoningTooComplexFinding.BuilderImpl tooComplex) {
            Object oldValue = this.tooComplex;
            this.tooComplex = tooComplex != null ? tooComplex.build() : null;
            handleUnionValueChange(Type.TOO_COMPLEX, oldValue, this.tooComplex);
        }

        @Override
        public final Builder tooComplex(GuardrailAutomatedReasoningTooComplexFinding tooComplex) {
            Object oldValue = this.tooComplex;
            this.tooComplex = tooComplex;
            handleUnionValueChange(Type.TOO_COMPLEX, oldValue, this.tooComplex);
            return this;
        }

        public final GuardrailAutomatedReasoningNoTranslationsFinding.Builder getNoTranslations() {
            return noTranslations != null ? noTranslations.toBuilder() : null;
        }

        public final void setNoTranslations(GuardrailAutomatedReasoningNoTranslationsFinding.BuilderImpl noTranslations) {
            Object oldValue = this.noTranslations;
            this.noTranslations = noTranslations != null ? noTranslations.build() : null;
            handleUnionValueChange(Type.NO_TRANSLATIONS, oldValue, this.noTranslations);
        }

        @Override
        public final Builder noTranslations(GuardrailAutomatedReasoningNoTranslationsFinding noTranslations) {
            Object oldValue = this.noTranslations;
            this.noTranslations = noTranslations;
            handleUnionValueChange(Type.NO_TRANSLATIONS, oldValue, this.noTranslations);
            return this;
        }

        @Override
        public GuardrailAutomatedReasoningFinding build() {
            return new GuardrailAutomatedReasoningFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see GuardrailAutomatedReasoningFinding#type()
     */
    public enum Type {
        VALID,

        INVALID,

        SATISFIABLE,

        IMPOSSIBLE,

        TRANSLATION_AMBIGUOUS,

        TOO_COMPLEX,

        NO_TRANSLATIONS,

        UNKNOWN_TO_SDK_VERSION
    }
}
