/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a character-level location within a document, providing precise positioning information for cited content
 * using start and end character indices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentCharLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentCharLocation.Builder, DocumentCharLocation> {
    private static final SdkField<Integer> DOCUMENT_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("documentIndex").getter(getter(DocumentCharLocation::documentIndex))
            .setter(setter(Builder::documentIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentIndex").build()).build();

    private static final SdkField<Integer> START_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("start")
            .getter(getter(DocumentCharLocation::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<Integer> END_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("end")
            .getter(getter(DocumentCharLocation::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_INDEX_FIELD,
            START_FIELD, END_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer documentIndex;

    private final Integer start;

    private final Integer end;

    private DocumentCharLocation(BuilderImpl builder) {
        this.documentIndex = builder.documentIndex;
        this.start = builder.start;
        this.end = builder.end;
    }

    /**
     * <p>
     * The index of the document within the array of documents provided in the request.
     * </p>
     * 
     * @return The index of the document within the array of documents provided in the request.
     */
    public final Integer documentIndex() {
        return documentIndex;
    }

    /**
     * <p>
     * The starting character position of the cited content within the document.
     * </p>
     * 
     * @return The starting character position of the cited content within the document.
     */
    public final Integer start() {
        return start;
    }

    /**
     * <p>
     * The ending character position of the cited content within the document.
     * </p>
     * 
     * @return The ending character position of the cited content within the document.
     */
    public final Integer end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentIndex());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentCharLocation)) {
            return false;
        }
        DocumentCharLocation other = (DocumentCharLocation) obj;
        return Objects.equals(documentIndex(), other.documentIndex()) && Objects.equals(start(), other.start())
                && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentCharLocation").add("DocumentIndex", documentIndex()).add("Start", start())
                .add("End", end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "documentIndex":
            return Optional.ofNullable(clazz.cast(documentIndex()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("documentIndex", DOCUMENT_INDEX_FIELD);
        map.put("start", START_FIELD);
        map.put("end", END_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentCharLocation, T> g) {
        return obj -> g.apply((DocumentCharLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentCharLocation> {
        /**
         * <p>
         * The index of the document within the array of documents provided in the request.
         * </p>
         * 
         * @param documentIndex
         *        The index of the document within the array of documents provided in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentIndex(Integer documentIndex);

        /**
         * <p>
         * The starting character position of the cited content within the document.
         * </p>
         * 
         * @param start
         *        The starting character position of the cited content within the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Integer start);

        /**
         * <p>
         * The ending character position of the cited content within the document.
         * </p>
         * 
         * @param end
         *        The ending character position of the cited content within the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Integer end);
    }

    static final class BuilderImpl implements Builder {
        private Integer documentIndex;

        private Integer start;

        private Integer end;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentCharLocation model) {
            documentIndex(model.documentIndex);
            start(model.start);
            end(model.end);
        }

        public final Integer getDocumentIndex() {
            return documentIndex;
        }

        public final void setDocumentIndex(Integer documentIndex) {
            this.documentIndex = documentIndex;
        }

        @Override
        public final Builder documentIndex(Integer documentIndex) {
            this.documentIndex = documentIndex;
            return this;
        }

        public final Integer getStart() {
            return start;
        }

        public final void setStart(Integer start) {
            this.start = start;
        }

        @Override
        public final Builder start(Integer start) {
            this.start = start;
            return this;
        }

        public final Integer getEnd() {
            return end;
        }

        public final void setEnd(Integer end) {
            this.end = end;
        }

        @Override
        public final Builder end(Integer end) {
            this.end = end;
            return this;
        }

        @Override
        public DocumentCharLocation build() {
            return new DocumentCharLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
