/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CountTokensRequest extends BedrockRuntimeRequest implements
        ToCopyableBuilder<CountTokensRequest.Builder, CountTokensRequest> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(CountTokensRequest::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelId").build()).build();

    private static final SdkField<CountTokensInput> INPUT_FIELD = SdkField.<CountTokensInput> builder(MarshallingType.SDK_POJO)
            .memberName("input").getter(getter(CountTokensRequest::input)).setter(setter(Builder::input))
            .constructor(CountTokensInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelId;

    private final CountTokensInput input;

    private CountTokensRequest(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.input = builder.input;
    }

    /**
     * <p>
     * The unique identifier or ARN of the foundation model to use for token counting. Each model processes tokens
     * differently, so the token count is specific to the model you specify.
     * </p>
     * 
     * @return The unique identifier or ARN of the foundation model to use for token counting. Each model processes
     *         tokens differently, so the token count is specific to the model you specify.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * The input for which to count tokens. The structure of this parameter depends on whether you're counting tokens
     * for an <code>InvokeModel</code> or <code>Converse</code> request:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code> field
     * </p>
     * </li>
     * </ul>
     * <p>
     * The input format must be compatible with the model specified in the <code>modelId</code> parameter.
     * </p>
     * 
     * @return The input for which to count tokens. The structure of this parameter depends on whether you're counting
     *         tokens for an <code>InvokeModel</code> or <code>Converse</code> request:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code>
     *         field
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The input format must be compatible with the model specified in the <code>modelId</code> parameter.
     */
    public final CountTokensInput input() {
        return input;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountTokensRequest)) {
            return false;
        }
        CountTokensRequest other = (CountTokensRequest) obj;
        return Objects.equals(modelId(), other.modelId()) && Objects.equals(input(), other.input());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CountTokensRequest").add("ModelId", modelId()).add("Input", input()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "input":
            return Optional.ofNullable(clazz.cast(input()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelId", MODEL_ID_FIELD);
        map.put("input", INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CountTokensRequest, T> g) {
        return obj -> g.apply((CountTokensRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CountTokensRequest> {
        /**
         * <p>
         * The unique identifier or ARN of the foundation model to use for token counting. Each model processes tokens
         * differently, so the token count is specific to the model you specify.
         * </p>
         * 
         * @param modelId
         *        The unique identifier or ARN of the foundation model to use for token counting. Each model processes
         *        tokens differently, so the token count is specific to the model you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * The input for which to count tokens. The structure of this parameter depends on whether you're counting
         * tokens for an <code>InvokeModel</code> or <code>Converse</code> request:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code>
         * field
         * </p>
         * </li>
         * </ul>
         * <p>
         * The input format must be compatible with the model specified in the <code>modelId</code> parameter.
         * </p>
         * 
         * @param input
         *        The input for which to count tokens. The structure of this parameter depends on whether you're
         *        counting tokens for an <code>InvokeModel</code> or <code>Converse</code> request:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>Converse</code> requests, provide the messages and system content in the
         *        <code>converse</code> field
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The input format must be compatible with the model specified in the <code>modelId</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(CountTokensInput input);

        /**
         * <p>
         * The input for which to count tokens. The structure of this parameter depends on whether you're counting
         * tokens for an <code>InvokeModel</code> or <code>Converse</code> request:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>InvokeModel</code> requests, provide the request body in the <code>invokeModel</code> field
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>Converse</code> requests, provide the messages and system content in the <code>converse</code>
         * field
         * </p>
         * </li>
         * </ul>
         * <p>
         * The input format must be compatible with the model specified in the <code>modelId</code> parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link CountTokensInput.Builder} avoiding the
         * need to create one manually via {@link CountTokensInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CountTokensInput.Builder#build()} is called immediately and its
         * result is passed to {@link #input(CountTokensInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link CountTokensInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(CountTokensInput)
         */
        default Builder input(Consumer<CountTokensInput.Builder> input) {
            return input(CountTokensInput.builder().applyMutation(input).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRuntimeRequest.BuilderImpl implements Builder {
        private String modelId;

        private CountTokensInput input;

        private BuilderImpl() {
        }

        private BuilderImpl(CountTokensRequest model) {
            super(model);
            modelId(model.modelId);
            input(model.input);
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final CountTokensInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(CountTokensInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(CountTokensInput input) {
            this.input = input;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CountTokensRequest build() {
            return new CountTokensRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
