/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAsyncInvokesResponse extends BedrockRuntimeResponse implements
        ToCopyableBuilder<ListAsyncInvokesResponse.Builder, ListAsyncInvokesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAsyncInvokesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<AsyncInvokeSummary>> ASYNC_INVOKE_SUMMARIES_FIELD = SdkField
            .<List<AsyncInvokeSummary>> builder(MarshallingType.LIST)
            .memberName("asyncInvokeSummaries")
            .getter(getter(ListAsyncInvokesResponse::asyncInvokeSummaries))
            .setter(setter(Builder::asyncInvokeSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asyncInvokeSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AsyncInvokeSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AsyncInvokeSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ASYNC_INVOKE_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<AsyncInvokeSummary> asyncInvokeSummaries;

    private ListAsyncInvokesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.asyncInvokeSummaries = builder.asyncInvokeSummaries;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AsyncInvokeSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAsyncInvokeSummaries() {
        return asyncInvokeSummaries != null && !(asyncInvokeSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of invocation summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAsyncInvokeSummaries} method.
     * </p>
     * 
     * @return A list of invocation summaries.
     */
    public final List<AsyncInvokeSummary> asyncInvokeSummaries() {
        return asyncInvokeSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAsyncInvokeSummaries() ? asyncInvokeSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAsyncInvokesResponse)) {
            return false;
        }
        ListAsyncInvokesResponse other = (ListAsyncInvokesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasAsyncInvokeSummaries() == other.hasAsyncInvokeSummaries()
                && Objects.equals(asyncInvokeSummaries(), other.asyncInvokeSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAsyncInvokesResponse").add("NextToken", nextToken())
                .add("AsyncInvokeSummaries", hasAsyncInvokeSummaries() ? asyncInvokeSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "asyncInvokeSummaries":
            return Optional.ofNullable(clazz.cast(asyncInvokeSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("asyncInvokeSummaries", ASYNC_INVOKE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAsyncInvokesResponse, T> g) {
        return obj -> g.apply((ListAsyncInvokesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRuntimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAsyncInvokesResponse> {
        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of invocation summaries.
         * </p>
         * 
         * @param asyncInvokeSummaries
         *        A list of invocation summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asyncInvokeSummaries(Collection<AsyncInvokeSummary> asyncInvokeSummaries);

        /**
         * <p>
         * A list of invocation summaries.
         * </p>
         * 
         * @param asyncInvokeSummaries
         *        A list of invocation summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asyncInvokeSummaries(AsyncInvokeSummary... asyncInvokeSummaries);

        /**
         * <p>
         * A list of invocation summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.AsyncInvokeSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.AsyncInvokeSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.AsyncInvokeSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #asyncInvokeSummaries(List<AsyncInvokeSummary>)}.
         * 
         * @param asyncInvokeSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.AsyncInvokeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #asyncInvokeSummaries(java.util.Collection<AsyncInvokeSummary>)
         */
        Builder asyncInvokeSummaries(Consumer<AsyncInvokeSummary.Builder>... asyncInvokeSummaries);
    }

    static final class BuilderImpl extends BedrockRuntimeResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<AsyncInvokeSummary> asyncInvokeSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAsyncInvokesResponse model) {
            super(model);
            nextToken(model.nextToken);
            asyncInvokeSummaries(model.asyncInvokeSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AsyncInvokeSummary.Builder> getAsyncInvokeSummaries() {
            List<AsyncInvokeSummary.Builder> result = AsyncInvokeSummariesCopier.copyToBuilder(this.asyncInvokeSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAsyncInvokeSummaries(Collection<AsyncInvokeSummary.BuilderImpl> asyncInvokeSummaries) {
            this.asyncInvokeSummaries = AsyncInvokeSummariesCopier.copyFromBuilder(asyncInvokeSummaries);
        }

        @Override
        public final Builder asyncInvokeSummaries(Collection<AsyncInvokeSummary> asyncInvokeSummaries) {
            this.asyncInvokeSummaries = AsyncInvokeSummariesCopier.copy(asyncInvokeSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asyncInvokeSummaries(AsyncInvokeSummary... asyncInvokeSummaries) {
            asyncInvokeSummaries(Arrays.asList(asyncInvokeSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asyncInvokeSummaries(Consumer<AsyncInvokeSummary.Builder>... asyncInvokeSummaries) {
            asyncInvokeSummaries(Stream.of(asyncInvokeSummaries).map(c -> AsyncInvokeSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAsyncInvokesResponse build() {
            return new ListAsyncInvokesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
