/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailConverseImageBlock;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailConverseTextBlock;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailConverseContentBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailConverseContentBlock> {
    private static final SdkField<GuardrailConverseTextBlock> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("text").getter(GuardrailConverseContentBlock.getter(GuardrailConverseContentBlock::text)).setter(GuardrailConverseContentBlock.setter(Builder::text)).constructor(GuardrailConverseTextBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<GuardrailConverseImageBlock> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("image").getter(GuardrailConverseContentBlock.getter(GuardrailConverseContentBlock::image)).setter(GuardrailConverseContentBlock.setter(Builder::image)).constructor(GuardrailConverseImageBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, IMAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailConverseContentBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final GuardrailConverseTextBlock text;
    private final GuardrailConverseImageBlock image;
    private final Type type;

    private GuardrailConverseContentBlock(BuilderImpl builder) {
        this.text = builder.text;
        this.image = builder.image;
        this.type = builder.type;
    }

    public final GuardrailConverseTextBlock text() {
        return this.text;
    }

    public final GuardrailConverseImageBlock image() {
        return this.image;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailConverseContentBlock)) {
            return false;
        }
        GuardrailConverseContentBlock other = (GuardrailConverseContentBlock)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.image(), other.image());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailConverseContentBlock").add("Text", (Object)this.text()).add("Image", (Object)(this.image() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
        }
        return Optional.empty();
    }

    public static GuardrailConverseContentBlock fromText(GuardrailConverseTextBlock text) {
        return (GuardrailConverseContentBlock)GuardrailConverseContentBlock.builder().text(text).build();
    }

    public static GuardrailConverseContentBlock fromText(Consumer<GuardrailConverseTextBlock.Builder> text) {
        GuardrailConverseTextBlock.Builder builder = GuardrailConverseTextBlock.builder();
        text.accept(builder);
        return GuardrailConverseContentBlock.fromText((GuardrailConverseTextBlock)builder.build());
    }

    public static GuardrailConverseContentBlock fromImage(GuardrailConverseImageBlock image) {
        return (GuardrailConverseContentBlock)GuardrailConverseContentBlock.builder().image(image).build();
    }

    public static GuardrailConverseContentBlock fromImage(Consumer<GuardrailConverseImageBlock.Builder> image) {
        GuardrailConverseImageBlock.Builder builder = GuardrailConverseImageBlock.builder();
        image.accept(builder);
        return GuardrailConverseContentBlock.fromImage((GuardrailConverseImageBlock)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", TEXT_FIELD);
        map.put("image", IMAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailConverseContentBlock, T> g) {
        return obj -> g.apply((GuardrailConverseContentBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT,
        IMAGE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private GuardrailConverseTextBlock text;
        private GuardrailConverseImageBlock image;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailConverseContentBlock model) {
            this.text(model.text);
            this.image(model.image);
        }

        public final GuardrailConverseTextBlock.Builder getText() {
            return this.text != null ? this.text.toBuilder() : null;
        }

        public final void setText(GuardrailConverseTextBlock.BuilderImpl text) {
            GuardrailConverseTextBlock oldValue = this.text;
            this.text = text != null ? text.build() : null;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(GuardrailConverseTextBlock text) {
            GuardrailConverseTextBlock oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final GuardrailConverseImageBlock.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(GuardrailConverseImageBlock.BuilderImpl image) {
            GuardrailConverseImageBlock oldValue = this.image;
            this.image = image != null ? image.build() : null;
            this.handleUnionValueChange(Type.IMAGE, oldValue, this.image);
        }

        @Override
        public final Builder image(GuardrailConverseImageBlock image) {
            GuardrailConverseImageBlock oldValue = this.image;
            this.image = image;
            this.handleUnionValueChange(Type.IMAGE, oldValue, this.image);
            return this;
        }

        public GuardrailConverseContentBlock build() {
            return new GuardrailConverseContentBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailConverseContentBlock> {
        public Builder text(GuardrailConverseTextBlock var1);

        default public Builder text(Consumer<GuardrailConverseTextBlock.Builder> text) {
            return this.text((GuardrailConverseTextBlock)((GuardrailConverseTextBlock.Builder)GuardrailConverseTextBlock.builder().applyMutation(text)).build());
        }

        public Builder image(GuardrailConverseImageBlock var1);

        default public Builder image(Consumer<GuardrailConverseImageBlock.Builder> image) {
            return this.image((GuardrailConverseImageBlock)((GuardrailConverseImageBlock.Builder)GuardrailConverseImageBlock.builder().applyMutation(image)).build());
        }
    }
}

