/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tool result content block.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ToolResultContentBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<ToolResultContentBlock.Builder, ToolResultContentBlock> {
    private static final SdkField<Document> JSON_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT).memberName("json")
            .getter(getter(ToolResultContentBlock::json)).setter(setter(Builder::json))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("json").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(ToolResultContentBlock::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<ImageBlock> IMAGE_FIELD = SdkField.<ImageBlock> builder(MarshallingType.SDK_POJO)
            .memberName("image").getter(getter(ToolResultContentBlock::image)).setter(setter(Builder::image))
            .constructor(ImageBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<DocumentBlock> DOCUMENT_FIELD = SdkField.<DocumentBlock> builder(MarshallingType.SDK_POJO)
            .memberName("document").getter(getter(ToolResultContentBlock::document)).setter(setter(Builder::document))
            .constructor(DocumentBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<VideoBlock> VIDEO_FIELD = SdkField.<VideoBlock> builder(MarshallingType.SDK_POJO)
            .memberName("video").getter(getter(ToolResultContentBlock::video)).setter(setter(Builder::video))
            .constructor(VideoBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_FIELD, TEXT_FIELD,
            IMAGE_FIELD, DOCUMENT_FIELD, VIDEO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Document json;

    private final String text;

    private final ImageBlock image;

    private final DocumentBlock document;

    private final VideoBlock video;

    private final Type type;

    private ToolResultContentBlock(BuilderImpl builder) {
        this.json = builder.json;
        this.text = builder.text;
        this.image = builder.image;
        this.document = builder.document;
        this.video = builder.video;
        this.type = builder.type;
    }

    /**
     * <p>
     * A tool result that is JSON format data.
     * </p>
     * 
     * @return A tool result that is JSON format data.
     */
    public final Document json() {
        return json;
    }

    /**
     * <p>
     * A tool result that is text.
     * </p>
     * 
     * @return A tool result that is text.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * A tool result that is an image.
     * </p>
     * <note>
     * <p>
     * This field is only supported by Anthropic Claude 3 models.
     * </p>
     * </note>
     * 
     * @return A tool result that is an image.</p> <note>
     *         <p>
     *         This field is only supported by Anthropic Claude 3 models.
     *         </p>
     */
    public final ImageBlock image() {
        return image;
    }

    /**
     * <p>
     * A tool result that is a document.
     * </p>
     * 
     * @return A tool result that is a document.
     */
    public final DocumentBlock document() {
        return document;
    }

    /**
     * <p>
     * A tool result that is video.
     * </p>
     * 
     * @return A tool result that is video.
     */
    public final VideoBlock video() {
        return video;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(json());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolResultContentBlock)) {
            return false;
        }
        ToolResultContentBlock other = (ToolResultContentBlock) obj;
        return Objects.equals(json(), other.json()) && Objects.equals(text(), other.text())
                && Objects.equals(image(), other.image()) && Objects.equals(document(), other.document())
                && Objects.equals(video(), other.video());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ToolResultContentBlock").add("Json", json()).add("Text", text()).add("Image", image())
                .add("Document", document()).add("Video", video()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "json":
            return Optional.ofNullable(clazz.cast(json()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "video":
            return Optional.ofNullable(clazz.cast(video()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #json()} initialized to the given value.
     *
     * <p>
     * A tool result that is JSON format data.
     * </p>
     * 
     * @param json
     *        A tool result that is JSON format data.
     */
    public static ToolResultContentBlock fromJson(Document json) {
        return builder().json(json).build();
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * A tool result that is text.
     * </p>
     * 
     * @param text
     *        A tool result that is text.
     */
    public static ToolResultContentBlock fromText(String text) {
        return builder().text(text).build();
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * A tool result that is an image.
     * </p>
     * <note>
     * <p>
     * This field is only supported by Anthropic Claude 3 models.
     * </p>
     * </note>
     * 
     * @param image
     *        A tool result that is an image.</p> <note>
     *        <p>
     *        This field is only supported by Anthropic Claude 3 models.
     *        </p>
     */
    public static ToolResultContentBlock fromImage(ImageBlock image) {
        return builder().image(image).build();
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * A tool result that is an image.
     * </p>
     * <note>
     * <p>
     * This field is only supported by Anthropic Claude 3 models.
     * </p>
     * </note>
     * 
     * @param image
     *        A tool result that is an image.</p> <note>
     *        <p>
     *        This field is only supported by Anthropic Claude 3 models.
     *        </p>
     */
    public static ToolResultContentBlock fromImage(Consumer<ImageBlock.Builder> image) {
        ImageBlock.Builder builder = ImageBlock.builder();
        image.accept(builder);
        return fromImage(builder.build());
    }

    /**
     * Create an instance of this class with {@link #document()} initialized to the given value.
     *
     * <p>
     * A tool result that is a document.
     * </p>
     * 
     * @param document
     *        A tool result that is a document.
     */
    public static ToolResultContentBlock fromDocument(DocumentBlock document) {
        return builder().document(document).build();
    }

    /**
     * Create an instance of this class with {@link #document()} initialized to the given value.
     *
     * <p>
     * A tool result that is a document.
     * </p>
     * 
     * @param document
     *        A tool result that is a document.
     */
    public static ToolResultContentBlock fromDocument(Consumer<DocumentBlock.Builder> document) {
        DocumentBlock.Builder builder = DocumentBlock.builder();
        document.accept(builder);
        return fromDocument(builder.build());
    }

    /**
     * Create an instance of this class with {@link #video()} initialized to the given value.
     *
     * <p>
     * A tool result that is video.
     * </p>
     * 
     * @param video
     *        A tool result that is video.
     */
    public static ToolResultContentBlock fromVideo(VideoBlock video) {
        return builder().video(video).build();
    }

    /**
     * Create an instance of this class with {@link #video()} initialized to the given value.
     *
     * <p>
     * A tool result that is video.
     * </p>
     * 
     * @param video
     *        A tool result that is video.
     */
    public static ToolResultContentBlock fromVideo(Consumer<VideoBlock.Builder> video) {
        VideoBlock.Builder builder = VideoBlock.builder();
        video.accept(builder);
        return fromVideo(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("json", JSON_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("image", IMAGE_FIELD);
        map.put("document", DOCUMENT_FIELD);
        map.put("video", VIDEO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolResultContentBlock, T> g) {
        return obj -> g.apply((ToolResultContentBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ToolResultContentBlock> {
        /**
         * <p>
         * A tool result that is JSON format data.
         * </p>
         * 
         * @param json
         *        A tool result that is JSON format data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder json(Document json);

        /**
         * <p>
         * A tool result that is text.
         * </p>
         * 
         * @param text
         *        A tool result that is text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * A tool result that is an image.
         * </p>
         * <note>
         * <p>
         * This field is only supported by Anthropic Claude 3 models.
         * </p>
         * </note>
         * 
         * @param image
         *        A tool result that is an image.</p> <note>
         *        <p>
         *        This field is only supported by Anthropic Claude 3 models.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(ImageBlock image);

        /**
         * <p>
         * A tool result that is an image.
         * </p>
         * <note>
         * <p>
         * This field is only supported by Anthropic Claude 3 models.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link ImageBlock.Builder} avoiding the
         * need to create one manually via {@link ImageBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageBlock.Builder#build()} is called immediately and its result
         * is passed to {@link #image(ImageBlock)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link ImageBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(ImageBlock)
         */
        default Builder image(Consumer<ImageBlock.Builder> image) {
            return image(ImageBlock.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * A tool result that is a document.
         * </p>
         * 
         * @param document
         *        A tool result that is a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(DocumentBlock document);

        /**
         * <p>
         * A tool result that is a document.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentBlock.Builder} avoiding the need
         * to create one manually via {@link DocumentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #document(DocumentBlock)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link DocumentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(DocumentBlock)
         */
        default Builder document(Consumer<DocumentBlock.Builder> document) {
            return document(DocumentBlock.builder().applyMutation(document).build());
        }

        /**
         * <p>
         * A tool result that is video.
         * </p>
         * 
         * @param video
         *        A tool result that is video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoBlock video);

        /**
         * <p>
         * A tool result that is video.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoBlock.Builder} avoiding the need to
         * create one manually via {@link VideoBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoBlock.Builder#build()} is called immediately and its result
         * is passed to {@link #video(VideoBlock)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link VideoBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(VideoBlock)
         */
        default Builder video(Consumer<VideoBlock.Builder> video) {
            return video(VideoBlock.builder().applyMutation(video).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Document json;

        private String text;

        private ImageBlock image;

        private DocumentBlock document;

        private VideoBlock video;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ToolResultContentBlock model) {
            json(model.json);
            text(model.text);
            image(model.image);
            document(model.document);
            video(model.video);
        }

        public final Document getJson() {
            return json;
        }

        public final void setJson(Document json) {
            Object oldValue = this.json;
            this.json = json;
            handleUnionValueChange(Type.JSON, oldValue, this.json);
        }

        @Override
        public final Builder json(Document json) {
            Object oldValue = this.json;
            this.json = json;
            handleUnionValueChange(Type.JSON, oldValue, this.json);
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final ImageBlock.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(ImageBlock.BuilderImpl image) {
            Object oldValue = this.image;
            this.image = image != null ? image.build() : null;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
        }

        @Override
        public final Builder image(ImageBlock image) {
            Object oldValue = this.image;
            this.image = image;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
            return this;
        }

        public final DocumentBlock.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        public final void setDocument(DocumentBlock.BuilderImpl document) {
            Object oldValue = this.document;
            this.document = document != null ? document.build() : null;
            handleUnionValueChange(Type.DOCUMENT, oldValue, this.document);
        }

        @Override
        public final Builder document(DocumentBlock document) {
            Object oldValue = this.document;
            this.document = document;
            handleUnionValueChange(Type.DOCUMENT, oldValue, this.document);
            return this;
        }

        public final VideoBlock.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        public final void setVideo(VideoBlock.BuilderImpl video) {
            Object oldValue = this.video;
            this.video = video != null ? video.build() : null;
            handleUnionValueChange(Type.VIDEO, oldValue, this.video);
        }

        @Override
        public final Builder video(VideoBlock video) {
            Object oldValue = this.video;
            this.video = video;
            handleUnionValueChange(Type.VIDEO, oldValue, this.video);
            return this;
        }

        @Override
        public ToolResultContentBlock build() {
            return new ToolResultContentBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ToolResultContentBlock#type()
     */
    public enum Type {
        JSON,

        TEXT,

        IMAGE,

        DOCUMENT,

        VIDEO,

        UNKNOWN_TO_SDK_VERSION
    }
}
