/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Regex filter configured in a guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailRegexFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailRegexFilter.Builder, GuardrailRegexFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GuardrailRegexFilter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> MATCH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("match")
            .getter(getter(GuardrailRegexFilter::match)).setter(setter(Builder::match))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("regex")
            .getter(getter(GuardrailRegexFilter::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GuardrailRegexFilter::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<Boolean> DETECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("detected").getter(getter(GuardrailRegexFilter::detected)).setter(setter(Builder::detected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detected").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, MATCH_FIELD,
            REGEX_FIELD, ACTION_FIELD, DETECTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String match;

    private final String regex;

    private final String action;

    private final Boolean detected;

    private GuardrailRegexFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.match = builder.match;
        this.regex = builder.regex;
        this.action = builder.action;
        this.detected = builder.detected;
    }

    /**
     * <p>
     * The regex filter name.
     * </p>
     * 
     * @return The regex filter name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The regesx filter match.
     * </p>
     * 
     * @return The regesx filter match.
     */
    public final String match() {
        return match;
    }

    /**
     * <p>
     * The regex query.
     * </p>
     * 
     * @return The regex query.
     */
    public final String regex() {
        return regex;
    }

    /**
     * <p>
     * The region filter action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationPolicyAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The region filter action.
     * @see GuardrailSensitiveInformationPolicyAction
     */
    public final GuardrailSensitiveInformationPolicyAction action() {
        return GuardrailSensitiveInformationPolicyAction.fromValue(action);
    }

    /**
     * <p>
     * The region filter action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationPolicyAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #actionAsString}.
     * </p>
     * 
     * @return The region filter action.
     * @see GuardrailSensitiveInformationPolicyAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Indicates whether custom regex entities that breach the guardrail configuration are detected.
     * </p>
     * 
     * @return Indicates whether custom regex entities that breach the guardrail configuration are detected.
     */
    public final Boolean detected() {
        return detected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(detected());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailRegexFilter)) {
            return false;
        }
        GuardrailRegexFilter other = (GuardrailRegexFilter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(match(), other.match())
                && Objects.equals(regex(), other.regex()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(detected(), other.detected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailRegexFilter").add("Name", name()).add("Match", match()).add("Regex", regex())
                .add("Action", actionAsString()).add("Detected", detected()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "regex":
            return Optional.ofNullable(clazz.cast(regex()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "detected":
            return Optional.ofNullable(clazz.cast(detected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("match", MATCH_FIELD);
        map.put("regex", REGEX_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("detected", DETECTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailRegexFilter, T> g) {
        return obj -> g.apply((GuardrailRegexFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailRegexFilter> {
        /**
         * <p>
         * The regex filter name.
         * </p>
         * 
         * @param name
         *        The regex filter name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The regesx filter match.
         * </p>
         * 
         * @param match
         *        The regesx filter match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(String match);

        /**
         * <p>
         * The regex query.
         * </p>
         * 
         * @param regex
         *        The regex query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);

        /**
         * <p>
         * The region filter action.
         * </p>
         * 
         * @param action
         *        The region filter action.
         * @see GuardrailSensitiveInformationPolicyAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationPolicyAction
         */
        Builder action(String action);

        /**
         * <p>
         * The region filter action.
         * </p>
         * 
         * @param action
         *        The region filter action.
         * @see GuardrailSensitiveInformationPolicyAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationPolicyAction
         */
        Builder action(GuardrailSensitiveInformationPolicyAction action);

        /**
         * <p>
         * Indicates whether custom regex entities that breach the guardrail configuration are detected.
         * </p>
         * 
         * @param detected
         *        Indicates whether custom regex entities that breach the guardrail configuration are detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detected(Boolean detected);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String match;

        private String regex;

        private String action;

        private Boolean detected;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailRegexFilter model) {
            name(model.name);
            match(model.match);
            regex(model.regex);
            action(model.action);
            detected(model.detected);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMatch() {
            return match;
        }

        public final void setMatch(String match) {
            this.match = match;
        }

        @Override
        public final Builder match(String match) {
            this.match = match;
            return this;
        }

        public final String getRegex() {
            return regex;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailSensitiveInformationPolicyAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Boolean getDetected() {
            return detected;
        }

        public final void setDetected(Boolean detected) {
            this.detected = detected;
        }

        @Override
        public final Builder detected(Boolean detected) {
            this.detected = detected;
            return this;
        }

        @Override
        public GuardrailRegexFilter build() {
            return new GuardrailRegexFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
