/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAssessment;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAssessmentListMapCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailAssessmentMapCopier;
import software.amazon.awssdk.services.bedrockruntime.model.ModelOutputsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailTraceAssessment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailTraceAssessment> {
    private static final SdkField<List<String>> MODEL_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelOutput").getter(GuardrailTraceAssessment.getter(GuardrailTraceAssessment::modelOutput)).setter(GuardrailTraceAssessment.setter(Builder::modelOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelOutput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, GuardrailAssessment>> INPUT_ASSESSMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("inputAssessment").getter(GuardrailTraceAssessment.getter(GuardrailTraceAssessment::inputAssessment)).setter(GuardrailTraceAssessment.setter(Builder::inputAssessment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAssessment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<GuardrailAssessment>>> OUTPUT_ASSESSMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("outputAssessments").getter(GuardrailTraceAssessment.getter(GuardrailTraceAssessment::outputAssessments)).setter(GuardrailTraceAssessment.setter(Builder::outputAssessments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputAssessments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> ACTION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionReason").getter(GuardrailTraceAssessment.getter(GuardrailTraceAssessment::actionReason)).setter(GuardrailTraceAssessment.setter(Builder::actionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_OUTPUT_FIELD, INPUT_ASSESSMENT_FIELD, OUTPUT_ASSESSMENTS_FIELD, ACTION_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailTraceAssessment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> modelOutput;
    private final Map<String, GuardrailAssessment> inputAssessment;
    private final Map<String, List<GuardrailAssessment>> outputAssessments;
    private final String actionReason;

    private GuardrailTraceAssessment(BuilderImpl builder) {
        this.modelOutput = builder.modelOutput;
        this.inputAssessment = builder.inputAssessment;
        this.outputAssessments = builder.outputAssessments;
        this.actionReason = builder.actionReason;
    }

    public final boolean hasModelOutput() {
        return this.modelOutput != null && !(this.modelOutput instanceof SdkAutoConstructList);
    }

    public final List<String> modelOutput() {
        return this.modelOutput;
    }

    public final boolean hasInputAssessment() {
        return this.inputAssessment != null && !(this.inputAssessment instanceof SdkAutoConstructMap);
    }

    public final Map<String, GuardrailAssessment> inputAssessment() {
        return this.inputAssessment;
    }

    public final boolean hasOutputAssessments() {
        return this.outputAssessments != null && !(this.outputAssessments instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<GuardrailAssessment>> outputAssessments() {
        return this.outputAssessments;
    }

    public final String actionReason() {
        return this.actionReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelOutput() ? this.modelOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputAssessment() ? this.inputAssessment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputAssessments() ? this.outputAssessments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.actionReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTraceAssessment)) {
            return false;
        }
        GuardrailTraceAssessment other = (GuardrailTraceAssessment)obj;
        return this.hasModelOutput() == other.hasModelOutput() && Objects.equals(this.modelOutput(), other.modelOutput()) && this.hasInputAssessment() == other.hasInputAssessment() && Objects.equals(this.inputAssessment(), other.inputAssessment()) && this.hasOutputAssessments() == other.hasOutputAssessments() && Objects.equals(this.outputAssessments(), other.outputAssessments()) && Objects.equals(this.actionReason(), other.actionReason());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailTraceAssessment").add("ModelOutput", this.hasModelOutput() ? this.modelOutput() : null).add("InputAssessment", this.hasInputAssessment() ? this.inputAssessment() : null).add("OutputAssessments", this.hasOutputAssessments() ? this.outputAssessments() : null).add("ActionReason", (Object)this.actionReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelOutput": {
                return Optional.ofNullable(clazz.cast(this.modelOutput()));
            }
            case "inputAssessment": {
                return Optional.ofNullable(clazz.cast(this.inputAssessment()));
            }
            case "outputAssessments": {
                return Optional.ofNullable(clazz.cast(this.outputAssessments()));
            }
            case "actionReason": {
                return Optional.ofNullable(clazz.cast(this.actionReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelOutput", MODEL_OUTPUT_FIELD);
        map.put("inputAssessment", INPUT_ASSESSMENT_FIELD);
        map.put("outputAssessments", OUTPUT_ASSESSMENTS_FIELD);
        map.put("actionReason", ACTION_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTraceAssessment, T> g) {
        return obj -> g.apply((GuardrailTraceAssessment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> modelOutput = DefaultSdkAutoConstructList.getInstance();
        private Map<String, GuardrailAssessment> inputAssessment = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<GuardrailAssessment>> outputAssessments = DefaultSdkAutoConstructMap.getInstance();
        private String actionReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTraceAssessment model) {
            this.modelOutput(model.modelOutput);
            this.inputAssessment(model.inputAssessment);
            this.outputAssessments(model.outputAssessments);
            this.actionReason(model.actionReason);
        }

        public final Collection<String> getModelOutput() {
            if (this.modelOutput instanceof SdkAutoConstructList) {
                return null;
            }
            return this.modelOutput;
        }

        public final void setModelOutput(Collection<String> modelOutput) {
            this.modelOutput = ModelOutputsCopier.copy(modelOutput);
        }

        @Override
        public final Builder modelOutput(Collection<String> modelOutput) {
            this.modelOutput = ModelOutputsCopier.copy(modelOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelOutput(String ... modelOutput) {
            this.modelOutput(Arrays.asList(modelOutput));
            return this;
        }

        public final Map<String, GuardrailAssessment.Builder> getInputAssessment() {
            Map<String, GuardrailAssessment.Builder> result = GuardrailAssessmentMapCopier.copyToBuilder(this.inputAssessment);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInputAssessment(Map<String, GuardrailAssessment.BuilderImpl> inputAssessment) {
            this.inputAssessment = GuardrailAssessmentMapCopier.copyFromBuilder(inputAssessment);
        }

        @Override
        public final Builder inputAssessment(Map<String, GuardrailAssessment> inputAssessment) {
            this.inputAssessment = GuardrailAssessmentMapCopier.copy(inputAssessment);
            return this;
        }

        public final Map<String, List<GuardrailAssessment.Builder>> getOutputAssessments() {
            Map<String, List<GuardrailAssessment.Builder>> result = GuardrailAssessmentListMapCopier.copyToBuilder(this.outputAssessments);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOutputAssessments(Map<String, ? extends Collection<GuardrailAssessment.BuilderImpl>> outputAssessments) {
            this.outputAssessments = GuardrailAssessmentListMapCopier.copyFromBuilder(outputAssessments);
        }

        @Override
        public final Builder outputAssessments(Map<String, ? extends Collection<GuardrailAssessment>> outputAssessments) {
            this.outputAssessments = GuardrailAssessmentListMapCopier.copy(outputAssessments);
            return this;
        }

        public final String getActionReason() {
            return this.actionReason;
        }

        public final void setActionReason(String actionReason) {
            this.actionReason = actionReason;
        }

        @Override
        public final Builder actionReason(String actionReason) {
            this.actionReason = actionReason;
            return this;
        }

        public GuardrailTraceAssessment build() {
            return new GuardrailTraceAssessment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailTraceAssessment> {
        public Builder modelOutput(Collection<String> var1);

        public Builder modelOutput(String ... var1);

        public Builder inputAssessment(Map<String, GuardrailAssessment> var1);

        public Builder outputAssessments(Map<String, ? extends Collection<GuardrailAssessment>> var1);

        public Builder actionReason(String var1);
    }
}

