/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A block of content for a message that you pass to, or receive from, a model with the <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> or <a
 * href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a> API
 * operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentBlock implements SdkPojo, Serializable, ToCopyableBuilder<ContentBlock.Builder, ContentBlock> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(ContentBlock::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<ImageBlock> IMAGE_FIELD = SdkField.<ImageBlock> builder(MarshallingType.SDK_POJO)
            .memberName("image").getter(getter(ContentBlock::image)).setter(setter(Builder::image))
            .constructor(ImageBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<DocumentBlock> DOCUMENT_FIELD = SdkField.<DocumentBlock> builder(MarshallingType.SDK_POJO)
            .memberName("document").getter(getter(ContentBlock::document)).setter(setter(Builder::document))
            .constructor(DocumentBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<VideoBlock> VIDEO_FIELD = SdkField.<VideoBlock> builder(MarshallingType.SDK_POJO)
            .memberName("video").getter(getter(ContentBlock::video)).setter(setter(Builder::video))
            .constructor(VideoBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build()).build();

    private static final SdkField<ToolUseBlock> TOOL_USE_FIELD = SdkField.<ToolUseBlock> builder(MarshallingType.SDK_POJO)
            .memberName("toolUse").getter(getter(ContentBlock::toolUse)).setter(setter(Builder::toolUse))
            .constructor(ToolUseBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUse").build()).build();

    private static final SdkField<ToolResultBlock> TOOL_RESULT_FIELD = SdkField
            .<ToolResultBlock> builder(MarshallingType.SDK_POJO).memberName("toolResult")
            .getter(getter(ContentBlock::toolResult)).setter(setter(Builder::toolResult)).constructor(ToolResultBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolResult").build()).build();

    private static final SdkField<GuardrailConverseContentBlock> GUARD_CONTENT_FIELD = SdkField
            .<GuardrailConverseContentBlock> builder(MarshallingType.SDK_POJO).memberName("guardContent")
            .getter(getter(ContentBlock::guardContent)).setter(setter(Builder::guardContent))
            .constructor(GuardrailConverseContentBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()).build();

    private static final SdkField<ReasoningContentBlock> REASONING_CONTENT_FIELD = SdkField
            .<ReasoningContentBlock> builder(MarshallingType.SDK_POJO).memberName("reasoningContent")
            .getter(getter(ContentBlock::reasoningContent)).setter(setter(Builder::reasoningContent))
            .constructor(ReasoningContentBlock::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasoningContent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, IMAGE_FIELD,
            DOCUMENT_FIELD, VIDEO_FIELD, TOOL_USE_FIELD, TOOL_RESULT_FIELD, GUARD_CONTENT_FIELD, REASONING_CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String text;

    private final ImageBlock image;

    private final DocumentBlock document;

    private final VideoBlock video;

    private final ToolUseBlock toolUse;

    private final ToolResultBlock toolResult;

    private final GuardrailConverseContentBlock guardContent;

    private final ReasoningContentBlock reasoningContent;

    private final Type type;

    private ContentBlock(BuilderImpl builder) {
        this.text = builder.text;
        this.image = builder.image;
        this.document = builder.document;
        this.video = builder.video;
        this.toolUse = builder.toolUse;
        this.toolResult = builder.toolResult;
        this.guardContent = builder.guardContent;
        this.reasoningContent = builder.reasoningContent;
        this.type = builder.type;
    }

    /**
     * <p>
     * Text to include in the message.
     * </p>
     * 
     * @return Text to include in the message.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * Image to include in the message.
     * </p>
     * <note>
     * <p>
     * This field is only supported by Anthropic Claude 3 models.
     * </p>
     * </note>
     * 
     * @return Image to include in the message. </p> <note>
     *         <p>
     *         This field is only supported by Anthropic Claude 3 models.
     *         </p>
     */
    public final ImageBlock image() {
        return image;
    }

    /**
     * <p>
     * A document to include in the message.
     * </p>
     * 
     * @return A document to include in the message.
     */
    public final DocumentBlock document() {
        return document;
    }

    /**
     * <p>
     * Video to include in the message.
     * </p>
     * 
     * @return Video to include in the message.
     */
    public final VideoBlock video() {
        return video;
    }

    /**
     * <p>
     * Information about a tool use request from a model.
     * </p>
     * 
     * @return Information about a tool use request from a model.
     */
    public final ToolUseBlock toolUse() {
        return toolUse;
    }

    /**
     * <p>
     * The result for a tool request that a model makes.
     * </p>
     * 
     * @return The result for a tool request that a model makes.
     */
    public final ToolResultBlock toolResult() {
        return toolResult;
    }

    /**
     * <p>
     * Contains the content to assess with the guardrail. If you don't specify <code>guardContent</code> in a call to
     * the Converse API, the guardrail (if passed in the Converse API) assesses the entire message.
     * </p>
     * <p>
     * For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * 
     * @return Contains the content to assess with the guardrail. If you don't specify <code>guardContent</code> in a
     *         call to the Converse API, the guardrail (if passed in the Converse API) assesses the entire message.
     *         </p>
     *         <p>
     *         For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
     *         Guide</i>.
     * 
     * <pre><code> &lt;/p&gt; </code>
     */
    public final GuardrailConverseContentBlock guardContent() {
        return guardContent;
    }

    /**
     * <p>
     * Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of Thought
     * (CoT) that the model generates to enhance the accuracy of its final response.
     * </p>
     * 
     * @return Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of
     *         Thought (CoT) that the model generates to enhance the accuracy of its final response.
     */
    public final ReasoningContentBlock reasoningContent() {
        return reasoningContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(video());
        hashCode = 31 * hashCode + Objects.hashCode(toolUse());
        hashCode = 31 * hashCode + Objects.hashCode(toolResult());
        hashCode = 31 * hashCode + Objects.hashCode(guardContent());
        hashCode = 31 * hashCode + Objects.hashCode(reasoningContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlock)) {
            return false;
        }
        ContentBlock other = (ContentBlock) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(image(), other.image())
                && Objects.equals(document(), other.document()) && Objects.equals(video(), other.video())
                && Objects.equals(toolUse(), other.toolUse()) && Objects.equals(toolResult(), other.toolResult())
                && Objects.equals(guardContent(), other.guardContent())
                && Objects.equals(reasoningContent(), other.reasoningContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentBlock").add("Text", text()).add("Image", image()).add("Document", document())
                .add("Video", video()).add("ToolUse", toolUse()).add("ToolResult", toolResult())
                .add("GuardContent", guardContent())
                .add("ReasoningContent", reasoningContent() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "video":
            return Optional.ofNullable(clazz.cast(video()));
        case "toolUse":
            return Optional.ofNullable(clazz.cast(toolUse()));
        case "toolResult":
            return Optional.ofNullable(clazz.cast(toolResult()));
        case "guardContent":
            return Optional.ofNullable(clazz.cast(guardContent()));
        case "reasoningContent":
            return Optional.ofNullable(clazz.cast(reasoningContent()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * Text to include in the message.
     * </p>
     * 
     * @param text
     *        Text to include in the message.
     */
    public static ContentBlock fromText(String text) {
        return builder().text(text).build();
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * Image to include in the message.
     * </p>
     * <note>
     * <p>
     * This field is only supported by Anthropic Claude 3 models.
     * </p>
     * </note>
     * 
     * @param image
     *        Image to include in the message. </p> <note>
     *        <p>
     *        This field is only supported by Anthropic Claude 3 models.
     *        </p>
     */
    public static ContentBlock fromImage(ImageBlock image) {
        return builder().image(image).build();
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * Image to include in the message.
     * </p>
     * <note>
     * <p>
     * This field is only supported by Anthropic Claude 3 models.
     * </p>
     * </note>
     * 
     * @param image
     *        Image to include in the message. </p> <note>
     *        <p>
     *        This field is only supported by Anthropic Claude 3 models.
     *        </p>
     */
    public static ContentBlock fromImage(Consumer<ImageBlock.Builder> image) {
        ImageBlock.Builder builder = ImageBlock.builder();
        image.accept(builder);
        return fromImage(builder.build());
    }

    /**
     * Create an instance of this class with {@link #document()} initialized to the given value.
     *
     * <p>
     * A document to include in the message.
     * </p>
     * 
     * @param document
     *        A document to include in the message.
     */
    public static ContentBlock fromDocument(DocumentBlock document) {
        return builder().document(document).build();
    }

    /**
     * Create an instance of this class with {@link #document()} initialized to the given value.
     *
     * <p>
     * A document to include in the message.
     * </p>
     * 
     * @param document
     *        A document to include in the message.
     */
    public static ContentBlock fromDocument(Consumer<DocumentBlock.Builder> document) {
        DocumentBlock.Builder builder = DocumentBlock.builder();
        document.accept(builder);
        return fromDocument(builder.build());
    }

    /**
     * Create an instance of this class with {@link #video()} initialized to the given value.
     *
     * <p>
     * Video to include in the message.
     * </p>
     * 
     * @param video
     *        Video to include in the message.
     */
    public static ContentBlock fromVideo(VideoBlock video) {
        return builder().video(video).build();
    }

    /**
     * Create an instance of this class with {@link #video()} initialized to the given value.
     *
     * <p>
     * Video to include in the message.
     * </p>
     * 
     * @param video
     *        Video to include in the message.
     */
    public static ContentBlock fromVideo(Consumer<VideoBlock.Builder> video) {
        VideoBlock.Builder builder = VideoBlock.builder();
        video.accept(builder);
        return fromVideo(builder.build());
    }

    /**
     * Create an instance of this class with {@link #toolUse()} initialized to the given value.
     *
     * <p>
     * Information about a tool use request from a model.
     * </p>
     * 
     * @param toolUse
     *        Information about a tool use request from a model.
     */
    public static ContentBlock fromToolUse(ToolUseBlock toolUse) {
        return builder().toolUse(toolUse).build();
    }

    /**
     * Create an instance of this class with {@link #toolUse()} initialized to the given value.
     *
     * <p>
     * Information about a tool use request from a model.
     * </p>
     * 
     * @param toolUse
     *        Information about a tool use request from a model.
     */
    public static ContentBlock fromToolUse(Consumer<ToolUseBlock.Builder> toolUse) {
        ToolUseBlock.Builder builder = ToolUseBlock.builder();
        toolUse.accept(builder);
        return fromToolUse(builder.build());
    }

    /**
     * Create an instance of this class with {@link #toolResult()} initialized to the given value.
     *
     * <p>
     * The result for a tool request that a model makes.
     * </p>
     * 
     * @param toolResult
     *        The result for a tool request that a model makes.
     */
    public static ContentBlock fromToolResult(ToolResultBlock toolResult) {
        return builder().toolResult(toolResult).build();
    }

    /**
     * Create an instance of this class with {@link #toolResult()} initialized to the given value.
     *
     * <p>
     * The result for a tool request that a model makes.
     * </p>
     * 
     * @param toolResult
     *        The result for a tool request that a model makes.
     */
    public static ContentBlock fromToolResult(Consumer<ToolResultBlock.Builder> toolResult) {
        ToolResultBlock.Builder builder = ToolResultBlock.builder();
        toolResult.accept(builder);
        return fromToolResult(builder.build());
    }

    /**
     * Create an instance of this class with {@link #guardContent()} initialized to the given value.
     *
     * <p>
     * Contains the content to assess with the guardrail. If you don't specify <code>guardContent</code> in a call to
     * the Converse API, the guardrail (if passed in the Converse API) assesses the entire message.
     * </p>
     * <p>
     * For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * 
     * @param guardContent
     *        Contains the content to assess with the guardrail. If you don't specify <code>guardContent</code> in a
     *        call to the Converse API, the guardrail (if passed in the Converse API) assesses the entire message.
     *        </p>
     *        <p>
     *        For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
     *        Guide</i>.
     * 
     * <pre><code> &lt;/p&gt; </code>
     */
    public static ContentBlock fromGuardContent(GuardrailConverseContentBlock guardContent) {
        return builder().guardContent(guardContent).build();
    }

    /**
     * Create an instance of this class with {@link #guardContent()} initialized to the given value.
     *
     * <p>
     * Contains the content to assess with the guardrail. If you don't specify <code>guardContent</code> in a call to
     * the Converse API, the guardrail (if passed in the Converse API) assesses the entire message.
     * </p>
     * <p>
     * For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User Guide</i>.
     * 
     * <pre>
     * <code> &lt;/p&gt; </code>
     * </pre>
     * 
     * @param guardContent
     *        Contains the content to assess with the guardrail. If you don't specify <code>guardContent</code> in a
     *        call to the Converse API, the guardrail (if passed in the Converse API) assesses the entire message.
     *        </p>
     *        <p>
     *        For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
     *        Guide</i>.
     * 
     * <pre><code> &lt;/p&gt; </code>
     */
    public static ContentBlock fromGuardContent(Consumer<GuardrailConverseContentBlock.Builder> guardContent) {
        GuardrailConverseContentBlock.Builder builder = GuardrailConverseContentBlock.builder();
        guardContent.accept(builder);
        return fromGuardContent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #reasoningContent()} initialized to the given value.
     *
     * <p>
     * Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of Thought
     * (CoT) that the model generates to enhance the accuracy of its final response.
     * </p>
     * 
     * @param reasoningContent
     *        Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of
     *        Thought (CoT) that the model generates to enhance the accuracy of its final response.
     */
    public static ContentBlock fromReasoningContent(ReasoningContentBlock reasoningContent) {
        return builder().reasoningContent(reasoningContent).build();
    }

    /**
     * Create an instance of this class with {@link #reasoningContent()} initialized to the given value.
     *
     * <p>
     * Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of Thought
     * (CoT) that the model generates to enhance the accuracy of its final response.
     * </p>
     * 
     * @param reasoningContent
     *        Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of
     *        Thought (CoT) that the model generates to enhance the accuracy of its final response.
     */
    public static ContentBlock fromReasoningContent(Consumer<ReasoningContentBlock.Builder> reasoningContent) {
        ReasoningContentBlock.Builder builder = ReasoningContentBlock.builder();
        reasoningContent.accept(builder);
        return fromReasoningContent(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("text", TEXT_FIELD);
        map.put("image", IMAGE_FIELD);
        map.put("document", DOCUMENT_FIELD);
        map.put("video", VIDEO_FIELD);
        map.put("toolUse", TOOL_USE_FIELD);
        map.put("toolResult", TOOL_RESULT_FIELD);
        map.put("guardContent", GUARD_CONTENT_FIELD);
        map.put("reasoningContent", REASONING_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentBlock, T> g) {
        return obj -> g.apply((ContentBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentBlock> {
        /**
         * <p>
         * Text to include in the message.
         * </p>
         * 
         * @param text
         *        Text to include in the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * Image to include in the message.
         * </p>
         * <note>
         * <p>
         * This field is only supported by Anthropic Claude 3 models.
         * </p>
         * </note>
         * 
         * @param image
         *        Image to include in the message. </p> <note>
         *        <p>
         *        This field is only supported by Anthropic Claude 3 models.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(ImageBlock image);

        /**
         * <p>
         * Image to include in the message.
         * </p>
         * <note>
         * <p>
         * This field is only supported by Anthropic Claude 3 models.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link ImageBlock.Builder} avoiding the
         * need to create one manually via {@link ImageBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageBlock.Builder#build()} is called immediately and its result
         * is passed to {@link #image(ImageBlock)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link ImageBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(ImageBlock)
         */
        default Builder image(Consumer<ImageBlock.Builder> image) {
            return image(ImageBlock.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * A document to include in the message.
         * </p>
         * 
         * @param document
         *        A document to include in the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(DocumentBlock document);

        /**
         * <p>
         * A document to include in the message.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentBlock.Builder} avoiding the need
         * to create one manually via {@link DocumentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #document(DocumentBlock)}.
         * 
         * @param document
         *        a consumer that will call methods on {@link DocumentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #document(DocumentBlock)
         */
        default Builder document(Consumer<DocumentBlock.Builder> document) {
            return document(DocumentBlock.builder().applyMutation(document).build());
        }

        /**
         * <p>
         * Video to include in the message.
         * </p>
         * 
         * @param video
         *        Video to include in the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoBlock video);

        /**
         * <p>
         * Video to include in the message.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoBlock.Builder} avoiding the need to
         * create one manually via {@link VideoBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoBlock.Builder#build()} is called immediately and its result
         * is passed to {@link #video(VideoBlock)}.
         * 
         * @param video
         *        a consumer that will call methods on {@link VideoBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(VideoBlock)
         */
        default Builder video(Consumer<VideoBlock.Builder> video) {
            return video(VideoBlock.builder().applyMutation(video).build());
        }

        /**
         * <p>
         * Information about a tool use request from a model.
         * </p>
         * 
         * @param toolUse
         *        Information about a tool use request from a model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolUse(ToolUseBlock toolUse);

        /**
         * <p>
         * Information about a tool use request from a model.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolUseBlock.Builder} avoiding the need
         * to create one manually via {@link ToolUseBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolUseBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #toolUse(ToolUseBlock)}.
         * 
         * @param toolUse
         *        a consumer that will call methods on {@link ToolUseBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolUse(ToolUseBlock)
         */
        default Builder toolUse(Consumer<ToolUseBlock.Builder> toolUse) {
            return toolUse(ToolUseBlock.builder().applyMutation(toolUse).build());
        }

        /**
         * <p>
         * The result for a tool request that a model makes.
         * </p>
         * 
         * @param toolResult
         *        The result for a tool request that a model makes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolResult(ToolResultBlock toolResult);

        /**
         * <p>
         * The result for a tool request that a model makes.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolResultBlock.Builder} avoiding the
         * need to create one manually via {@link ToolResultBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolResultBlock.Builder#build()} is called immediately and its
         * result is passed to {@link #toolResult(ToolResultBlock)}.
         * 
         * @param toolResult
         *        a consumer that will call methods on {@link ToolResultBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolResult(ToolResultBlock)
         */
        default Builder toolResult(Consumer<ToolResultBlock.Builder> toolResult) {
            return toolResult(ToolResultBlock.builder().applyMutation(toolResult).build());
        }

        /**
         * <p>
         * Contains the content to assess with the guardrail. If you don't specify <code>guardContent</code> in a call
         * to the Converse API, the guardrail (if passed in the Converse API) assesses the entire message.
         * </p>
         * <p>
         * For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
         * Guide</i>.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * @param guardContent
         *        Contains the content to assess with the guardrail. If you don't specify <code>guardContent</code> in a
         *        call to the Converse API, the guardrail (if passed in the Converse API) assesses the entire message.
         *        </p>
         *        <p>
         *        For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
         *        Guide</i>.
         * 
         *        <pre>
         * <code> &lt;/p&gt; </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardContent(GuardrailConverseContentBlock guardContent);

        /**
         * <p>
         * Contains the content to assess with the guardrail. If you don't specify <code>guardContent</code> in a call
         * to the Converse API, the guardrail (if passed in the Converse API) assesses the entire message.
         * </p>
         * <p>
         * For more information, see <i>Use a guardrail with the Converse API</i> in the <i>Amazon Bedrock User
         * Guide</i>.
         * 
         * <pre>
         * <code> &lt;/p&gt; </code>
         * </pre>
         * 
         * This is a convenience method that creates an instance of the {@link GuardrailConverseContentBlock.Builder}
         * avoiding the need to create one manually via {@link GuardrailConverseContentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailConverseContentBlock.Builder#build()} is called
         * immediately and its result is passed to {@link #guardContent(GuardrailConverseContentBlock)}.
         * 
         * @param guardContent
         *        a consumer that will call methods on {@link GuardrailConverseContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardContent(GuardrailConverseContentBlock)
         */
        default Builder guardContent(Consumer<GuardrailConverseContentBlock.Builder> guardContent) {
            return guardContent(GuardrailConverseContentBlock.builder().applyMutation(guardContent).build());
        }

        /**
         * <p>
         * Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of
         * Thought (CoT) that the model generates to enhance the accuracy of its final response.
         * </p>
         * 
         * @param reasoningContent
         *        Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain
         *        of Thought (CoT) that the model generates to enhance the accuracy of its final response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasoningContent(ReasoningContentBlock reasoningContent);

        /**
         * <p>
         * Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of
         * Thought (CoT) that the model generates to enhance the accuracy of its final response.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReasoningContentBlock.Builder} avoiding
         * the need to create one manually via {@link ReasoningContentBlock#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReasoningContentBlock.Builder#build()} is called immediately and
         * its result is passed to {@link #reasoningContent(ReasoningContentBlock)}.
         * 
         * @param reasoningContent
         *        a consumer that will call methods on {@link ReasoningContentBlock.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reasoningContent(ReasoningContentBlock)
         */
        default Builder reasoningContent(Consumer<ReasoningContentBlock.Builder> reasoningContent) {
            return reasoningContent(ReasoningContentBlock.builder().applyMutation(reasoningContent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private ImageBlock image;

        private DocumentBlock document;

        private VideoBlock video;

        private ToolUseBlock toolUse;

        private ToolResultBlock toolResult;

        private GuardrailConverseContentBlock guardContent;

        private ReasoningContentBlock reasoningContent;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBlock model) {
            text(model.text);
            image(model.image);
            document(model.document);
            video(model.video);
            toolUse(model.toolUse);
            toolResult(model.toolResult);
            guardContent(model.guardContent);
            reasoningContent(model.reasoningContent);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final ImageBlock.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(ImageBlock.BuilderImpl image) {
            Object oldValue = this.image;
            this.image = image != null ? image.build() : null;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
        }

        @Override
        public final Builder image(ImageBlock image) {
            Object oldValue = this.image;
            this.image = image;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
            return this;
        }

        public final DocumentBlock.Builder getDocument() {
            return document != null ? document.toBuilder() : null;
        }

        public final void setDocument(DocumentBlock.BuilderImpl document) {
            Object oldValue = this.document;
            this.document = document != null ? document.build() : null;
            handleUnionValueChange(Type.DOCUMENT, oldValue, this.document);
        }

        @Override
        public final Builder document(DocumentBlock document) {
            Object oldValue = this.document;
            this.document = document;
            handleUnionValueChange(Type.DOCUMENT, oldValue, this.document);
            return this;
        }

        public final VideoBlock.Builder getVideo() {
            return video != null ? video.toBuilder() : null;
        }

        public final void setVideo(VideoBlock.BuilderImpl video) {
            Object oldValue = this.video;
            this.video = video != null ? video.build() : null;
            handleUnionValueChange(Type.VIDEO, oldValue, this.video);
        }

        @Override
        public final Builder video(VideoBlock video) {
            Object oldValue = this.video;
            this.video = video;
            handleUnionValueChange(Type.VIDEO, oldValue, this.video);
            return this;
        }

        public final ToolUseBlock.Builder getToolUse() {
            return toolUse != null ? toolUse.toBuilder() : null;
        }

        public final void setToolUse(ToolUseBlock.BuilderImpl toolUse) {
            Object oldValue = this.toolUse;
            this.toolUse = toolUse != null ? toolUse.build() : null;
            handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
        }

        @Override
        public final Builder toolUse(ToolUseBlock toolUse) {
            Object oldValue = this.toolUse;
            this.toolUse = toolUse;
            handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
            return this;
        }

        public final ToolResultBlock.Builder getToolResult() {
            return toolResult != null ? toolResult.toBuilder() : null;
        }

        public final void setToolResult(ToolResultBlock.BuilderImpl toolResult) {
            Object oldValue = this.toolResult;
            this.toolResult = toolResult != null ? toolResult.build() : null;
            handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
        }

        @Override
        public final Builder toolResult(ToolResultBlock toolResult) {
            Object oldValue = this.toolResult;
            this.toolResult = toolResult;
            handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
            return this;
        }

        public final GuardrailConverseContentBlock.Builder getGuardContent() {
            return guardContent != null ? guardContent.toBuilder() : null;
        }

        public final void setGuardContent(GuardrailConverseContentBlock.BuilderImpl guardContent) {
            Object oldValue = this.guardContent;
            this.guardContent = guardContent != null ? guardContent.build() : null;
            handleUnionValueChange(Type.GUARD_CONTENT, oldValue, this.guardContent);
        }

        @Override
        public final Builder guardContent(GuardrailConverseContentBlock guardContent) {
            Object oldValue = this.guardContent;
            this.guardContent = guardContent;
            handleUnionValueChange(Type.GUARD_CONTENT, oldValue, this.guardContent);
            return this;
        }

        public final ReasoningContentBlock.Builder getReasoningContent() {
            return reasoningContent != null ? reasoningContent.toBuilder() : null;
        }

        public final void setReasoningContent(ReasoningContentBlock.BuilderImpl reasoningContent) {
            Object oldValue = this.reasoningContent;
            this.reasoningContent = reasoningContent != null ? reasoningContent.build() : null;
            handleUnionValueChange(Type.REASONING_CONTENT, oldValue, this.reasoningContent);
        }

        @Override
        public final Builder reasoningContent(ReasoningContentBlock reasoningContent) {
            Object oldValue = this.reasoningContent;
            this.reasoningContent = reasoningContent;
            handleUnionValueChange(Type.REASONING_CONTENT, oldValue, this.reasoningContent);
            return this;
        }

        @Override
        public ContentBlock build() {
            return new ContentBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ContentBlock#type()
     */
    public enum Type {
        TEXT,

        IMAGE,

        DOCUMENT,

        VIDEO,

        TOOL_USE,

        TOOL_RESULT,

        GUARD_CONTENT,

        REASONING_CONTENT,

        UNKNOWN_TO_SDK_VERSION
    }
}
