/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockruntime.model.BedrockRuntimeResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseMetrics;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseOutput;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseTrace;
import software.amazon.awssdk.services.bedrockruntime.model.PerformanceConfiguration;
import software.amazon.awssdk.services.bedrockruntime.model.StopReason;
import software.amazon.awssdk.services.bedrockruntime.model.TokenUsage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConverseResponse
extends BedrockRuntimeResponse
implements ToCopyableBuilder<Builder, ConverseResponse> {
    private static final SdkField<ConverseOutput> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("output").getter(ConverseResponse.getter(ConverseResponse::output)).setter(ConverseResponse.setter(Builder::output)).constructor(ConverseOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build()}).build();
    private static final SdkField<String> STOP_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stopReason").getter(ConverseResponse.getter(ConverseResponse::stopReasonAsString)).setter(ConverseResponse.setter(Builder::stopReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopReason").build()}).build();
    private static final SdkField<TokenUsage> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("usage").getter(ConverseResponse.getter(ConverseResponse::usage)).setter(ConverseResponse.setter(Builder::usage)).constructor(TokenUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()}).build();
    private static final SdkField<ConverseMetrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metrics").getter(ConverseResponse.getter(ConverseResponse::metrics)).setter(ConverseResponse.setter(Builder::metrics)).constructor(ConverseMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()}).build();
    private static final SdkField<Document> ADDITIONAL_MODEL_RESPONSE_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("additionalModelResponseFields").getter(ConverseResponse.getter(ConverseResponse::additionalModelResponseFields)).setter(ConverseResponse.setter(Builder::additionalModelResponseFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelResponseFields").build()}).build();
    private static final SdkField<ConverseTrace> TRACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trace").getter(ConverseResponse.getter(ConverseResponse::trace)).setter(ConverseResponse.setter(Builder::trace)).constructor(ConverseTrace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trace").build()}).build();
    private static final SdkField<PerformanceConfiguration> PERFORMANCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("performanceConfig").getter(ConverseResponse.getter(ConverseResponse::performanceConfig)).setter(ConverseResponse.setter(Builder::performanceConfig)).constructor(PerformanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_FIELD, STOP_REASON_FIELD, USAGE_FIELD, METRICS_FIELD, ADDITIONAL_MODEL_RESPONSE_FIELDS_FIELD, TRACE_FIELD, PERFORMANCE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConverseResponse.memberNameToFieldInitializer();
    private final ConverseOutput output;
    private final String stopReason;
    private final TokenUsage usage;
    private final ConverseMetrics metrics;
    private final Document additionalModelResponseFields;
    private final ConverseTrace trace;
    private final PerformanceConfiguration performanceConfig;

    private ConverseResponse(BuilderImpl builder) {
        super(builder);
        this.output = builder.output;
        this.stopReason = builder.stopReason;
        this.usage = builder.usage;
        this.metrics = builder.metrics;
        this.additionalModelResponseFields = builder.additionalModelResponseFields;
        this.trace = builder.trace;
        this.performanceConfig = builder.performanceConfig;
    }

    public final ConverseOutput output() {
        return this.output;
    }

    public final StopReason stopReason() {
        return StopReason.fromValue(this.stopReason);
    }

    public final String stopReasonAsString() {
        return this.stopReason;
    }

    public final TokenUsage usage() {
        return this.usage;
    }

    public final ConverseMetrics metrics() {
        return this.metrics;
    }

    public final Document additionalModelResponseFields() {
        return this.additionalModelResponseFields;
    }

    public final ConverseTrace trace() {
        return this.trace;
    }

    public final PerformanceConfiguration performanceConfig() {
        return this.performanceConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.output());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.usage());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalModelResponseFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.trace());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConverseResponse)) {
            return false;
        }
        ConverseResponse other = (ConverseResponse)((Object)obj);
        return Objects.equals(this.output(), other.output()) && Objects.equals(this.stopReasonAsString(), other.stopReasonAsString()) && Objects.equals(this.usage(), other.usage()) && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.additionalModelResponseFields(), other.additionalModelResponseFields()) && Objects.equals(this.trace(), other.trace()) && Objects.equals(this.performanceConfig(), other.performanceConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ConverseResponse").add("Output", (Object)this.output()).add("StopReason", (Object)this.stopReasonAsString()).add("Usage", (Object)this.usage()).add("Metrics", (Object)this.metrics()).add("AdditionalModelResponseFields", (Object)this.additionalModelResponseFields()).add("Trace", (Object)this.trace()).add("PerformanceConfig", (Object)this.performanceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "stopReason": {
                return Optional.ofNullable(clazz.cast(this.stopReasonAsString()));
            }
            case "usage": {
                return Optional.ofNullable(clazz.cast(this.usage()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "additionalModelResponseFields": {
                return Optional.ofNullable(clazz.cast(this.additionalModelResponseFields()));
            }
            case "trace": {
                return Optional.ofNullable(clazz.cast(this.trace()));
            }
            case "performanceConfig": {
                return Optional.ofNullable(clazz.cast(this.performanceConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("output", OUTPUT_FIELD);
        map.put("stopReason", STOP_REASON_FIELD);
        map.put("usage", USAGE_FIELD);
        map.put("metrics", METRICS_FIELD);
        map.put("additionalModelResponseFields", ADDITIONAL_MODEL_RESPONSE_FIELDS_FIELD);
        map.put("trace", TRACE_FIELD);
        map.put("performanceConfig", PERFORMANCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConverseResponse, T> g) {
        return obj -> g.apply((ConverseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRuntimeResponse.BuilderImpl
    implements Builder {
        private ConverseOutput output;
        private String stopReason;
        private TokenUsage usage;
        private ConverseMetrics metrics;
        private Document additionalModelResponseFields;
        private ConverseTrace trace;
        private PerformanceConfiguration performanceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ConverseResponse model) {
            super(model);
            this.output(model.output);
            this.stopReason(model.stopReason);
            this.usage(model.usage);
            this.metrics(model.metrics);
            this.additionalModelResponseFields(model.additionalModelResponseFields);
            this.trace(model.trace);
            this.performanceConfig(model.performanceConfig);
        }

        public final ConverseOutput.Builder getOutput() {
            return this.output != null ? this.output.toBuilder() : null;
        }

        public final void setOutput(ConverseOutput.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(ConverseOutput output) {
            this.output = output;
            return this;
        }

        public final String getStopReason() {
            return this.stopReason;
        }

        public final void setStopReason(String stopReason) {
            this.stopReason = stopReason;
        }

        @Override
        public final Builder stopReason(String stopReason) {
            this.stopReason = stopReason;
            return this;
        }

        @Override
        public final Builder stopReason(StopReason stopReason) {
            this.stopReason(stopReason == null ? null : stopReason.toString());
            return this;
        }

        public final TokenUsage.Builder getUsage() {
            return this.usage != null ? this.usage.toBuilder() : null;
        }

        public final void setUsage(TokenUsage.BuilderImpl usage) {
            this.usage = usage != null ? usage.build() : null;
        }

        @Override
        public final Builder usage(TokenUsage usage) {
            this.usage = usage;
            return this;
        }

        public final ConverseMetrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        public final void setMetrics(ConverseMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(ConverseMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final Document getAdditionalModelResponseFields() {
            return this.additionalModelResponseFields;
        }

        public final void setAdditionalModelResponseFields(Document additionalModelResponseFields) {
            this.additionalModelResponseFields = additionalModelResponseFields;
        }

        @Override
        public final Builder additionalModelResponseFields(Document additionalModelResponseFields) {
            this.additionalModelResponseFields = additionalModelResponseFields;
            return this;
        }

        public final ConverseTrace.Builder getTrace() {
            return this.trace != null ? this.trace.toBuilder() : null;
        }

        public final void setTrace(ConverseTrace.BuilderImpl trace) {
            this.trace = trace != null ? trace.build() : null;
        }

        @Override
        public final Builder trace(ConverseTrace trace) {
            this.trace = trace;
            return this;
        }

        public final PerformanceConfiguration.Builder getPerformanceConfig() {
            return this.performanceConfig != null ? this.performanceConfig.toBuilder() : null;
        }

        public final void setPerformanceConfig(PerformanceConfiguration.BuilderImpl performanceConfig) {
            this.performanceConfig = performanceConfig != null ? performanceConfig.build() : null;
        }

        @Override
        public final Builder performanceConfig(PerformanceConfiguration performanceConfig) {
            this.performanceConfig = performanceConfig;
            return this;
        }

        @Override
        public ConverseResponse build() {
            return new ConverseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConverseResponse> {
        public Builder output(ConverseOutput var1);

        default public Builder output(Consumer<ConverseOutput.Builder> output) {
            return this.output((ConverseOutput)((ConverseOutput.Builder)ConverseOutput.builder().applyMutation(output)).build());
        }

        public Builder stopReason(String var1);

        public Builder stopReason(StopReason var1);

        public Builder usage(TokenUsage var1);

        default public Builder usage(Consumer<TokenUsage.Builder> usage) {
            return this.usage((TokenUsage)((TokenUsage.Builder)TokenUsage.builder().applyMutation(usage)).build());
        }

        public Builder metrics(ConverseMetrics var1);

        default public Builder metrics(Consumer<ConverseMetrics.Builder> metrics) {
            return this.metrics((ConverseMetrics)((ConverseMetrics.Builder)ConverseMetrics.builder().applyMutation(metrics)).build());
        }

        public Builder additionalModelResponseFields(Document var1);

        public Builder trace(ConverseTrace var1);

        default public Builder trace(Consumer<ConverseTrace.Builder> trace) {
            return this.trace((ConverseTrace)((ConverseTrace.Builder)ConverseTrace.builder().applyMutation(trace)).build());
        }

        public Builder performanceConfig(PerformanceConfiguration var1);

        default public Builder performanceConfig(Consumer<PerformanceConfiguration.Builder> performanceConfig) {
            return this.performanceConfig((PerformanceConfiguration)((PerformanceConfiguration.Builder)PerformanceConfiguration.builder().applyMutation(performanceConfig)).build());
        }
    }
}

