/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The invocation metrics for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailInvocationMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailInvocationMetrics.Builder, GuardrailInvocationMetrics> {
    private static final SdkField<Long> GUARDRAIL_PROCESSING_LATENCY_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("guardrailProcessingLatency")
            .getter(getter(GuardrailInvocationMetrics::guardrailProcessingLatency))
            .setter(setter(Builder::guardrailProcessingLatency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailProcessingLatency").build())
            .build();

    private static final SdkField<GuardrailUsage> USAGE_FIELD = SdkField.<GuardrailUsage> builder(MarshallingType.SDK_POJO)
            .memberName("usage").getter(getter(GuardrailInvocationMetrics::usage)).setter(setter(Builder::usage))
            .constructor(GuardrailUsage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()).build();

    private static final SdkField<GuardrailCoverage> GUARDRAIL_COVERAGE_FIELD = SdkField
            .<GuardrailCoverage> builder(MarshallingType.SDK_POJO).memberName("guardrailCoverage")
            .getter(getter(GuardrailInvocationMetrics::guardrailCoverage)).setter(setter(Builder::guardrailCoverage))
            .constructor(GuardrailCoverage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailCoverage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GUARDRAIL_PROCESSING_LATENCY_FIELD, USAGE_FIELD, GUARDRAIL_COVERAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long guardrailProcessingLatency;

    private final GuardrailUsage usage;

    private final GuardrailCoverage guardrailCoverage;

    private GuardrailInvocationMetrics(BuilderImpl builder) {
        this.guardrailProcessingLatency = builder.guardrailProcessingLatency;
        this.usage = builder.usage;
        this.guardrailCoverage = builder.guardrailCoverage;
    }

    /**
     * <p>
     * The processing latency details for the guardrail invocation metrics.
     * </p>
     * 
     * @return The processing latency details for the guardrail invocation metrics.
     */
    public final Long guardrailProcessingLatency() {
        return guardrailProcessingLatency;
    }

    /**
     * <p>
     * The usage details for the guardrail invocation metrics.
     * </p>
     * 
     * @return The usage details for the guardrail invocation metrics.
     */
    public final GuardrailUsage usage() {
        return usage;
    }

    /**
     * <p>
     * The coverage details for the guardrail invocation metrics.
     * </p>
     * 
     * @return The coverage details for the guardrail invocation metrics.
     */
    public final GuardrailCoverage guardrailCoverage() {
        return guardrailCoverage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guardrailProcessingLatency());
        hashCode = 31 * hashCode + Objects.hashCode(usage());
        hashCode = 31 * hashCode + Objects.hashCode(guardrailCoverage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailInvocationMetrics)) {
            return false;
        }
        GuardrailInvocationMetrics other = (GuardrailInvocationMetrics) obj;
        return Objects.equals(guardrailProcessingLatency(), other.guardrailProcessingLatency())
                && Objects.equals(usage(), other.usage()) && Objects.equals(guardrailCoverage(), other.guardrailCoverage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailInvocationMetrics").add("GuardrailProcessingLatency", guardrailProcessingLatency())
                .add("Usage", usage()).add("GuardrailCoverage", guardrailCoverage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailProcessingLatency":
            return Optional.ofNullable(clazz.cast(guardrailProcessingLatency()));
        case "usage":
            return Optional.ofNullable(clazz.cast(usage()));
        case "guardrailCoverage":
            return Optional.ofNullable(clazz.cast(guardrailCoverage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("guardrailProcessingLatency", GUARDRAIL_PROCESSING_LATENCY_FIELD);
        map.put("usage", USAGE_FIELD);
        map.put("guardrailCoverage", GUARDRAIL_COVERAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailInvocationMetrics, T> g) {
        return obj -> g.apply((GuardrailInvocationMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailInvocationMetrics> {
        /**
         * <p>
         * The processing latency details for the guardrail invocation metrics.
         * </p>
         * 
         * @param guardrailProcessingLatency
         *        The processing latency details for the guardrail invocation metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailProcessingLatency(Long guardrailProcessingLatency);

        /**
         * <p>
         * The usage details for the guardrail invocation metrics.
         * </p>
         * 
         * @param usage
         *        The usage details for the guardrail invocation metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(GuardrailUsage usage);

        /**
         * <p>
         * The usage details for the guardrail invocation metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailUsage.Builder} avoiding the need
         * to create one manually via {@link GuardrailUsage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailUsage.Builder#build()} is called immediately and its
         * result is passed to {@link #usage(GuardrailUsage)}.
         * 
         * @param usage
         *        a consumer that will call methods on {@link GuardrailUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usage(GuardrailUsage)
         */
        default Builder usage(Consumer<GuardrailUsage.Builder> usage) {
            return usage(GuardrailUsage.builder().applyMutation(usage).build());
        }

        /**
         * <p>
         * The coverage details for the guardrail invocation metrics.
         * </p>
         * 
         * @param guardrailCoverage
         *        The coverage details for the guardrail invocation metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailCoverage(GuardrailCoverage guardrailCoverage);

        /**
         * <p>
         * The coverage details for the guardrail invocation metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailCoverage.Builder} avoiding the
         * need to create one manually via {@link GuardrailCoverage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailCoverage.Builder#build()} is called immediately and its
         * result is passed to {@link #guardrailCoverage(GuardrailCoverage)}.
         * 
         * @param guardrailCoverage
         *        a consumer that will call methods on {@link GuardrailCoverage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrailCoverage(GuardrailCoverage)
         */
        default Builder guardrailCoverage(Consumer<GuardrailCoverage.Builder> guardrailCoverage) {
            return guardrailCoverage(GuardrailCoverage.builder().applyMutation(guardrailCoverage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long guardrailProcessingLatency;

        private GuardrailUsage usage;

        private GuardrailCoverage guardrailCoverage;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailInvocationMetrics model) {
            guardrailProcessingLatency(model.guardrailProcessingLatency);
            usage(model.usage);
            guardrailCoverage(model.guardrailCoverage);
        }

        public final Long getGuardrailProcessingLatency() {
            return guardrailProcessingLatency;
        }

        public final void setGuardrailProcessingLatency(Long guardrailProcessingLatency) {
            this.guardrailProcessingLatency = guardrailProcessingLatency;
        }

        @Override
        public final Builder guardrailProcessingLatency(Long guardrailProcessingLatency) {
            this.guardrailProcessingLatency = guardrailProcessingLatency;
            return this;
        }

        public final GuardrailUsage.Builder getUsage() {
            return usage != null ? usage.toBuilder() : null;
        }

        public final void setUsage(GuardrailUsage.BuilderImpl usage) {
            this.usage = usage != null ? usage.build() : null;
        }

        @Override
        public final Builder usage(GuardrailUsage usage) {
            this.usage = usage;
            return this;
        }

        public final GuardrailCoverage.Builder getGuardrailCoverage() {
            return guardrailCoverage != null ? guardrailCoverage.toBuilder() : null;
        }

        public final void setGuardrailCoverage(GuardrailCoverage.BuilderImpl guardrailCoverage) {
            this.guardrailCoverage = guardrailCoverage != null ? guardrailCoverage.build() : null;
        }

        @Override
        public final Builder guardrailCoverage(GuardrailCoverage guardrailCoverage) {
            this.guardrailCoverage = guardrailCoverage;
            return this;
        }

        @Override
        public GuardrailInvocationMetrics build() {
            return new GuardrailInvocationMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
