/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class GuardrailAssessmentMapCopier {
    static Map<String, GuardrailAssessment> copy(Map<String, ? extends GuardrailAssessment> guardrailAssessmentMapParam) {
        Map<String, GuardrailAssessment> map;
        if (guardrailAssessmentMapParam == null || guardrailAssessmentMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, GuardrailAssessment> modifiableMap = new LinkedHashMap<>(guardrailAssessmentMapParam.size());
            guardrailAssessmentMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, GuardrailAssessment> copyFromBuilder(
            Map<String, ? extends GuardrailAssessment.Builder> guardrailAssessmentMapParam) {
        Map<String, GuardrailAssessment> map;
        if (guardrailAssessmentMapParam == null || guardrailAssessmentMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, GuardrailAssessment> modifiableMap = new LinkedHashMap<>(guardrailAssessmentMapParam.size());
            guardrailAssessmentMapParam.forEach((key, value) -> {
                GuardrailAssessment member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, GuardrailAssessment.Builder> copyToBuilder(
            Map<String, ? extends GuardrailAssessment> guardrailAssessmentMapParam) {
        Map<String, GuardrailAssessment.Builder> map;
        if (guardrailAssessmentMapParam == null || guardrailAssessmentMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, GuardrailAssessment.Builder> modifiableMap = new LinkedHashMap<>(guardrailAssessmentMapParam.size());
            guardrailAssessmentMapParam.forEach((key, value) -> {
                GuardrailAssessment.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
