/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAsyncInvokeResponse extends BedrockRuntimeResponse implements
        ToCopyableBuilder<StartAsyncInvokeResponse.Builder, StartAsyncInvokeResponse> {
    private static final SdkField<String> INVOCATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationArn").getter(getter(StartAsyncInvokeResponse::invocationArn))
            .setter(setter(Builder::invocationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String invocationArn;

    private StartAsyncInvokeResponse(BuilderImpl builder) {
        super(builder);
        this.invocationArn = builder.invocationArn;
    }

    /**
     * <p>
     * The ARN of the invocation.
     * </p>
     * 
     * @return The ARN of the invocation.
     */
    public final String invocationArn() {
        return invocationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(invocationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAsyncInvokeResponse)) {
            return false;
        }
        StartAsyncInvokeResponse other = (StartAsyncInvokeResponse) obj;
        return Objects.equals(invocationArn(), other.invocationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAsyncInvokeResponse").add("InvocationArn", invocationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invocationArn":
            return Optional.ofNullable(clazz.cast(invocationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invocationArn", INVOCATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAsyncInvokeResponse, T> g) {
        return obj -> g.apply((StartAsyncInvokeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRuntimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartAsyncInvokeResponse> {
        /**
         * <p>
         * The ARN of the invocation.
         * </p>
         * 
         * @param invocationArn
         *        The ARN of the invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationArn(String invocationArn);
    }

    static final class BuilderImpl extends BedrockRuntimeResponse.BuilderImpl implements Builder {
        private String invocationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAsyncInvokeResponse model) {
            super(model);
            invocationArn(model.invocationArn);
        }

        public final String getInvocationArn() {
            return invocationArn;
        }

        public final void setInvocationArn(String invocationArn) {
            this.invocationArn = invocationArn;
        }

        @Override
        public final Builder invocationArn(String invocationArn) {
            this.invocationArn = invocationArn;
            return this;
        }

        @Override
        public StartAsyncInvokeResponse build() {
            return new StartAsyncInvokeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
