/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentFilterConfidence;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentFilterStrength;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentFilterType;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentPolicyAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailContentFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailContentFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GuardrailContentFilter.getter(GuardrailContentFilter::typeAsString)).setter(GuardrailContentFilter.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("confidence").getter(GuardrailContentFilter.getter(GuardrailContentFilter::confidenceAsString)).setter(GuardrailContentFilter.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidence").build()}).build();
    private static final SdkField<String> FILTER_STRENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterStrength").getter(GuardrailContentFilter.getter(GuardrailContentFilter::filterStrengthAsString)).setter(GuardrailContentFilter.setter(Builder::filterStrength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterStrength").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(GuardrailContentFilter.getter(GuardrailContentFilter::actionAsString)).setter(GuardrailContentFilter.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CONFIDENCE_FIELD, FILTER_STRENGTH_FIELD, ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("type", TYPE_FIELD);
            this.put("confidence", CONFIDENCE_FIELD);
            this.put("filterStrength", FILTER_STRENGTH_FIELD);
            this.put("action", ACTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String confidence;
    private final String filterStrength;
    private final String action;

    private GuardrailContentFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.confidence = builder.confidence;
        this.filterStrength = builder.filterStrength;
        this.action = builder.action;
    }

    public final GuardrailContentFilterType type() {
        return GuardrailContentFilterType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final GuardrailContentFilterConfidence confidence() {
        return GuardrailContentFilterConfidence.fromValue(this.confidence);
    }

    public final String confidenceAsString() {
        return this.confidence;
    }

    public final GuardrailContentFilterStrength filterStrength() {
        return GuardrailContentFilterStrength.fromValue(this.filterStrength);
    }

    public final String filterStrengthAsString() {
        return this.filterStrength;
    }

    public final GuardrailContentPolicyAction action() {
        return GuardrailContentPolicyAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterStrengthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContentFilter)) {
            return false;
        }
        GuardrailContentFilter other = (GuardrailContentFilter)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.confidenceAsString(), other.confidenceAsString()) && Objects.equals(this.filterStrengthAsString(), other.filterStrengthAsString()) && Objects.equals(this.actionAsString(), other.actionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailContentFilter").add("Type", (Object)this.typeAsString()).add("Confidence", (Object)this.confidenceAsString()).add("FilterStrength", (Object)this.filterStrengthAsString()).add("Action", (Object)this.actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "confidence": {
                return Optional.ofNullable(clazz.cast(this.confidenceAsString()));
            }
            case "filterStrength": {
                return Optional.ofNullable(clazz.cast(this.filterStrengthAsString()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContentFilter, T> g) {
        return obj -> g.apply((GuardrailContentFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String confidence;
        private String filterStrength;
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContentFilter model) {
            this.type(model.type);
            this.confidence(model.confidence);
            this.filterStrength(model.filterStrength);
            this.action(model.action);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailContentFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(String confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(String confidence) {
            this.confidence = confidence;
            return this;
        }

        @Override
        public final Builder confidence(GuardrailContentFilterConfidence confidence) {
            this.confidence(confidence == null ? null : confidence.toString());
            return this;
        }

        public final String getFilterStrength() {
            return this.filterStrength;
        }

        public final void setFilterStrength(String filterStrength) {
            this.filterStrength = filterStrength;
        }

        @Override
        public final Builder filterStrength(String filterStrength) {
            this.filterStrength = filterStrength;
            return this;
        }

        @Override
        public final Builder filterStrength(GuardrailContentFilterStrength filterStrength) {
            this.filterStrength(filterStrength == null ? null : filterStrength.toString());
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailContentPolicyAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public GuardrailContentFilter build() {
            return new GuardrailContentFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailContentFilter> {
        public Builder type(String var1);

        public Builder type(GuardrailContentFilterType var1);

        public Builder confidence(String var1);

        public Builder confidence(GuardrailContentFilterConfidence var1);

        public Builder filterStrength(String var1);

        public Builder filterStrength(GuardrailContentFilterStrength var1);

        public Builder action(String var1);

        public Builder action(GuardrailContentPolicyAction var1);
    }
}

