/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.AsyncInvokeOutputDataConfig;
import software.amazon.awssdk.services.bedrockruntime.model.BedrockRuntimeRequest;
import software.amazon.awssdk.services.bedrockruntime.model.Tag;
import software.amazon.awssdk.services.bedrockruntime.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAsyncInvokeRequest
extends BedrockRuntimeRequest
implements ToCopyableBuilder<Builder, StartAsyncInvokeRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(StartAsyncInvokeRequest.getter(StartAsyncInvokeRequest::clientRequestToken)).setter(StartAsyncInvokeRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(StartAsyncInvokeRequest.getter(StartAsyncInvokeRequest::modelId)).setter(StartAsyncInvokeRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<Document> MODEL_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("modelInput").getter(StartAsyncInvokeRequest.getter(StartAsyncInvokeRequest::modelInput)).setter(StartAsyncInvokeRequest.setter(Builder::modelInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelInput").build()}).build();
    private static final SdkField<AsyncInvokeOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDataConfig").getter(StartAsyncInvokeRequest.getter(StartAsyncInvokeRequest::outputDataConfig)).setter(StartAsyncInvokeRequest.setter(Builder::outputDataConfig)).constructor(AsyncInvokeOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(StartAsyncInvokeRequest.getter(StartAsyncInvokeRequest::tags)).setter(StartAsyncInvokeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, MODEL_ID_FIELD, MODEL_INPUT_FIELD, OUTPUT_DATA_CONFIG_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("modelId", MODEL_ID_FIELD);
            this.put("modelInput", MODEL_INPUT_FIELD);
            this.put("outputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String clientRequestToken;
    private final String modelId;
    private final Document modelInput;
    private final AsyncInvokeOutputDataConfig outputDataConfig;
    private final List<Tag> tags;

    private StartAsyncInvokeRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.modelId = builder.modelId;
        this.modelInput = builder.modelInput;
        this.outputDataConfig = builder.outputDataConfig;
        this.tags = builder.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final Document modelInput() {
        return this.modelInput;
    }

    public final AsyncInvokeOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAsyncInvokeRequest)) {
            return false;
        }
        StartAsyncInvokeRequest other = (StartAsyncInvokeRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.modelInput(), other.modelInput()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartAsyncInvokeRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("ModelId", (Object)this.modelId()).add("ModelInput", (Object)(this.modelInput() == null ? null : "*** Sensitive Data Redacted ***")).add("OutputDataConfig", (Object)this.outputDataConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "modelInput": {
                return Optional.ofNullable(clazz.cast(this.modelInput()));
            }
            case "outputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartAsyncInvokeRequest, T> g) {
        return obj -> g.apply((StartAsyncInvokeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRuntimeRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String modelId;
        private Document modelInput;
        private AsyncInvokeOutputDataConfig outputDataConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartAsyncInvokeRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.modelId(model.modelId);
            this.modelInput(model.modelInput);
            this.outputDataConfig(model.outputDataConfig);
            this.tags(model.tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final Document getModelInput() {
            return this.modelInput;
        }

        public final void setModelInput(Document modelInput) {
            this.modelInput = modelInput;
        }

        @Override
        public final Builder modelInput(Document modelInput) {
            this.modelInput = modelInput;
            return this;
        }

        public final AsyncInvokeOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(AsyncInvokeOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(AsyncInvokeOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAsyncInvokeRequest build() {
            return new StartAsyncInvokeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAsyncInvokeRequest> {
        public Builder clientRequestToken(String var1);

        public Builder modelId(String var1);

        public Builder modelInput(Document var1);

        public Builder outputDataConfig(AsyncInvokeOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<AsyncInvokeOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((AsyncInvokeOutputDataConfig)((AsyncInvokeOutputDataConfig.Builder)AsyncInvokeOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

