/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplyGuardrailResponse extends BedrockRuntimeResponse implements
        ToCopyableBuilder<ApplyGuardrailResponse.Builder, ApplyGuardrailResponse> {
    private static final SdkField<GuardrailUsage> USAGE_FIELD = SdkField.<GuardrailUsage> builder(MarshallingType.SDK_POJO)
            .memberName("usage").getter(getter(ApplyGuardrailResponse::usage)).setter(setter(Builder::usage))
            .constructor(GuardrailUsage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(ApplyGuardrailResponse::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<List<GuardrailOutputContent>> OUTPUTS_FIELD = SdkField
            .<List<GuardrailOutputContent>> builder(MarshallingType.LIST)
            .memberName("outputs")
            .getter(getter(ApplyGuardrailResponse::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailOutputContent> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailOutputContent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GuardrailAssessment>> ASSESSMENTS_FIELD = SdkField
            .<List<GuardrailAssessment>> builder(MarshallingType.LIST)
            .memberName("assessments")
            .getter(getter(ApplyGuardrailResponse::assessments))
            .setter(setter(Builder::assessments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailAssessment> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailAssessment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_FIELD, ACTION_FIELD,
            OUTPUTS_FIELD, ASSESSMENTS_FIELD));

    private final GuardrailUsage usage;

    private final String action;

    private final List<GuardrailOutputContent> outputs;

    private final List<GuardrailAssessment> assessments;

    private ApplyGuardrailResponse(BuilderImpl builder) {
        super(builder);
        this.usage = builder.usage;
        this.action = builder.action;
        this.outputs = builder.outputs;
        this.assessments = builder.assessments;
    }

    /**
     * <p>
     * The usage details in the response from the guardrail.
     * </p>
     * 
     * @return The usage details in the response from the guardrail.
     */
    public final GuardrailUsage usage() {
        return usage;
    }

    /**
     * <p>
     * The action taken in the response from the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action taken in the response from the guardrail.
     * @see GuardrailAction
     */
    public final GuardrailAction action() {
        return GuardrailAction.fromValue(action);
    }

    /**
     * <p>
     * The action taken in the response from the guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action taken in the response from the guardrail.
     * @see GuardrailAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The output details in the response from the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The output details in the response from the guardrail.
     */
    public final List<GuardrailOutputContent> outputs() {
        return outputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Assessments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssessments() {
        return assessments != null && !(assessments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The assessment details in the response from the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssessments} method.
     * </p>
     * 
     * @return The assessment details in the response from the guardrail.
     */
    public final List<GuardrailAssessment> assessments() {
        return assessments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usage());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssessments() ? assessments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplyGuardrailResponse)) {
            return false;
        }
        ApplyGuardrailResponse other = (ApplyGuardrailResponse) obj;
        return Objects.equals(usage(), other.usage()) && Objects.equals(actionAsString(), other.actionAsString())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && hasAssessments() == other.hasAssessments() && Objects.equals(assessments(), other.assessments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplyGuardrailResponse").add("Usage", usage()).add("Action", actionAsString())
                .add("Outputs", hasOutputs() ? outputs() : null).add("Assessments", hasAssessments() ? assessments() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "usage":
            return Optional.ofNullable(clazz.cast(usage()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "assessments":
            return Optional.ofNullable(clazz.cast(assessments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplyGuardrailResponse, T> g) {
        return obj -> g.apply((ApplyGuardrailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRuntimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ApplyGuardrailResponse> {
        /**
         * <p>
         * The usage details in the response from the guardrail.
         * </p>
         * 
         * @param usage
         *        The usage details in the response from the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usage(GuardrailUsage usage);

        /**
         * <p>
         * The usage details in the response from the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailUsage.Builder} avoiding the need
         * to create one manually via {@link GuardrailUsage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailUsage.Builder#build()} is called immediately and its
         * result is passed to {@link #usage(GuardrailUsage)}.
         * 
         * @param usage
         *        a consumer that will call methods on {@link GuardrailUsage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usage(GuardrailUsage)
         */
        default Builder usage(Consumer<GuardrailUsage.Builder> usage) {
            return usage(GuardrailUsage.builder().applyMutation(usage).build());
        }

        /**
         * <p>
         * The action taken in the response from the guardrail.
         * </p>
         * 
         * @param action
         *        The action taken in the response from the guardrail.
         * @see GuardrailAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action taken in the response from the guardrail.
         * </p>
         * 
         * @param action
         *        The action taken in the response from the guardrail.
         * @see GuardrailAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailAction
         */
        Builder action(GuardrailAction action);

        /**
         * <p>
         * The output details in the response from the guardrail.
         * </p>
         * 
         * @param outputs
         *        The output details in the response from the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<GuardrailOutputContent> outputs);

        /**
         * <p>
         * The output details in the response from the guardrail.
         * </p>
         * 
         * @param outputs
         *        The output details in the response from the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(GuardrailOutputContent... outputs);

        /**
         * <p>
         * The output details in the response from the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailOutputContent.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailOutputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailOutputContent.Builder#build()} is called
         * immediately and its result is passed to {@link #outputs(List<GuardrailOutputContent>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailOutputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<GuardrailOutputContent>)
         */
        Builder outputs(Consumer<GuardrailOutputContent.Builder>... outputs);

        /**
         * <p>
         * The assessment details in the response from the guardrail.
         * </p>
         * 
         * @param assessments
         *        The assessment details in the response from the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessments(Collection<GuardrailAssessment> assessments);

        /**
         * <p>
         * The assessment details in the response from the guardrail.
         * </p>
         * 
         * @param assessments
         *        The assessment details in the response from the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessments(GuardrailAssessment... assessments);

        /**
         * <p>
         * The assessment details in the response from the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAssessment.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAssessment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAssessment.Builder#build()} is called
         * immediately and its result is passed to {@link #assessments(List<GuardrailAssessment>)}.
         * 
         * @param assessments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.GuardrailAssessment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessments(java.util.Collection<GuardrailAssessment>)
         */
        Builder assessments(Consumer<GuardrailAssessment.Builder>... assessments);
    }

    static final class BuilderImpl extends BedrockRuntimeResponse.BuilderImpl implements Builder {
        private GuardrailUsage usage;

        private String action;

        private List<GuardrailOutputContent> outputs = DefaultSdkAutoConstructList.getInstance();

        private List<GuardrailAssessment> assessments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplyGuardrailResponse model) {
            super(model);
            usage(model.usage);
            action(model.action);
            outputs(model.outputs);
            assessments(model.assessments);
        }

        public final GuardrailUsage.Builder getUsage() {
            return usage != null ? usage.toBuilder() : null;
        }

        public final void setUsage(GuardrailUsage.BuilderImpl usage) {
            this.usage = usage != null ? usage.build() : null;
        }

        @Override
        public final Builder usage(GuardrailUsage usage) {
            this.usage = usage;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final List<GuardrailOutputContent.Builder> getOutputs() {
            List<GuardrailOutputContent.Builder> result = GuardrailOutputContentListCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<GuardrailOutputContent.BuilderImpl> outputs) {
            this.outputs = GuardrailOutputContentListCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<GuardrailOutputContent> outputs) {
            this.outputs = GuardrailOutputContentListCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(GuardrailOutputContent... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<GuardrailOutputContent.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> GuardrailOutputContent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailAssessment.Builder> getAssessments() {
            List<GuardrailAssessment.Builder> result = GuardrailAssessmentListCopier.copyToBuilder(this.assessments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessments(Collection<GuardrailAssessment.BuilderImpl> assessments) {
            this.assessments = GuardrailAssessmentListCopier.copyFromBuilder(assessments);
        }

        @Override
        public final Builder assessments(Collection<GuardrailAssessment> assessments) {
            this.assessments = GuardrailAssessmentListCopier.copy(assessments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessments(GuardrailAssessment... assessments) {
            assessments(Arrays.asList(assessments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessments(Consumer<GuardrailAssessment.Builder>... assessments) {
            assessments(Stream.of(assessments).map(c -> GuardrailAssessment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ApplyGuardrailResponse build() {
            return new ApplyGuardrailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
