/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeServiceClientConfiguration;
import software.amazon.awssdk.services.bedrockruntime.DefaultBedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelWithResponseStreamResponseHandler;

@SdkPublicApi
@ThreadSafe
public interface BedrockRuntimeAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "bedrock";
    public static final String SERVICE_METADATA_ID = "bedrock-runtime";

    default public CompletableFuture<InvokeModelResponse> invokeModel(InvokeModelRequest invokeModelRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<InvokeModelResponse> invokeModel(Consumer<InvokeModelRequest.Builder> invokeModelRequest) {
        return this.invokeModel((InvokeModelRequest)((Object)((InvokeModelRequest.Builder)InvokeModelRequest.builder().applyMutation(invokeModelRequest)).build()));
    }

    default public CompletableFuture<Void> invokeModelWithResponseStream(InvokeModelWithResponseStreamRequest invokeModelWithResponseStreamRequest, InvokeModelWithResponseStreamResponseHandler asyncResponseHandler) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<Void> invokeModelWithResponseStream(Consumer<InvokeModelWithResponseStreamRequest.Builder> invokeModelWithResponseStreamRequest, InvokeModelWithResponseStreamResponseHandler asyncResponseHandler) {
        return this.invokeModelWithResponseStream((InvokeModelWithResponseStreamRequest)((Object)((InvokeModelWithResponseStreamRequest.Builder)InvokeModelWithResponseStreamRequest.builder().applyMutation(invokeModelWithResponseStreamRequest)).build()), asyncResponseHandler);
    }

    default public BedrockRuntimeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static BedrockRuntimeAsyncClient create() {
        return (BedrockRuntimeAsyncClient)BedrockRuntimeAsyncClient.builder().build();
    }

    public static BedrockRuntimeAsyncClientBuilder builder() {
        return new DefaultBedrockRuntimeAsyncClientBuilder();
    }
}

