/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeModelRequest extends BedrockRuntimeRequest implements
        ToCopyableBuilder<InvokeModelRequest.Builder, InvokeModelRequest> {
    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("accept")
            .getter(getter(InvokeModelRequest::accept)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()).build();

    private static final SdkField<SdkBytes> BODY_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("body")
            .getter(getter(InvokeModelRequest::body))
            .setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(InvokeModelRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(InvokeModelRequest::modelId)).setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_FIELD, BODY_FIELD,
            CONTENT_TYPE_FIELD, MODEL_ID_FIELD));

    private final String accept;

    private final SdkBytes body;

    private final String contentType;

    private final String modelId;

    private InvokeModelRequest(BuilderImpl builder) {
        super(builder);
        this.accept = builder.accept;
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.modelId = builder.modelId;
    }

    /**
     * <p>
     * The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.
     * </p>
     * 
     * @return The desired MIME type of the inference body in the response. The default value is
     *         <code>application/json</code>.
     */
    public final String accept() {
        return accept;
    }

    /**
     * <p>
     * Input data in the format specified in the content-type request header. To see the format and content of this
     * field for different models, refer to <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>.
     * </p>
     * 
     * @return Input data in the format specified in the content-type request header. To see the format and content of
     *         this field for different models, refer to <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference
     *         parameters</a>.
     */
    public final SdkBytes body() {
        return body;
    }

    /**
     * <p>
     * The MIME type of the input data in the request. The default value is <code>application/json</code>.
     * </p>
     * 
     * @return The MIME type of the input data in the request. The default value is <code>application/json</code>.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Identifier of the model.
     * </p>
     * 
     * @return Identifier of the model.
     */
    public final String modelId() {
        return modelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accept());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeModelRequest)) {
            return false;
        }
        InvokeModelRequest other = (InvokeModelRequest) obj;
        return Objects.equals(accept(), other.accept()) && Objects.equals(body(), other.body())
                && Objects.equals(contentType(), other.contentType()) && Objects.equals(modelId(), other.modelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeModelRequest").add("Accept", accept())
                .add("Body", body() == null ? null : "*** Sensitive Data Redacted ***").add("ContentType", contentType())
                .add("ModelId", modelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accept":
            return Optional.ofNullable(clazz.cast(accept()));
        case "body":
            return Optional.ofNullable(clazz.cast(body()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeModelRequest, T> g) {
        return obj -> g.apply((InvokeModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, InvokeModelRequest> {
        /**
         * <p>
         * The desired MIME type of the inference body in the response. The default value is
         * <code>application/json</code>.
         * </p>
         * 
         * @param accept
         *        The desired MIME type of the inference body in the response. The default value is
         *        <code>application/json</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accept(String accept);

        /**
         * <p>
         * Input data in the format specified in the content-type request header. To see the format and content of this
         * field for different models, refer to <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>.
         * </p>
         * 
         * @param body
         *        Input data in the format specified in the content-type request header. To see the format and content
         *        of this field for different models, refer to <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference
         *        parameters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(SdkBytes body);

        /**
         * <p>
         * The MIME type of the input data in the request. The default value is <code>application/json</code>.
         * </p>
         * 
         * @param contentType
         *        The MIME type of the input data in the request. The default value is <code>application/json</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Identifier of the model.
         * </p>
         * 
         * @param modelId
         *        Identifier of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRuntimeRequest.BuilderImpl implements Builder {
        private String accept;

        private SdkBytes body;

        private String contentType;

        private String modelId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeModelRequest model) {
            super(model);
            accept(model.accept);
            body(model.body);
            contentType(model.contentType);
            modelId(model.modelId);
        }

        public final String getAccept() {
            return accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final ByteBuffer getBody() {
            return body == null ? null : body.asByteBuffer();
        }

        public final void setBody(ByteBuffer body) {
            body(body == null ? null : SdkBytes.fromByteBuffer(body));
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeModelRequest build() {
            return new InvokeModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
