/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockruntime.model.BedrockRuntimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeModelWithResponseStreamRequest
extends BedrockRuntimeRequest
implements ToCopyableBuilder<Builder, InvokeModelWithResponseStreamRequest> {
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accept").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::accept)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-Accept").build()}).build();
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("body").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::body)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::contentType)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(InvokeModelWithResponseStreamRequest.getter(InvokeModelWithResponseStreamRequest::modelId)).setter(InvokeModelWithResponseStreamRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_FIELD, BODY_FIELD, CONTENT_TYPE_FIELD, MODEL_ID_FIELD));
    private final String accept;
    private final SdkBytes body;
    private final String contentType;
    private final String modelId;

    private InvokeModelWithResponseStreamRequest(BuilderImpl builder) {
        super(builder);
        this.accept = builder.accept;
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.modelId = builder.modelId;
    }

    public final String accept() {
        return this.accept;
    }

    public final SdkBytes body() {
        return this.body;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeModelWithResponseStreamRequest)) {
            return false;
        }
        InvokeModelWithResponseStreamRequest other = (InvokeModelWithResponseStreamRequest)((Object)obj);
        return Objects.equals(this.accept(), other.accept()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.modelId(), other.modelId());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeModelWithResponseStreamRequest").add("Accept", (Object)this.accept()).add("Body", (Object)(this.body() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).add("ModelId", (Object)this.modelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeModelWithResponseStreamRequest, T> g) {
        return obj -> g.apply((InvokeModelWithResponseStreamRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRuntimeRequest.BuilderImpl
    implements Builder {
        private String accept;
        private SdkBytes body;
        private String contentType;
        private String modelId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeModelWithResponseStreamRequest model) {
            super(model);
            this.accept(model.accept);
            this.body(model.body);
            this.contentType(model.contentType);
            this.modelId(model.modelId);
        }

        public final String getAccept() {
            return this.accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final ByteBuffer getBody() {
            return this.body == null ? null : this.body.asByteBuffer();
        }

        public final void setBody(ByteBuffer body) {
            this.body(body == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)body));
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeModelWithResponseStreamRequest build() {
            return new InvokeModelWithResponseStreamRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockRuntimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeModelWithResponseStreamRequest> {
        public Builder accept(String var1);

        public Builder body(SdkBytes var1);

        public Builder contentType(String var1);

        public Builder modelId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

