/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.CustomOutputStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputSegment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputSegment> {
    private static final SdkField<String> CUSTOM_OUTPUT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customOutputStatus").getter(OutputSegment.getter(OutputSegment::customOutputStatusAsString)).setter(OutputSegment.setter(Builder::customOutputStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customOutputStatus").build()}).build();
    private static final SdkField<String> CUSTOM_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customOutput").getter(OutputSegment.getter(OutputSegment::customOutput)).setter(OutputSegment.setter(Builder::customOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customOutput").build()}).build();
    private static final SdkField<String> STANDARD_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("standardOutput").getter(OutputSegment.getter(OutputSegment::standardOutput)).setter(OutputSegment.setter(Builder::standardOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standardOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_OUTPUT_STATUS_FIELD, CUSTOM_OUTPUT_FIELD, STANDARD_OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutputSegment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String customOutputStatus;
    private final String customOutput;
    private final String standardOutput;

    private OutputSegment(BuilderImpl builder) {
        this.customOutputStatus = builder.customOutputStatus;
        this.customOutput = builder.customOutput;
        this.standardOutput = builder.standardOutput;
    }

    public final CustomOutputStatus customOutputStatus() {
        return CustomOutputStatus.fromValue(this.customOutputStatus);
    }

    public final String customOutputStatusAsString() {
        return this.customOutputStatus;
    }

    public final String customOutput() {
        return this.customOutput;
    }

    public final String standardOutput() {
        return this.standardOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customOutputStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSegment)) {
            return false;
        }
        OutputSegment other = (OutputSegment)obj;
        return Objects.equals(this.customOutputStatusAsString(), other.customOutputStatusAsString()) && Objects.equals(this.customOutput(), other.customOutput()) && Objects.equals(this.standardOutput(), other.standardOutput());
    }

    public final String toString() {
        return ToString.builder((String)"OutputSegment").add("CustomOutputStatus", (Object)this.customOutputStatusAsString()).add("CustomOutput", (Object)this.customOutput()).add("StandardOutput", (Object)this.standardOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customOutputStatus": {
                return Optional.ofNullable(clazz.cast(this.customOutputStatusAsString()));
            }
            case "customOutput": {
                return Optional.ofNullable(clazz.cast(this.customOutput()));
            }
            case "standardOutput": {
                return Optional.ofNullable(clazz.cast(this.standardOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("customOutputStatus", CUSTOM_OUTPUT_STATUS_FIELD);
        map.put("customOutput", CUSTOM_OUTPUT_FIELD);
        map.put("standardOutput", STANDARD_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputSegment, T> g) {
        return obj -> g.apply((OutputSegment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customOutputStatus;
        private String customOutput;
        private String standardOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSegment model) {
            this.customOutputStatus(model.customOutputStatus);
            this.customOutput(model.customOutput);
            this.standardOutput(model.standardOutput);
        }

        public final String getCustomOutputStatus() {
            return this.customOutputStatus;
        }

        public final void setCustomOutputStatus(String customOutputStatus) {
            this.customOutputStatus = customOutputStatus;
        }

        @Override
        public final Builder customOutputStatus(String customOutputStatus) {
            this.customOutputStatus = customOutputStatus;
            return this;
        }

        @Override
        public final Builder customOutputStatus(CustomOutputStatus customOutputStatus) {
            this.customOutputStatus(customOutputStatus == null ? null : customOutputStatus.toString());
            return this;
        }

        public final String getCustomOutput() {
            return this.customOutput;
        }

        public final void setCustomOutput(String customOutput) {
            this.customOutput = customOutput;
        }

        @Override
        public final Builder customOutput(String customOutput) {
            this.customOutput = customOutput;
            return this;
        }

        public final String getStandardOutput() {
            return this.standardOutput;
        }

        public final void setStandardOutput(String standardOutput) {
            this.standardOutput = standardOutput;
        }

        @Override
        public final Builder standardOutput(String standardOutput) {
            this.standardOutput = standardOutput;
            return this;
        }

        public OutputSegment build() {
            return new OutputSegment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputSegment> {
        public Builder customOutputStatus(String var1);

        public Builder customOutputStatus(CustomOutputStatus var1);

        public Builder customOutput(String var1);

        public Builder standardOutput(String var1);
    }
}

