/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomationruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockdataautomationruntime.model.EncryptionContextMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionConfiguration> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(EncryptionConfiguration.getter(EncryptionConfiguration::kmsKeyId)).setter(EncryptionConfiguration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Map<String, String>> KMS_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("kmsEncryptionContext").getter(EncryptionConfiguration.getter(EncryptionConfiguration::kmsEncryptionContext)).setter(EncryptionConfiguration.setter(Builder::kmsEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, KMS_ENCRYPTION_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("kmsKeyId", KMS_KEY_ID_FIELD);
            this.put("kmsEncryptionContext", KMS_ENCRYPTION_CONTEXT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String kmsKeyId;
    private final Map<String, String> kmsEncryptionContext;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.kmsKeyId = builder.kmsKeyId;
        this.kmsEncryptionContext = builder.kmsEncryptionContext;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasKmsEncryptionContext() {
        return this.kmsEncryptionContext != null && !(this.kmsEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> kmsEncryptionContext() {
        return this.kmsEncryptionContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKmsEncryptionContext() ? this.kmsEncryptionContext() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration)obj;
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasKmsEncryptionContext() == other.hasKmsEncryptionContext() && Objects.equals(this.kmsEncryptionContext(), other.kmsEncryptionContext());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptionConfiguration").add("KmsKeyId", (Object)this.kmsKeyId()).add("KmsEncryptionContext", this.hasKmsEncryptionContext() ? this.kmsEncryptionContext() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "kmsEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.kmsEncryptionContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfiguration, T> g) {
        return obj -> g.apply((EncryptionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private Map<String, String> kmsEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            this.kmsKeyId(model.kmsKeyId);
            this.kmsEncryptionContext(model.kmsEncryptionContext);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getKmsEncryptionContext() {
            if (this.kmsEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.kmsEncryptionContext;
        }

        public final void setKmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = EncryptionContextMapCopier.copy(kmsEncryptionContext);
        }

        @Override
        public final Builder kmsEncryptionContext(Map<String, String> kmsEncryptionContext) {
            this.kmsEncryptionContext = EncryptionContextMapCopier.copy(kmsEncryptionContext);
            return this;
        }

        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionConfiguration> {
        public Builder kmsKeyId(String var1);

        public Builder kmsEncryptionContext(Map<String, String> var1);
    }
}

