/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockdataautomation.model.ImageExtractionCategoryType;
import software.amazon.awssdk.services.bedrockdataautomation.model.ImageExtractionCategoryTypesCopier;
import software.amazon.awssdk.services.bedrockdataautomation.model.State;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageExtractionCategory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageExtractionCategory> {
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ImageExtractionCategory.getter(ImageExtractionCategory::stateAsString)).setter(ImageExtractionCategory.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<List<String>> TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("types").getter(ImageExtractionCategory.getter(ImageExtractionCategory::typesAsStrings)).setter(ImageExtractionCategory.setter(Builder::typesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD, TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageExtractionCategory.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String state;
    private final List<String> types;

    private ImageExtractionCategory(BuilderImpl builder) {
        this.state = builder.state;
        this.types = builder.types;
    }

    public final State state() {
        return State.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final List<ImageExtractionCategoryType> types() {
        return ImageExtractionCategoryTypesCopier.copyStringToEnum(this.types);
    }

    public final boolean hasTypes() {
        return this.types != null && !(this.types instanceof SdkAutoConstructList);
    }

    public final List<String> typesAsStrings() {
        return this.types;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypes() ? this.typesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageExtractionCategory)) {
            return false;
        }
        ImageExtractionCategory other = (ImageExtractionCategory)obj;
        return Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTypes() == other.hasTypes() && Objects.equals(this.typesAsStrings(), other.typesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ImageExtractionCategory").add("State", (Object)this.stateAsString()).add("Types", this.hasTypes() ? this.typesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "types": {
                return Optional.ofNullable(clazz.cast(this.typesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state", STATE_FIELD);
        map.put("types", TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageExtractionCategory, T> g) {
        return obj -> g.apply((ImageExtractionCategory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageExtractionCategory model) {
            this.state(model.state);
            this.typesWithStrings(model.types);
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Collection<String> getTypes() {
            if (this.types instanceof SdkAutoConstructList) {
                return null;
            }
            return this.types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = ImageExtractionCategoryTypesCopier.copy(types);
        }

        @Override
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = ImageExtractionCategoryTypesCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typesWithStrings(String ... types) {
            this.typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        public final Builder types(Collection<ImageExtractionCategoryType> types) {
            this.types = ImageExtractionCategoryTypesCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(ImageExtractionCategoryType ... types) {
            this.types(Arrays.asList(types));
            return this;
        }

        public ImageExtractionCategory build() {
            return new ImageExtractionCategory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageExtractionCategory> {
        public Builder state(String var1);

        public Builder state(State var1);

        public Builder typesWithStrings(Collection<String> var1);

        public Builder typesWithStrings(String ... var1);

        public Builder types(Collection<ImageExtractionCategoryType> var1);

        public Builder types(ImageExtractionCategoryType ... var1);
    }
}

