/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.AudioOverrideConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.DocumentOverrideConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.ImageOverrideConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.ModalityRoutingConfiguration;
import software.amazon.awssdk.services.bedrockdataautomation.model.VideoOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OverrideConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OverrideConfiguration> {
    private static final SdkField<DocumentOverrideConfiguration> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("document").getter(OverrideConfiguration.getter(OverrideConfiguration::document)).setter(OverrideConfiguration.setter(Builder::document)).constructor(DocumentOverrideConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()}).build();
    private static final SdkField<ImageOverrideConfiguration> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("image").getter(OverrideConfiguration.getter(OverrideConfiguration::image)).setter(OverrideConfiguration.setter(Builder::image)).constructor(ImageOverrideConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<VideoOverrideConfiguration> VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("video").getter(OverrideConfiguration.getter(OverrideConfiguration::video)).setter(OverrideConfiguration.setter(Builder::video)).constructor(VideoOverrideConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build()}).build();
    private static final SdkField<AudioOverrideConfiguration> AUDIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("audio").getter(OverrideConfiguration.getter(OverrideConfiguration::audio)).setter(OverrideConfiguration.setter(Builder::audio)).constructor(AudioOverrideConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audio").build()}).build();
    private static final SdkField<ModalityRoutingConfiguration> MODALITY_ROUTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modalityRouting").getter(OverrideConfiguration.getter(OverrideConfiguration::modalityRouting)).setter(OverrideConfiguration.setter(Builder::modalityRouting)).constructor(ModalityRoutingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modalityRouting").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD, IMAGE_FIELD, VIDEO_FIELD, AUDIO_FIELD, MODALITY_ROUTING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OverrideConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DocumentOverrideConfiguration document;
    private final ImageOverrideConfiguration image;
    private final VideoOverrideConfiguration video;
    private final AudioOverrideConfiguration audio;
    private final ModalityRoutingConfiguration modalityRouting;

    private OverrideConfiguration(BuilderImpl builder) {
        this.document = builder.document;
        this.image = builder.image;
        this.video = builder.video;
        this.audio = builder.audio;
        this.modalityRouting = builder.modalityRouting;
    }

    public final DocumentOverrideConfiguration document() {
        return this.document;
    }

    public final ImageOverrideConfiguration image() {
        return this.image;
    }

    public final VideoOverrideConfiguration video() {
        return this.video;
    }

    public final AudioOverrideConfiguration audio() {
        return this.audio;
    }

    public final ModalityRoutingConfiguration modalityRouting() {
        return this.modalityRouting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.video());
        hashCode = 31 * hashCode + Objects.hashCode(this.audio());
        hashCode = 31 * hashCode + Objects.hashCode(this.modalityRouting());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverrideConfiguration)) {
            return false;
        }
        OverrideConfiguration other = (OverrideConfiguration)obj;
        return Objects.equals(this.document(), other.document()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.video(), other.video()) && Objects.equals(this.audio(), other.audio()) && Objects.equals(this.modalityRouting(), other.modalityRouting());
    }

    public final String toString() {
        return ToString.builder((String)"OverrideConfiguration").add("Document", (Object)this.document()).add("Image", (Object)this.image()).add("Video", (Object)this.video()).add("Audio", (Object)this.audio()).add("ModalityRouting", (Object)this.modalityRouting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "video": {
                return Optional.ofNullable(clazz.cast(this.video()));
            }
            case "audio": {
                return Optional.ofNullable(clazz.cast(this.audio()));
            }
            case "modalityRouting": {
                return Optional.ofNullable(clazz.cast(this.modalityRouting()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("document", DOCUMENT_FIELD);
        map.put("image", IMAGE_FIELD);
        map.put("video", VIDEO_FIELD);
        map.put("audio", AUDIO_FIELD);
        map.put("modalityRouting", MODALITY_ROUTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OverrideConfiguration, T> g) {
        return obj -> g.apply((OverrideConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DocumentOverrideConfiguration document;
        private ImageOverrideConfiguration image;
        private VideoOverrideConfiguration video;
        private AudioOverrideConfiguration audio;
        private ModalityRoutingConfiguration modalityRouting;

        private BuilderImpl() {
        }

        private BuilderImpl(OverrideConfiguration model) {
            this.document(model.document);
            this.image(model.image);
            this.video(model.video);
            this.audio(model.audio);
            this.modalityRouting(model.modalityRouting);
        }

        public final DocumentOverrideConfiguration.Builder getDocument() {
            return this.document != null ? this.document.toBuilder() : null;
        }

        public final void setDocument(DocumentOverrideConfiguration.BuilderImpl document) {
            this.document = document != null ? document.build() : null;
        }

        @Override
        public final Builder document(DocumentOverrideConfiguration document) {
            this.document = document;
            return this;
        }

        public final ImageOverrideConfiguration.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(ImageOverrideConfiguration.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(ImageOverrideConfiguration image) {
            this.image = image;
            return this;
        }

        public final VideoOverrideConfiguration.Builder getVideo() {
            return this.video != null ? this.video.toBuilder() : null;
        }

        public final void setVideo(VideoOverrideConfiguration.BuilderImpl video) {
            this.video = video != null ? video.build() : null;
        }

        @Override
        public final Builder video(VideoOverrideConfiguration video) {
            this.video = video;
            return this;
        }

        public final AudioOverrideConfiguration.Builder getAudio() {
            return this.audio != null ? this.audio.toBuilder() : null;
        }

        public final void setAudio(AudioOverrideConfiguration.BuilderImpl audio) {
            this.audio = audio != null ? audio.build() : null;
        }

        @Override
        public final Builder audio(AudioOverrideConfiguration audio) {
            this.audio = audio;
            return this;
        }

        public final ModalityRoutingConfiguration.Builder getModalityRouting() {
            return this.modalityRouting != null ? this.modalityRouting.toBuilder() : null;
        }

        public final void setModalityRouting(ModalityRoutingConfiguration.BuilderImpl modalityRouting) {
            this.modalityRouting = modalityRouting != null ? modalityRouting.build() : null;
        }

        @Override
        public final Builder modalityRouting(ModalityRoutingConfiguration modalityRouting) {
            this.modalityRouting = modalityRouting;
            return this;
        }

        public OverrideConfiguration build() {
            return new OverrideConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OverrideConfiguration> {
        public Builder document(DocumentOverrideConfiguration var1);

        default public Builder document(Consumer<DocumentOverrideConfiguration.Builder> document) {
            return this.document((DocumentOverrideConfiguration)((DocumentOverrideConfiguration.Builder)DocumentOverrideConfiguration.builder().applyMutation(document)).build());
        }

        public Builder image(ImageOverrideConfiguration var1);

        default public Builder image(Consumer<ImageOverrideConfiguration.Builder> image) {
            return this.image((ImageOverrideConfiguration)((ImageOverrideConfiguration.Builder)ImageOverrideConfiguration.builder().applyMutation(image)).build());
        }

        public Builder video(VideoOverrideConfiguration var1);

        default public Builder video(Consumer<VideoOverrideConfiguration.Builder> video) {
            return this.video((VideoOverrideConfiguration)((VideoOverrideConfiguration.Builder)VideoOverrideConfiguration.builder().applyMutation(video)).build());
        }

        public Builder audio(AudioOverrideConfiguration var1);

        default public Builder audio(Consumer<AudioOverrideConfiguration.Builder> audio) {
            return this.audio((AudioOverrideConfiguration)((AudioOverrideConfiguration.Builder)AudioOverrideConfiguration.builder().applyMutation(audio)).build());
        }

        public Builder modalityRouting(ModalityRoutingConfiguration var1);

        default public Builder modalityRouting(Consumer<ModalityRoutingConfiguration.Builder> modalityRouting) {
            return this.modalityRouting((ModalityRoutingConfiguration)((ModalityRoutingConfiguration.Builder)ModalityRoutingConfiguration.builder().applyMutation(modalityRouting)).build());
        }
    }
}

