/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceOwner {
    SERVICE("SERVICE"),
    ACCOUNT("ACCOUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceOwner> VALUE_MAP;
    private final String value;

    private ResourceOwner(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceOwner fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceOwner> knownValues() {
        EnumSet<ResourceOwner> knownValues = EnumSet.allOf(ResourceOwner.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceOwner.class, ResourceOwner::toString);
    }
}

