/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockdataautomation.BedrockDataAutomationClient;
import software.amazon.awssdk.services.bedrockdataautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectSummary;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.ListDataAutomationProjectsResponse;

public class ListDataAutomationProjectsIterable
implements SdkIterable<ListDataAutomationProjectsResponse> {
    private final BedrockDataAutomationClient client;
    private final ListDataAutomationProjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataAutomationProjectsIterable(BedrockDataAutomationClient client, ListDataAutomationProjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataAutomationProjectsResponseFetcher();
    }

    public Iterator<ListDataAutomationProjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataAutomationProjectSummary> projects() {
        Function<ListDataAutomationProjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.projects() != null) {
                return response.projects().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataAutomationProjectsResponseFetcher
    implements SyncPageFetcher<ListDataAutomationProjectsResponse> {
        private ListDataAutomationProjectsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataAutomationProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataAutomationProjectsResponse nextPage(ListDataAutomationProjectsResponse previousPage) {
            if (previousPage == null) {
                return ListDataAutomationProjectsIterable.this.client.listDataAutomationProjects(ListDataAutomationProjectsIterable.this.firstRequest);
            }
            return ListDataAutomationProjectsIterable.this.client.listDataAutomationProjects((ListDataAutomationProjectsRequest)((Object)ListDataAutomationProjectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

