/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.DocumentOutputFormat;
import software.amazon.awssdk.services.bedrockdataautomation.model.DocumentStandardExtraction;
import software.amazon.awssdk.services.bedrockdataautomation.model.DocumentStandardGenerativeField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentStandardOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentStandardOutputConfiguration> {
    private static final SdkField<DocumentStandardExtraction> EXTRACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("extraction").getter(DocumentStandardOutputConfiguration.getter(DocumentStandardOutputConfiguration::extraction)).setter(DocumentStandardOutputConfiguration.setter(Builder::extraction)).constructor(DocumentStandardExtraction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()}).build();
    private static final SdkField<DocumentStandardGenerativeField> GENERATIVE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generativeField").getter(DocumentStandardOutputConfiguration.getter(DocumentStandardOutputConfiguration::generativeField)).setter(DocumentStandardOutputConfiguration.setter(Builder::generativeField)).constructor(DocumentStandardGenerativeField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeField").build()}).build();
    private static final SdkField<DocumentOutputFormat> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputFormat").getter(DocumentStandardOutputConfiguration.getter(DocumentStandardOutputConfiguration::outputFormat)).setter(DocumentStandardOutputConfiguration.setter(Builder::outputFormat)).constructor(DocumentOutputFormat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRACTION_FIELD, GENERATIVE_FIELD_FIELD, OUTPUT_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentStandardOutputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DocumentStandardExtraction extraction;
    private final DocumentStandardGenerativeField generativeField;
    private final DocumentOutputFormat outputFormat;

    private DocumentStandardOutputConfiguration(BuilderImpl builder) {
        this.extraction = builder.extraction;
        this.generativeField = builder.generativeField;
        this.outputFormat = builder.outputFormat;
    }

    public final DocumentStandardExtraction extraction() {
        return this.extraction;
    }

    public final DocumentStandardGenerativeField generativeField() {
        return this.generativeField;
    }

    public final DocumentOutputFormat outputFormat() {
        return this.outputFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.extraction());
        hashCode = 31 * hashCode + Objects.hashCode(this.generativeField());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentStandardOutputConfiguration)) {
            return false;
        }
        DocumentStandardOutputConfiguration other = (DocumentStandardOutputConfiguration)obj;
        return Objects.equals(this.extraction(), other.extraction()) && Objects.equals(this.generativeField(), other.generativeField()) && Objects.equals(this.outputFormat(), other.outputFormat());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentStandardOutputConfiguration").add("Extraction", (Object)this.extraction()).add("GenerativeField", (Object)this.generativeField()).add("OutputFormat", (Object)this.outputFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "extraction": {
                return Optional.ofNullable(clazz.cast(this.extraction()));
            }
            case "generativeField": {
                return Optional.ofNullable(clazz.cast(this.generativeField()));
            }
            case "outputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("extraction", EXTRACTION_FIELD);
        map.put("generativeField", GENERATIVE_FIELD_FIELD);
        map.put("outputFormat", OUTPUT_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentStandardOutputConfiguration, T> g) {
        return obj -> g.apply((DocumentStandardOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DocumentStandardExtraction extraction;
        private DocumentStandardGenerativeField generativeField;
        private DocumentOutputFormat outputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentStandardOutputConfiguration model) {
            this.extraction(model.extraction);
            this.generativeField(model.generativeField);
            this.outputFormat(model.outputFormat);
        }

        public final DocumentStandardExtraction.Builder getExtraction() {
            return this.extraction != null ? this.extraction.toBuilder() : null;
        }

        public final void setExtraction(DocumentStandardExtraction.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(DocumentStandardExtraction extraction) {
            this.extraction = extraction;
            return this;
        }

        public final DocumentStandardGenerativeField.Builder getGenerativeField() {
            return this.generativeField != null ? this.generativeField.toBuilder() : null;
        }

        public final void setGenerativeField(DocumentStandardGenerativeField.BuilderImpl generativeField) {
            this.generativeField = generativeField != null ? generativeField.build() : null;
        }

        @Override
        public final Builder generativeField(DocumentStandardGenerativeField generativeField) {
            this.generativeField = generativeField;
            return this;
        }

        public final DocumentOutputFormat.Builder getOutputFormat() {
            return this.outputFormat != null ? this.outputFormat.toBuilder() : null;
        }

        public final void setOutputFormat(DocumentOutputFormat.BuilderImpl outputFormat) {
            this.outputFormat = outputFormat != null ? outputFormat.build() : null;
        }

        @Override
        public final Builder outputFormat(DocumentOutputFormat outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        public DocumentStandardOutputConfiguration build() {
            return new DocumentStandardOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentStandardOutputConfiguration> {
        public Builder extraction(DocumentStandardExtraction var1);

        default public Builder extraction(Consumer<DocumentStandardExtraction.Builder> extraction) {
            return this.extraction((DocumentStandardExtraction)((DocumentStandardExtraction.Builder)DocumentStandardExtraction.builder().applyMutation(extraction)).build());
        }

        public Builder generativeField(DocumentStandardGenerativeField var1);

        default public Builder generativeField(Consumer<DocumentStandardGenerativeField.Builder> generativeField) {
            return this.generativeField((DocumentStandardGenerativeField)((DocumentStandardGenerativeField.Builder)DocumentStandardGenerativeField.builder().applyMutation(generativeField)).build());
        }

        public Builder outputFormat(DocumentOutputFormat var1);

        default public Builder outputFormat(Consumer<DocumentOutputFormat.Builder> outputFormat) {
            return this.outputFormat((DocumentOutputFormat)((DocumentOutputFormat.Builder)DocumentOutputFormat.builder().applyMutation(outputFormat)).build());
        }
    }
}

